/*
 * Decompiled with CFR 0.152.
 */
package org.mapstruct.ap.internal.util;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Elements;
import org.mapstruct.ap.internal.gem.AfterMappingGem;
import org.mapstruct.ap.internal.gem.BeforeMappingGem;
import org.mapstruct.ap.internal.util.accessor.Accessor;
import org.mapstruct.ap.internal.util.workarounds.SpecificCompilerWorkarounds;
import org.mapstruct.ap.spi.TypeHierarchyErroneousException;

public class Executables {
    private static final Method DEFAULT_METHOD;

    private Executables() {
    }

    static boolean isPublicNotStatic(ExecutableElement method) {
        return Executables.isPublic(method) && Executables.isNotStatic(method);
    }

    static boolean isPublic(ExecutableElement method) {
        return method.getModifiers().contains((Object)Modifier.PUBLIC);
    }

    private static boolean isNotStatic(ExecutableElement method) {
        return !method.getModifiers().contains((Object)Modifier.STATIC);
    }

    public static boolean isFinal(Accessor accessor) {
        return accessor != null && accessor.getModifiers().contains((Object)Modifier.FINAL);
    }

    public static boolean isDefaultMethod(ExecutableElement method) {
        try {
            return DEFAULT_METHOD != null && Boolean.TRUE.equals(DEFAULT_METHOD.invoke((Object)method, new Object[0]));
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            return false;
        }
    }

    private static TypeElement asTypeElement(TypeMirror mirror) {
        return (TypeElement)((DeclaredType)mirror).asElement();
    }

    public static List<ExecutableElement> getAllEnclosedExecutableElements(Elements elementUtils, TypeElement element) {
        ArrayList<ExecutableElement> enclosedElements = new ArrayList<ExecutableElement>();
        element = SpecificCompilerWorkarounds.replaceTypeElementIfNecessary(elementUtils, element);
        Executables.addEnclosedElementsInHierarchy(elementUtils, enclosedElements, element, element);
        return enclosedElements;
    }

    private static void addEnclosedElementsInHierarchy(Elements elementUtils, List<ExecutableElement> alreadyAdded, TypeElement element, TypeElement parentType) {
        if (element != parentType) {
            element = SpecificCompilerWorkarounds.replaceTypeElementIfNecessary(elementUtils, element);
        }
        if (element.asType().getKind() == TypeKind.ERROR) {
            throw new TypeHierarchyErroneousException(element);
        }
        Executables.addNotYetOverridden(elementUtils, alreadyAdded, ElementFilter.methodsIn(element.getEnclosedElements()), parentType);
        if (Executables.hasNonObjectSuperclass(element)) {
            Executables.addEnclosedElementsInHierarchy(elementUtils, alreadyAdded, Executables.asTypeElement(element.getSuperclass()), parentType);
        }
        for (TypeMirror typeMirror : element.getInterfaces()) {
            Executables.addEnclosedElementsInHierarchy(elementUtils, alreadyAdded, Executables.asTypeElement(typeMirror), parentType);
        }
    }

    private static void addNotYetOverridden(Elements elementUtils, List<ExecutableElement> alreadyCollected, List<ExecutableElement> methodsToAdd, TypeElement parentType) {
        ArrayList<ExecutableElement> safeToAdd = new ArrayList<ExecutableElement>(methodsToAdd.size());
        for (ExecutableElement toAdd : methodsToAdd) {
            if (!Executables.isNotPrivate(toAdd) || !Executables.isNotObjectEquals(toAdd) || !Executables.wasNotYetOverridden(elementUtils, alreadyCollected, toAdd, parentType)) continue;
            safeToAdd.add(toAdd);
        }
        alreadyCollected.addAll(0, safeToAdd);
    }

    private static boolean isNotObjectEquals(ExecutableElement executable) {
        return !executable.getSimpleName().contentEquals("equals") || executable.getParameters().size() != 1 || !Executables.asTypeElement(executable.getParameters().get(0).asType()).getQualifiedName().contentEquals("java.lang.Object");
    }

    private static boolean isNotPrivate(ExecutableElement executable) {
        return !executable.getModifiers().contains((Object)Modifier.PRIVATE);
    }

    private static boolean wasNotYetOverridden(Elements elementUtils, List<ExecutableElement> alreadyCollected, ExecutableElement executable, TypeElement parentType) {
        ListIterator<ExecutableElement> it = alreadyCollected.listIterator();
        while (it.hasNext()) {
            ExecutableElement executableInSubtype = it.next();
            if (executableInSubtype == null) continue;
            if (elementUtils.overrides(executableInSubtype, executable, parentType)) {
                return false;
            }
            if (!elementUtils.overrides(executable, executableInSubtype, parentType)) continue;
            it.remove();
            return true;
        }
        return true;
    }

    private static boolean hasNonObjectSuperclass(TypeElement element) {
        if (element.getSuperclass().getKind() == TypeKind.ERROR) {
            throw new TypeHierarchyErroneousException(element);
        }
        return element.getSuperclass().getKind() == TypeKind.DECLARED && !Executables.asTypeElement(element.getSuperclass()).getQualifiedName().toString().equals("java.lang.Object");
    }

    public static boolean isLifecycleCallbackMethod(ExecutableElement executableElement) {
        return Executables.isBeforeMappingMethod(executableElement) || Executables.isAfterMappingMethod(executableElement);
    }

    public static boolean isAfterMappingMethod(ExecutableElement executableElement) {
        return AfterMappingGem.instanceOn(executableElement) != null;
    }

    public static boolean isBeforeMappingMethod(ExecutableElement executableElement) {
        return BeforeMappingGem.instanceOn(executableElement) != null;
    }

    static {
        Method method;
        try {
            method = ExecutableElement.class.getMethod("isDefault", new Class[0]);
        }
        catch (NoSuchMethodException e) {
            method = null;
        }
        DEFAULT_METHOD = method;
    }
}

