/*
 * Decompiled with CFR 0.152.
 */
package org.mapstruct.ap.internal.util;

import java.util.LinkedList;
import java.util.List;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Types;
import org.mapstruct.ap.internal.util.AccessorNamingUtils;
import org.mapstruct.ap.internal.util.Collections;
import org.mapstruct.ap.internal.util.Fields;
import org.mapstruct.ap.internal.util.accessor.Accessor;
import org.mapstruct.ap.internal.util.accessor.AccessorType;
import org.mapstruct.ap.internal.util.accessor.ExecutableElementAccessor;
import org.mapstruct.ap.internal.util.accessor.VariableElementAccessor;

public class Filters {
    private final AccessorNamingUtils accessorNaming;
    private final Types typeUtils;
    private final TypeMirror typeMirror;

    public Filters(AccessorNamingUtils accessorNaming, Types typeUtils, TypeMirror typeMirror) {
        this.accessorNaming = accessorNaming;
        this.typeUtils = typeUtils;
        this.typeMirror = typeMirror;
    }

    public List<Accessor> getterMethodsIn(List<ExecutableElement> elements) {
        LinkedList<Accessor> getterMethods = new LinkedList<Accessor>();
        for (ExecutableElement method : elements) {
            if (!this.accessorNaming.isGetterMethod(method)) continue;
            getterMethods.add(new ExecutableElementAccessor(method, this.getReturnType(method), AccessorType.GETTER));
        }
        return getterMethods;
    }

    public List<Accessor> fieldsIn(List<VariableElement> accessors) {
        LinkedList<Accessor> fieldAccessors = new LinkedList<Accessor>();
        for (VariableElement accessor : accessors) {
            if (!Fields.isFieldAccessor(accessor)) continue;
            fieldAccessors.add(new VariableElementAccessor(accessor));
        }
        return fieldAccessors;
    }

    public List<Accessor> presenceCheckMethodsIn(List<ExecutableElement> elements) {
        LinkedList<Accessor> presenceCheckMethods = new LinkedList<Accessor>();
        for (ExecutableElement method : elements) {
            if (!this.accessorNaming.isPresenceCheckMethod(method)) continue;
            presenceCheckMethods.add(new ExecutableElementAccessor(method, this.getReturnType(method), AccessorType.PRESENCE_CHECKER));
        }
        return presenceCheckMethods;
    }

    public List<Accessor> setterMethodsIn(List<ExecutableElement> elements) {
        LinkedList<Accessor> setterMethods = new LinkedList<Accessor>();
        for (ExecutableElement method : elements) {
            if (!this.accessorNaming.isSetterMethod(method)) continue;
            setterMethods.add(new ExecutableElementAccessor(method, this.getFirstParameter(method), AccessorType.SETTER));
        }
        return setterMethods;
    }

    public List<Accessor> adderMethodsIn(List<ExecutableElement> elements) {
        LinkedList<Accessor> adderMethods = new LinkedList<Accessor>();
        for (ExecutableElement method : elements) {
            if (!this.accessorNaming.isAdderMethod(method)) continue;
            adderMethods.add(new ExecutableElementAccessor(method, this.getFirstParameter(method), AccessorType.ADDER));
        }
        return adderMethods;
    }

    private TypeMirror getReturnType(ExecutableElement executableElement) {
        return this.getWithinContext(executableElement).getReturnType();
    }

    private TypeMirror getFirstParameter(ExecutableElement executableElement) {
        return Collections.first(this.getWithinContext(executableElement).getParameterTypes());
    }

    private ExecutableType getWithinContext(ExecutableElement executableElement) {
        return (ExecutableType)this.typeUtils.asMemberOf((DeclaredType)this.typeMirror, executableElement);
    }
}

