/*
 * Decompiled with CFR 0.152.
 */
package org.mapstruct.ap.internal.model.source;

import java.util.Collections;
import java.util.List;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.util.Types;
import org.mapstruct.ap.internal.model.source.SelectionParameters;
import org.mapstruct.ap.internal.prism.BeanMappingPrism;
import org.mapstruct.ap.internal.prism.BuilderPrism;
import org.mapstruct.ap.internal.prism.NullValueCheckStrategyPrism;
import org.mapstruct.ap.internal.prism.NullValueMappingStrategyPrism;
import org.mapstruct.ap.internal.prism.NullValuePropertyMappingStrategyPrism;
import org.mapstruct.ap.internal.prism.ReportingPolicyPrism;
import org.mapstruct.ap.internal.util.FormattingMessager;
import org.mapstruct.ap.internal.util.Message;

public class BeanMapping {
    private final SelectionParameters selectionParameters;
    private final NullValueMappingStrategyPrism nullValueMappingStrategy;
    private final NullValueCheckStrategyPrism nullValueCheckStrategy;
    private final ReportingPolicyPrism reportingPolicy;
    private final boolean ignoreByDefault;
    private final List<String> ignoreUnmappedSourceProperties;
    private final BuilderPrism builder;
    private final NullValuePropertyMappingStrategyPrism nullValuePropertyMappingStrategy;

    public static BeanMapping forInheritance(BeanMapping map) {
        return new BeanMapping(map.selectionParameters, map.nullValueMappingStrategy, map.nullValuePropertyMappingStrategy, map.nullValueCheckStrategy, map.reportingPolicy, false, map.ignoreUnmappedSourceProperties, map.builder);
    }

    public static BeanMapping fromPrism(BeanMappingPrism beanMapping, ExecutableElement method, FormattingMessager messager, Types typeUtils) {
        if (beanMapping == null) {
            return null;
        }
        boolean resultTypeIsDefined = !TypeKind.VOID.equals((Object)beanMapping.resultType().getKind());
        NullValueMappingStrategyPrism nullValueMappingStrategy = null == beanMapping.values.nullValueMappingStrategy() ? null : NullValueMappingStrategyPrism.valueOf(beanMapping.nullValueMappingStrategy());
        NullValuePropertyMappingStrategyPrism nullValuePropertyMappingStrategy = null == beanMapping.values.nullValuePropertyMappingStrategy() ? null : NullValuePropertyMappingStrategyPrism.valueOf(beanMapping.nullValuePropertyMappingStrategy());
        NullValueCheckStrategyPrism nullValueCheckStrategy = null == beanMapping.values.nullValueCheckStrategy() ? null : NullValueCheckStrategyPrism.valueOf(beanMapping.nullValueCheckStrategy());
        boolean ignoreByDefault = beanMapping.ignoreByDefault();
        BuilderPrism builderMapping = null;
        if (beanMapping.values.builder() != null) {
            builderMapping = beanMapping.builder();
        }
        if (!resultTypeIsDefined && beanMapping.qualifiedBy().isEmpty() && beanMapping.qualifiedByName().isEmpty() && beanMapping.ignoreUnmappedSourceProperties().isEmpty() && nullValueMappingStrategy == null && nullValuePropertyMappingStrategy == null && nullValueCheckStrategy == null && !ignoreByDefault && builderMapping == null) {
            messager.printMessage((Element)method, Message.BEANMAPPING_NO_ELEMENTS, new Object[0]);
        }
        SelectionParameters cmp = new SelectionParameters(beanMapping.qualifiedBy(), beanMapping.qualifiedByName(), resultTypeIsDefined ? beanMapping.resultType() : null, typeUtils);
        return new BeanMapping(cmp, nullValueMappingStrategy, nullValuePropertyMappingStrategy, nullValueCheckStrategy, null, ignoreByDefault, beanMapping.ignoreUnmappedSourceProperties(), builderMapping);
    }

    public static BeanMapping forForgedMethods() {
        return new BeanMapping(null, null, null, null, ReportingPolicyPrism.IGNORE, false, Collections.emptyList(), null);
    }

    private BeanMapping(SelectionParameters selectionParameters, NullValueMappingStrategyPrism nvms, NullValuePropertyMappingStrategyPrism nvpms, NullValueCheckStrategyPrism nvcs, ReportingPolicyPrism reportingPolicy, boolean ignoreByDefault, List<String> ignoreUnmappedSourceProperties, BuilderPrism builder) {
        this.selectionParameters = selectionParameters;
        this.nullValueMappingStrategy = nvms;
        this.nullValuePropertyMappingStrategy = nvpms;
        this.nullValueCheckStrategy = nvcs;
        this.reportingPolicy = reportingPolicy;
        this.ignoreByDefault = ignoreByDefault;
        this.ignoreUnmappedSourceProperties = ignoreUnmappedSourceProperties;
        this.builder = builder;
    }

    public SelectionParameters getSelectionParameters() {
        return this.selectionParameters;
    }

    public NullValueMappingStrategyPrism getNullValueMappingStrategy() {
        return this.nullValueMappingStrategy;
    }

    public NullValuePropertyMappingStrategyPrism getNullValuePropertyMappingStrategy() {
        return this.nullValuePropertyMappingStrategy;
    }

    public NullValueCheckStrategyPrism getNullValueCheckStrategy() {
        return this.nullValueCheckStrategy;
    }

    public ReportingPolicyPrism getReportingPolicy() {
        return this.reportingPolicy;
    }

    public boolean isignoreByDefault() {
        return this.ignoreByDefault;
    }

    public List<String> getIgnoreUnmappedSourceProperties() {
        return this.ignoreUnmappedSourceProperties;
    }

    public BuilderPrism getBuilder() {
        return this.builder;
    }
}

