/*
 * Decompiled with CFR 0.152.
 */
package org.mapstruct.ap.internal.model;

import java.util.List;
import java.util.Set;
import org.mapstruct.ap.internal.model.MapperReference;
import org.mapstruct.ap.internal.model.common.Type;
import org.mapstruct.ap.internal.model.common.TypeFactory;
import org.mapstruct.ap.internal.util.Collections;
import org.mapstruct.ap.internal.util.Strings;

public class DefaultMapperReference
extends MapperReference {
    private final boolean isAnnotatedMapper;
    private final Set<Type> importTypes;

    private DefaultMapperReference(Type type, boolean isAnnotatedMapper, Set<Type> importTypes, String variableName) {
        super(type, variableName);
        this.isAnnotatedMapper = isAnnotatedMapper;
        this.importTypes = importTypes;
    }

    public static DefaultMapperReference getInstance(Type type, boolean isAnnotatedMapper, TypeFactory typeFactory, List<String> otherMapperReferences) {
        Set<Type> importTypes = Collections.asSet(type);
        if (isAnnotatedMapper) {
            importTypes.add(typeFactory.getType("org.mapstruct.factory.Mappers"));
        }
        String variableName = Strings.getSaveVariableName(type.getName(), otherMapperReferences);
        return new DefaultMapperReference(type, isAnnotatedMapper, importTypes, variableName);
    }

    @Override
    public Set<Type> getImportTypes() {
        return this.importTypes;
    }

    public boolean isAnnotatedMapper() {
        return this.isAnnotatedMapper;
    }
}

