/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.tools;

import com.datical.liquibase.ext.tools.AbstractNativeToolExecutor;
import com.datical.liquibase.ext.tools.SqlPlusRunner;
import java.util.List;
import liquibase.Scope;
import liquibase.exception.DatabaseException;
import liquibase.sql.Sql;
import liquibase.sql.visitor.SqlVisitor;
import liquibase.sqlgenerator.SqlGeneratorFactory;
import liquibase.statement.SqlStatement;

public class OracleSqlPlusExecutor
extends AbstractNativeToolExecutor {
    public OracleSqlPlusExecutor() {
        super("sqlplus");
    }

    @Override
    public String getName() {
        return "sqlplus";
    }

    @Override
    public int getPriority() {
        return 101;
    }

    @Override
    public void execute(SqlStatement object, List<SqlVisitor> object2) {
        object2 = Scope.getCurrentScope().getLog(this.getClass());
        object2.info("Executing with the '" + this.getName() + "' executor");
        object = SqlGeneratorFactory.getInstance().generateSql((SqlStatement)object, this.database);
        try {
            SqlPlusRunner sqlPlusRunner = new SqlPlusRunner(this.changeSet, null, true);
            sqlPlusRunner.addArg("-v");
            sqlPlusRunner.executeCommand(this.database);
            object2.info("Successfully validated 'sqlplus'");
            new SqlPlusRunner(this.changeSet, (Sql[])object, false).executeCommand(this.database);
            object = String.format("%nSuccess!  Changeset '%s' by '%s' deployed by 'sqlplus'", this.changeSet.getId(), this.changeSet.getAuthor());
            object2.info((String)object);
            return;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw illegalArgumentException;
        }
        catch (Exception exception) {
            object = String.format("%nChangeset '%s' by '%s' failed to deploy with 'sqlplus'. Please check sqlplus logs or use the --log-level flag for more information.", this.changeSet.getId(), this.changeSet.getAuthor());
            object2.info((String)object);
            object2.info(exception.getMessage());
            throw new DatabaseException(exception);
        }
    }
}

