/*
 * Decompiled with CFR 0.152.
 */
package org.lionsoul.jcseg.util;

public class Sort {
    private static final int CUTOFF = 11;
    private static final int[] GAPS = new int[]{1, 5, 19, 41, 109, 209, 505, 929, 2161, 8929, 16001, 36289, 64769, 146305, 260609, 587521, 1045505, 2354689, 4188161, 9427969, 16764929, 37730305, 67084289, 150958081, 268386305, 603906049, 1073643521, Integer.MAX_VALUE};

    public static <T extends Comparable<? super T>> void insertionSort(T[] arr) {
        for (int i = 1; i < arr.length; ++i) {
            int j;
            T tmp = arr[i];
            for (j = i; j > 0 && tmp.compareTo(arr[j - 1]) < 0; --j) {
                arr[j] = arr[j - 1];
            }
            if (j >= i) continue;
            arr[j] = tmp;
        }
    }

    public static <T extends Comparable<? super T>> void shellSort(T[] arr) {
        int k = 0;
        while (GAPS[k] < arr.length) {
            ++k;
        }
        while (k-- > 0) {
            int gap;
            for (int i = gap = GAPS[k]; i < arr.length; ++i) {
                int j;
                T tmp = arr[i];
                for (j = i; j >= gap && tmp.compareTo(arr[j - gap]) < 0; j -= gap) {
                    arr[j] = arr[j - gap];
                }
                if (j >= i) continue;
                arr[j] = tmp;
            }
        }
    }

    public static <T extends Comparable<? super T>> void mergeSort(T[] arr) {
        Comparable[] tmpArr = new Comparable[arr.length];
        Sort.mergeSort(arr, (Comparable[])tmpArr, (int)0, (int)(arr.length - 1));
    }

    private static <T extends Comparable<? super T>> void mergeSort(T[] arr, T[] tmpArr, int left, int right) {
        if (left < right) {
            int center = (left + right) / 2;
            Sort.mergeSort(arr, tmpArr, (int)left, (int)center);
            Sort.mergeSort(arr, tmpArr, (int)(center + 1), (int)right);
            Sort.merge(arr, tmpArr, (int)left, (int)(center + 1), (int)right);
        }
    }

    private static <T extends Comparable<? super T>> void merge(T[] arr, T[] tmpArr, int lPos, int rPos, int rEnd) {
        int lEnd = rPos - 1;
        int tPos = lPos;
        int leftTmp = lPos;
        while (lPos <= lEnd && rPos <= rEnd) {
            if (arr[lPos].compareTo(arr[rPos]) <= 0) {
                tmpArr[tPos++] = arr[lPos++];
                continue;
            }
            tmpArr[tPos++] = arr[rPos++];
        }
        while (lPos <= lEnd) {
            tmpArr[tPos++] = arr[lPos++];
        }
        while (rPos <= rEnd) {
            tmpArr[tPos++] = arr[rPos++];
        }
        while (rEnd >= leftTmp) {
            arr[rEnd] = tmpArr[rEnd];
            --rEnd;
        }
    }

    private static <T> void swapReferences(T[] arr, int idx1, int idx2) {
        T tmp = arr[idx1];
        arr[idx1] = arr[idx2];
        arr[idx2] = tmp;
    }

    public static <T extends Comparable<? super T>> void quicksort(T[] arr) {
        Sort.quicksort(arr, (int)0, (int)(arr.length - 1));
    }

    private static <T extends Comparable<? super T>> T median(T[] arr, int left, int right) {
        int center = (left + right) / 2;
        if (arr[left].compareTo(arr[center]) > 0) {
            Sort.swapReferences(arr, left, center);
        }
        if (arr[left].compareTo(arr[right]) > 0) {
            Sort.swapReferences(arr, left, right);
        }
        if (arr[center].compareTo(arr[right]) > 0) {
            Sort.swapReferences(arr, center, right);
        }
        Sort.swapReferences(arr, center, right - 1);
        return arr[right - 1];
    }

    public static <T extends Comparable<? super T>> void insertionSort(T[] arr, int start, int end) {
        for (int j = start + 1; j <= end; ++j) {
            int i;
            T tmp = arr[j];
            for (i = j; i > start && tmp.compareTo(arr[i - 1]) < 0; --i) {
                arr[i] = arr[i - 1];
            }
            if (i >= j) continue;
            arr[i] = tmp;
        }
    }

    private static <T extends Comparable<? super T>> void quicksort(T[] arr, int left, int right) {
        if (left + 11 <= right) {
            Comparable pivot = Sort.median(arr, (int)left, (int)right);
            int i = left;
            int j = right - 1;
            while (true) {
                if (arr[++i].compareTo((Comparable)pivot) < 0) {
                    continue;
                }
                while (arr[--j].compareTo((Comparable)pivot) > 0) {
                }
                if (i >= j) break;
                Sort.swapReferences(arr, i, j);
            }
            Sort.swapReferences(arr, i, right - 1);
            Sort.quicksort(arr, (int)left, (int)(i - 1));
            Sort.quicksort(arr, (int)(i + 1), (int)right);
        } else {
            Sort.insertionSort(arr, (int)left, (int)right);
        }
    }

    public static <T extends Comparable<? super T>> void quickSelect(T[] arr, int k) {
        Sort.quickSelect(arr, (int)0, (int)(arr.length - 1), (int)k);
    }

    private static <T extends Comparable<? super T>> void quickSelect(T[] arr, int left, int right, int k) {
        if (left + 11 <= right) {
            Comparable pivot = Sort.median(arr, (int)left, (int)right);
            int i = left;
            int j = right - 1;
            while (true) {
                if (arr[++i].compareTo((Comparable)pivot) < 0) {
                    continue;
                }
                while (arr[--j].compareTo((Comparable)pivot) > 0) {
                }
                if (i >= j) break;
                Sort.swapReferences(arr, i, j);
            }
            Sort.swapReferences(arr, i, right - 1);
            if (k <= i) {
                Sort.quickSelect(arr, (int)left, (int)(i - 1), (int)k);
            } else if (k > i + 1) {
                Sort.quickSelect(arr, (int)(i + 1), (int)right, (int)k);
            }
        } else {
            Sort.insertionSort(arr, (int)left, (int)right);
        }
    }

    public static void bucketSort(int[] arr, int m) {
        int j;
        int[] count = new int[m];
        int i = 0;
        for (j = 0; j < arr.length; ++j) {
            int n = arr[j];
            count[n] = count[n] + 1;
        }
        block1: for (j = 0; j < m; ++j) {
            if (count[j] <= 0) continue;
            while (true) {
                int n = j;
                int n2 = count[n];
                count[n] = n2 - 1;
                if (n2 <= 0) continue block1;
                arr[i++] = j;
            }
        }
    }

    public static void bucketSort(Integer[] arr, int m) {
        int j;
        int[] count = new int[m];
        int i = 0;
        for (j = 0; j < arr.length; ++j) {
            int n = arr[j];
            count[n] = count[n] + 1;
        }
        block1: for (j = 0; j < m; ++j) {
            if (count[j] <= 0) continue;
            while (true) {
                int n = j;
                int n2 = count[n];
                count[n] = n2 - 1;
                if (n2 <= 0) continue block1;
                arr[i++] = i;
            }
        }
    }
}

