/*
 * Decompiled with CFR 0.152.
 */
package org.lionsoul.jcseg.sentence;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import org.lionsoul.jcseg.sentence.Sentence;
import org.lionsoul.jcseg.util.IPushbackReader;
import org.lionsoul.jcseg.util.IStringBuffer;
import org.lionsoul.jcseg.util.StringUtil;

public class SentenceSeg {
    private static final int MAX_QUOTE_LENGTH = 15;
    protected int idx;
    protected IPushbackReader reader = null;
    protected final IStringBuffer gIsb = new IStringBuffer();

    public SentenceSeg(Reader reader) throws IOException {
        this.reset(reader);
    }

    public SentenceSeg() throws IOException {
        this(null);
    }

    public void reset(Reader input) throws IOException {
        if (input != null) {
            this.reader = new IPushbackReader(new BufferedReader(input));
        }
        this.idx = -1;
    }

    protected int readNext() throws IOException {
        int c = this.reader.read();
        if (c != -1) {
            ++this.idx;
        }
        return c;
    }

    public Sentence next() throws IOException {
        int c;
        this.gIsb.clear();
        int pos = -1;
        block15: while ((c = this.readNext()) != -1) {
            int chr;
            if (StringUtil.isWhitespace(c) || c == 10 || c == 9 || c == 8230) continue;
            if (StringUtil.isCnPunctuation(c)) {
                switch ((char)c) {
                    case '\u201c': 
                    case '\u300a': 
                    case '\u3010': 
                    case '\uff08': 
                    case '\uff5b': {
                        break;
                    }
                    default: {
                        continue block15;
                    }
                }
            }
            if (StringUtil.isEnPunctuation(c)) {
                switch ((char)c) {
                    case '\"': {
                        break;
                    }
                    default: {
                        continue block15;
                    }
                }
            }
            pos = this.idx;
            this.gIsb.clear().append((char)c);
            block16: while ((c = this.readNext()) != -1) {
                boolean endTag = false;
                switch ((char)c) {
                    case '\"': {
                        this.gIsb.append('\"');
                        this.readUntil('\"');
                        break;
                    }
                    case '\u201c': {
                        this.gIsb.append('\u201c');
                        this.readUntil('\u201d');
                        break;
                    }
                    case '\u3010': {
                        this.gIsb.append('\u3010');
                        this.readUntil('\u3011');
                        break;
                    }
                    case '\u300a': {
                        this.gIsb.append('\u300a');
                        this.readUntil('\u300b');
                        break;
                    }
                    case '.': {
                        chr = this.readNext();
                        this.gIsb.append((char)c);
                        if (StringUtil.isEnLetter(chr)) {
                            this.reader.unread(chr);
                            continue block16;
                        }
                        endTag = true;
                        break;
                    }
                    case '!': 
                    case ';': 
                    case '?': 
                    case '\u2026': 
                    case '\u3002': 
                    case '\uff01': 
                    case '\uff1b': 
                    case '\uff1f': {
                        endTag = true;
                        this.gIsb.append((char)c);
                        break;
                    }
                    case '\n': 
                    case ':': 
                    case '\uff1a': {
                        endTag = true;
                        break;
                    }
                    default: {
                        this.gIsb.append((char)c);
                    }
                }
                if (!endTag) continue;
                break;
            }
            for (int i = this.gIsb.length() - 1; i >= 0 && ((chr = (int)this.gIsb.charAt(i)) == 32 || chr == 9); --i) {
                this.gIsb.deleteCharAt(i);
            }
            if (this.gIsb.length() <= 1) continue;
            return new Sentence(this.gIsb.toString(), pos);
        }
        return null;
    }

    protected void readUntil(char eChar) throws IOException {
        int ch;
        int i = 0;
        IStringBuffer sb = new IStringBuffer();
        while ((ch = this.readNext()) != -1) {
            if (++i >= 15) {
                for (int j = sb.length() - 1; j >= 0; --j) {
                    this.reader.unread(sb.charAt(j));
                }
                this.idx -= sb.length();
                break;
            }
            sb.append((char)ch);
            if (ch != eChar) continue;
            this.gIsb.append(sb.toString());
            break;
        }
    }
}

