/*
 * Decompiled with CFR 0.152.
 */
package org.lionsoul.jcseg.segmenter;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URLDecoder;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.Map;
import java.util.Properties;
import org.lionsoul.jcseg.util.Util;

public class SegmenterConfig
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final String LEX_PROPERTY_FILE = "jcseg.properties";
    public int MAX_LENGTH = 5;
    public int MAX_LATIN_LENGTH = 64;
    public int MAX_UNIT_LENGTH = 5;
    public boolean I_CN_NAME = false;
    public int MAX_CN_LNADRON = 1;
    public boolean LOAD_CJK_PINYIN = true;
    public boolean APPEND_CJK_PINYIN = false;
    public boolean LOAD_CJK_POS = true;
    public boolean APPEND_PART_OF_SPEECH = false;
    public boolean LOAD_CJK_SYN = true;
    public boolean APPEND_CJK_SYN = false;
    public boolean LOAD_CJK_ENTITY = true;
    public boolean APPEND_CJK_ENTITY = true;
    public boolean LOAD_PARAMETER = true;
    public int NAME_SINGLE_THRESHOLD = 1000000;
    public int PPT_MAX_LENGTH = 15;
    public boolean CLEAR_STOPWORD = false;
    public boolean CNNUM_TO_ARABIC = true;
    public boolean CNFRA_TO_ARABIC = true;
    public boolean EN_SECOND_SEG = true;
    public int EN_SEC_MIN_LEN = 1;
    public int EN_MAX_LEN = 16;
    public boolean EN_WORD_SEG = true;
    private String KEEP_PUNCTUATIONS = "@%&.'#+";
    private char DELIMITER = (char)32;
    private byte GRAM = 1;
    public boolean KEEP_UNREG_WORDS = false;
    private String[] lexPath = null;
    private boolean lexAutoload = false;
    private int pollTime = 10;
    private String pFile = null;
    private boolean keepEnSecOriginalWord;
    private boolean keepEnSegOriginalWord;

    public SegmenterConfig() {
    }

    public SegmenterConfig(boolean autoLoad) {
        if (autoLoad) {
            try {
                this.autoLoad();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public SegmenterConfig(String proFile) {
        try {
            this.load(proFile);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public SegmenterConfig(InputStream is) {
        try {
            this.load(is);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void load(String proFile) throws IOException {
        this.load(Files.newInputStream(Paths.get(proFile, new String[0]), new OpenOption[0]));
    }

    public void autoLoad() throws IOException {
        File proFile = new File(Util.getJarHome(this) + "/" + LEX_PROPERTY_FILE);
        if (proFile.exists()) {
            this.pFile = proFile.getAbsolutePath();
            this.load(proFile.getAbsolutePath());
            return;
        }
        InputStream is = this.getClass().getResourceAsStream("/jcseg.properties");
        if (is != null) {
            this.pFile = "classpath/jcseg.properties";
            this.load(is);
            return;
        }
        proFile = new File(System.getProperty("user.home") + "/" + LEX_PROPERTY_FILE);
        if (proFile.exists()) {
            this.pFile = proFile.getAbsolutePath();
            this.load(proFile.getAbsolutePath());
        }
        String errString = "jcseg properties \"jcseg.properties]\" file auto loaded failed: \n";
        errString = errString + "try the follwing ways to solve the problem: \n";
        errString = errString + "1. put jcseg.properties into the classpath.\n";
        errString = errString + "2. put jcseg.properties together with the jcseg-core-{version}.jar file.\n";
        errString = errString + "3. put jcseg.properties in directory " + System.getProperty("user.home") + "\n\n";
        throw new IOException(errString);
    }

    public void load(InputStream is) throws IOException {
        Properties lexPro = new Properties();
        lexPro.load(new BufferedInputStream(is));
        for (Map.Entry<Object, Object> entry : lexPro.entrySet()) {
            this.set(entry.getKey().toString(), entry.getValue().toString());
        }
    }

    private static boolean configBoolStatus(String value) {
        return value.equals("1") || value.equals("true") || value.equals("on");
    }

    public void set(String key, String value) throws IOException {
        if ("lexicon.path".equals(key)) {
            if (value == null) {
                throw new IOException("Missing lexicon.path property in jcseg.properties file!!!");
            }
            if (!"null".equalsIgnoreCase(value)) {
                if (value.contains("{jar.dir}")) {
                    value = value.replace("{jar.dir}", Util.getJarHome(this));
                }
                this.lexPath = value.split(";");
                for (int i = 0; i < this.lexPath.length; ++i) {
                    this.lexPath[i] = URLDecoder.decode(this.lexPath[i], "UTF-8");
                    File f = new File(this.lexPath[i]);
                    if (f.exists()) continue;
                    throw new IOException("Invalid sub lexicon path " + this.lexPath[i] + " for lexicon.path in jcseg.properties");
                }
            }
        } else if ("jcseg.maxlen".equals(key)) {
            this.MAX_LENGTH = Integer.parseInt(value);
        } else if ("jcseg.icnname".equals(key)) {
            this.I_CN_NAME = SegmenterConfig.configBoolStatus(value);
        } else if ("jcseg.cnmaxlnadron".equals(key)) {
            this.MAX_CN_LNADRON = Integer.parseInt(value);
        } else if ("jcseg.nsthreshold".equals(key)) {
            this.NAME_SINGLE_THRESHOLD = Integer.parseInt(value);
        } else if ("jcseg.pptmaxlen".equals(key)) {
            this.PPT_MAX_LENGTH = Integer.parseInt(value);
        } else if ("jcseg.loadpinyin".equals(key)) {
            this.LOAD_CJK_PINYIN = SegmenterConfig.configBoolStatus(value);
        } else if ("jcseg.appendpinyin".equals(key)) {
            this.APPEND_CJK_PINYIN = SegmenterConfig.configBoolStatus(value);
        } else if ("jcseg.loadsyn".equals(key)) {
            this.LOAD_CJK_SYN = SegmenterConfig.configBoolStatus(value);
        } else if ("jcseg.appendsyn".equals(key)) {
            this.APPEND_CJK_SYN = SegmenterConfig.configBoolStatus(value);
        } else if ("jcseg.loadpos".equals(key)) {
            this.LOAD_CJK_POS = SegmenterConfig.configBoolStatus(value);
        } else if ("jcseg.loadentity".equals(key)) {
            this.LOAD_CJK_ENTITY = SegmenterConfig.configBoolStatus(value);
        } else if ("jcseg.loadparameter".equals(key)) {
            this.LOAD_PARAMETER = SegmenterConfig.configBoolStatus(value);
        } else if ("jcseg.clearstopword".equals(key)) {
            this.CLEAR_STOPWORD = SegmenterConfig.configBoolStatus(value);
        } else if ("jcseg.cnnumtoarabic".equals(key)) {
            this.CNNUM_TO_ARABIC = SegmenterConfig.configBoolStatus(value);
        } else if ("jcseg.cnfratoarabic".equals(key)) {
            this.CNFRA_TO_ARABIC = SegmenterConfig.configBoolStatus(value);
        } else if ("jcseg.keepunregword".equals(key)) {
            this.KEEP_UNREG_WORDS = SegmenterConfig.configBoolStatus(value);
        } else if ("lexicon.autoload".equals(key)) {
            this.lexAutoload = SegmenterConfig.configBoolStatus(value);
        } else if ("lexicon.polltime".equals(key)) {
            this.pollTime = Integer.parseInt(value);
        } else if ("jcseg.ensecondseg".equals(key)) {
            this.EN_SECOND_SEG = SegmenterConfig.configBoolStatus(value);
        } else if ("jcseg.ensecminlen".equals(key)) {
            this.EN_SEC_MIN_LEN = Integer.parseInt(value);
        } else if ("jcseg.enmaxlen".equals(key)) {
            this.EN_MAX_LEN = Integer.parseInt(value);
        } else if ("jcseg.enwordseg".equals(key)) {
            this.EN_WORD_SEG = SegmenterConfig.configBoolStatus(value);
        } else if ("jcseg.keeppunctuations".equals(key)) {
            this.KEEP_PUNCTUATIONS = value;
        } else if ("jcseg.delimiter".equals(key)) {
            this.DELIMITER = (char)(value.equals("whitespace") || value.equals("default") ? 32 : (int)value.charAt(0));
        } else if ("jcseg.gram".equals(key)) {
            this.GRAM = value.equals("default") ? (byte)1 : Byte.valueOf(value);
        }
    }

    public String[] getLexiconPath() {
        return this.lexPath;
    }

    public void setLexiconPath(String[] lexPath) {
        this.lexPath = lexPath;
    }

    public boolean isAutoload() {
        return this.lexAutoload;
    }

    public void setAutoload(boolean autoload) {
        this.lexAutoload = autoload;
    }

    public int getPollTime() {
        return this.pollTime;
    }

    public void setPollTime(int polltime) {
        this.pollTime = polltime;
    }

    public int getMaxLength() {
        return this.MAX_LENGTH;
    }

    public void setMaxLength(int maxLength) {
        this.MAX_LENGTH = maxLength;
    }

    public boolean identifyCnName() {
        return this.I_CN_NAME;
    }

    public void setICnName(boolean iCnName) {
        this.I_CN_NAME = iCnName;
    }

    public int getMaxCnLnadron() {
        return this.MAX_CN_LNADRON;
    }

    public void setMaxCnLnadron(int maxCnLnadron) {
        this.MAX_CN_LNADRON = maxCnLnadron;
    }

    public boolean loadCJKPinyin() {
        return this.LOAD_CJK_PINYIN;
    }

    public void setLoadCJKPinyin(boolean loadCJKPinyin) {
        this.LOAD_CJK_PINYIN = loadCJKPinyin;
    }

    public void setAppendPartOfSpeech(boolean partOfSpeech) {
        this.APPEND_PART_OF_SPEECH = partOfSpeech;
    }

    public boolean appendCJKPinyin() {
        return this.APPEND_CJK_PINYIN;
    }

    public void setAppendCJKPinyin(boolean appendCJKPinyin) {
        this.APPEND_CJK_PINYIN = appendCJKPinyin;
    }

    public boolean loadCJKSyn() {
        return this.LOAD_CJK_SYN;
    }

    public void setLoadCJKSyn(boolean loadCJKSyn) {
        this.LOAD_CJK_SYN = loadCJKSyn;
    }

    public boolean appendCJKSyn() {
        return this.APPEND_CJK_SYN;
    }

    public void setAppendCJKSyn(boolean appendCJKPinyin) {
        this.APPEND_CJK_SYN = appendCJKPinyin;
    }

    public boolean ladCJKPos() {
        return this.LOAD_CJK_POS;
    }

    public void setLoadCJKPos(boolean loadCJKPos) {
        this.LOAD_CJK_POS = loadCJKPos;
    }

    public boolean loadCJKEntity() {
        return this.LOAD_CJK_ENTITY;
    }

    public void setLoadEntity(boolean loadEntity) {
        this.LOAD_CJK_ENTITY = loadEntity;
    }

    public int getNameSingleThreshold() {
        return this.NAME_SINGLE_THRESHOLD;
    }

    public void setNameSingleThreshold(int thresold) {
        this.NAME_SINGLE_THRESHOLD = thresold;
    }

    public int getPPTMaxLength() {
        return this.PPT_MAX_LENGTH;
    }

    public void setPPT_MAX_LENGTH(int pptMaxLength) {
        this.PPT_MAX_LENGTH = pptMaxLength;
    }

    public boolean clearStopwords() {
        return this.CLEAR_STOPWORD;
    }

    public void setClearStopwords(boolean clearstopwords) {
        this.CLEAR_STOPWORD = clearstopwords;
    }

    public boolean cnNumToArabic() {
        return this.CNNUM_TO_ARABIC;
    }

    public void setCnNumToArabic(boolean cnNumToArabic) {
        this.CNNUM_TO_ARABIC = cnNumToArabic;
    }

    public boolean cnFractionToArabic() {
        return this.CNFRA_TO_ARABIC;
    }

    public void setCnFactionToArabic(boolean cnFractionToArabic) {
        this.CNFRA_TO_ARABIC = cnFractionToArabic;
    }

    public boolean getEnSecondSeg() {
        return this.EN_SECOND_SEG;
    }

    public void setEnSecondSeg(boolean enSecondSeg) {
        this.EN_SECOND_SEG = enSecondSeg;
    }

    public int getEnSecondMinLen() {
        return this.EN_SEC_MIN_LEN;
    }

    public void setEnSecondMinLen(int minLen) {
        this.EN_SEC_MIN_LEN = minLen;
    }

    public int getEnMaxLen() {
        return this.EN_MAX_LEN;
    }

    public void setEnMaxLen(int enMaxLen) {
        this.EN_MAX_LEN = enMaxLen;
    }

    public boolean isEnWordSeg() {
        return this.EN_WORD_SEG;
    }

    public void setEnWordSeg(boolean enWordSeg) {
        this.EN_WORD_SEG = enWordSeg;
    }

    public void setKeepPunctuations(String keepPunctuations) {
        this.KEEP_PUNCTUATIONS = keepPunctuations;
    }

    public boolean isKeepPunctuation(char c) {
        return this.KEEP_PUNCTUATIONS.indexOf(c) > -1;
    }

    public char getDELIMITER() {
        return this.DELIMITER;
    }

    public void setDELIMITER(char dELIMITER) {
        this.DELIMITER = dELIMITER;
    }

    public byte getGRAM() {
        return this.GRAM;
    }

    public void setGRAM(byte gRAM) {
        this.GRAM = gRAM;
    }

    public boolean keepUnregWords() {
        return this.KEEP_UNREG_WORDS;
    }

    public void setKeepUnregWords(boolean keepUnregWords) {
        this.KEEP_UNREG_WORDS = keepUnregWords;
    }

    public String getPropertieFile() {
        return this.pFile;
    }

    public boolean isKeepEnSecOriginalWord() {
        return this.keepEnSecOriginalWord;
    }

    public void setKeepEnSecOriginalWord(boolean keepEnSecOriginalWord) {
        this.keepEnSecOriginalWord = keepEnSecOriginalWord;
    }

    public boolean isKeepEnSegOriginalWord() {
        return this.keepEnSegOriginalWord;
    }

    public void setKeepEnSegOriginalWord(boolean keepEnSegOriginalWord) {
        this.keepEnSegOriginalWord = keepEnSegOriginalWord;
    }

    public SegmenterConfig clone() throws CloneNotSupportedException {
        return (SegmenterConfig)super.clone();
    }
}

