/*
 * Decompiled with CFR 0.152.
 */
package org.lionsoul.jcseg.segmenter;

import java.util.ArrayList;
import org.lionsoul.jcseg.IChunk;

public class MMSegFilter {
    public static ArrayList<IChunk> getMaximumMatchChunks(ArrayList<IChunk> inChunks, ArrayList<IChunk> outChunks) {
        int maxLength = inChunks.get(0).getLength();
        for (int j = 1; j < inChunks.size(); ++j) {
            int l = inChunks.get(j).getLength();
            if (l <= maxLength) continue;
            maxLength = l;
        }
        outChunks.clear();
        for (IChunk c : inChunks) {
            if (c.getLength() != maxLength) continue;
            outChunks.add(c);
        }
        return outChunks;
    }

    public static ArrayList<IChunk> getLargestAverageWordLengthChunks(ArrayList<IChunk> inChunks, ArrayList<IChunk> outChunks) {
        double largestAverage = inChunks.get(0).getAverageWordsLength();
        for (int j = 1; j < inChunks.size(); ++j) {
            double avg = inChunks.get(j).getAverageWordsLength();
            if (!(avg > largestAverage)) continue;
            largestAverage = avg;
        }
        outChunks.clear();
        for (IChunk c : inChunks) {
            if (c.getAverageWordsLength() != largestAverage) continue;
            outChunks.add(c);
        }
        return outChunks;
    }

    public static ArrayList<IChunk> getSmallestVarianceWordLengthChunks(ArrayList<IChunk> inChunks, ArrayList<IChunk> outChunks) {
        double smallestVariance = inChunks.get(0).getWordsVariance();
        for (int j = 1; j < inChunks.size(); ++j) {
            double v = inChunks.get(j).getWordsVariance();
            if (!(v < smallestVariance)) continue;
            smallestVariance = v;
        }
        outChunks.clear();
        for (IChunk c : inChunks) {
            if (c.getWordsVariance() != smallestVariance) continue;
            outChunks.add(c);
        }
        return outChunks;
    }

    public static ArrayList<IChunk> getLargestSingleMorphemicFreedomChunks(ArrayList<IChunk> inChunks, ArrayList<IChunk> outChunks) {
        double largestFreedom = inChunks.get(0).getSingleWordsMorphemicFreedom();
        for (int j = 1; j < inChunks.size(); ++j) {
            double f = inChunks.get(j).getSingleWordsMorphemicFreedom();
            if (!(f > largestFreedom)) continue;
            largestFreedom = f;
        }
        outChunks.clear();
        for (IChunk c : inChunks) {
            if (c.getSingleWordsMorphemicFreedom() != largestFreedom) continue;
            outChunks.add(c);
        }
        return outChunks;
    }
}

