/*
 * Decompiled with CFR 0.152.
 */
package org.lionsoul.jcseg.segmenter;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.util.LinkedList;
import org.lionsoul.jcseg.ISegment;
import org.lionsoul.jcseg.IWord;
import org.lionsoul.jcseg.dic.ADictionary;
import org.lionsoul.jcseg.segmenter.SegKit;
import org.lionsoul.jcseg.segmenter.SegmenterConfig;
import org.lionsoul.jcseg.segmenter.Word;
import org.lionsoul.jcseg.util.IPushbackReader;
import org.lionsoul.jcseg.util.IStringBuffer;
import org.lionsoul.jcseg.util.StringUtil;

public class DetectSeg
implements ISegment,
Serializable {
    private static final long serialVersionUID = 1L;
    private int idx;
    private IPushbackReader reader = null;
    private final IStringBuffer isb;
    protected final LinkedList<IWord> wordPool;
    public final ADictionary dic;
    public final SegmenterConfig config;

    public DetectSeg(SegmenterConfig config, ADictionary dic) {
        this.config = config;
        this.dic = dic;
        this.wordPool = new LinkedList();
        this.isb = new IStringBuffer(64);
    }

    @Override
    public void reset(Reader input) throws IOException {
        if (input != null) {
            this.reader = new IPushbackReader(new BufferedReader(input));
        }
        this.idx = -1;
    }

    @Override
    public int getStreamPosition() {
        return this.idx + 1;
    }

    protected int readNext() throws IOException {
        int c = this.reader.read();
        if (c != -1) {
            ++this.idx;
        }
        return c;
    }

    protected void pushBack(int data) {
        this.reader.unread(data);
        --this.idx;
    }

    public ADictionary getDict() {
        return this.dic;
    }

    public SegmenterConfig getConfig() {
        return this.config;
    }

    @Override
    public IWord next() throws IOException {
        int c;
        if (this.wordPool.size() > 0) {
            return this.wordPool.remove();
        }
        IWord w = null;
        String T = null;
        while ((c = this.readNext()) != -1) {
            int i;
            w = null;
            T = null;
            int pos = this.idx;
            this.isb.clear();
            if (StringUtil.isHWEnChar(c) || StringUtil.isFWEnChar(c)) {
                if (c > 65280) {
                    c -= 65248;
                }
                if (c >= 65 && c <= 90) {
                    c += 32;
                }
            }
            this.isb.append((char)c);
            T = this.isb.toString();
            if (this.dic.match(0, T)) {
                w = this.dic.get(0, T);
            }
            for (i = 1; i < this.config.MAX_LENGTH && (c = this.readNext()) != -1; ++i) {
                if (StringUtil.isHWEnChar(c) || StringUtil.isFWEnChar(c)) {
                    if (c > 65280) {
                        c -= 65248;
                    }
                    if (c >= 65 && c <= 90) {
                        c += 32;
                    }
                }
                this.isb.append((char)c);
                T = this.isb.toString();
                if (!this.dic.match(0, T)) continue;
                w = this.dic.get(0, T);
            }
            if (w == null) {
                for (i = this.isb.length() - 1; i > 0; --i) {
                    this.pushBack(this.isb.charAt(i));
                }
                continue;
            }
            int LENGTH = w.getLength();
            for (i = this.isb.length() - 1; i >= LENGTH; --i) {
                this.pushBack(this.isb.charAt(i));
            }
            w = w.clone();
            w.setPosition(pos);
            if (this.config.APPEND_CJK_PINYIN && this.config.LOAD_CJK_PINYIN && w.getPinyin() != null) {
                Word pinyin = new Word(w.getPinyin(), 8);
                pinyin.setPosition(pos);
                pinyin.setLength(w.getLength());
                this.wordPool.add(pinyin);
            }
            if (this.config.APPEND_CJK_SYN && this.config.LOAD_CJK_SYN && w.getSyn() != null) {
                SegKit.appendSynonyms(this.config, this.wordPool, w);
            }
            return w;
        }
        return null;
    }
}

