/*
 * Decompiled with CFR 0.152.
 */
package org.lionsoul.jcseg.segmenter;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.LinkedList;
import org.lionsoul.jcseg.ISegment;
import org.lionsoul.jcseg.IWord;
import org.lionsoul.jcseg.dic.ADictionary;
import org.lionsoul.jcseg.segmenter.SegKit;
import org.lionsoul.jcseg.segmenter.SegmenterConfig;
import org.lionsoul.jcseg.segmenter.Word;
import org.lionsoul.jcseg.util.IPushbackReader;
import org.lionsoul.jcseg.util.IStringBuffer;
import org.lionsoul.jcseg.util.StringUtil;

public class DelimiterSeg
implements ISegment {
    private int idx;
    private char delimiter;
    private IPushbackReader reader;
    private final IStringBuffer isb;
    protected final LinkedList<IWord> wordPool;
    public final ADictionary dic;
    public final SegmenterConfig config;

    public DelimiterSeg(SegmenterConfig config, ADictionary dic) {
        this.config = config;
        this.dic = dic;
        this.delimiter = config.getDELIMITER();
        this.wordPool = new LinkedList();
        this.isb = new IStringBuffer(64);
    }

    @Override
    public void reset(Reader input) throws IOException {
        if (input != null) {
            this.reader = new IPushbackReader(new BufferedReader(input));
        }
        this.idx = -1;
    }

    @Override
    public int getStreamPosition() {
        return this.idx + 1;
    }

    protected int readNext() throws IOException {
        int c = this.reader.read();
        if (c != -1) {
            ++this.idx;
        }
        return c;
    }

    protected void pushBack(int data) {
        this.reader.unread(data);
        --this.idx;
    }

    @Override
    public IWord next() throws IOException {
        int c;
        if (this.wordPool.size() > 0) {
            return this.wordPool.remove();
        }
        while ((c = this.readNext()) != -1) {
            if (c == this.delimiter) continue;
            int pos = this.idx;
            this.isb.clear().append((char)c);
            for (int i = 1; i < this.config.MAX_LATIN_LENGTH && (c = this.readNext()) != -1 && c != this.delimiter; ++i) {
                this.isb.append((char)c);
            }
            IWord wd = null;
            String val = this.isb.toString();
            if (this.dic != null && this.dic.match(0, val)) {
                wd = this.dic.get(0, val).clone();
            } else {
                wd = new Word(val, 1);
                if (StringUtil.isLatin(val)) {
                    wd.setPartSpeechForNull(IWord.EN_POSPEECH);
                }
            }
            wd.setPosition(pos);
            if (this.dic != null && this.config.APPEND_CJK_PINYIN && this.config.LOAD_CJK_PINYIN && wd.getPinyin() != null) {
                Word pinyin = new Word(wd.getPinyin(), 8);
                pinyin.setPosition(pos);
                pinyin.setLength(wd.getLength());
                this.wordPool.add(pinyin);
            }
            if (this.dic != null && this.config.APPEND_CJK_SYN && this.config.LOAD_CJK_SYN && wd.getSyn() != null) {
                SegKit.appendSynonyms(this.config, this.wordPool, wd);
            }
            return wd;
        }
        return null;
    }

    public char getDelimiter() {
        return this.delimiter;
    }

    public void setDelimiter(char delimiter) {
        this.delimiter = delimiter;
    }

    public ADictionary getDic() {
        return this.dic;
    }

    public SegmenterConfig getConfig() {
        return this.config;
    }
}

