/*
 * Decompiled with CFR 0.152.
 */
package org.lionsoul.jcseg.segmenter;

import java.io.Serializable;
import java.util.ArrayList;
import org.lionsoul.jcseg.IChunk;
import org.lionsoul.jcseg.IWord;
import org.lionsoul.jcseg.dic.ADictionary;
import org.lionsoul.jcseg.segmenter.Chunk;
import org.lionsoul.jcseg.segmenter.MMSegFilter;
import org.lionsoul.jcseg.segmenter.Segmenter;
import org.lionsoul.jcseg.segmenter.SegmenterConfig;

public class ComplexSeg
extends Segmenter
implements Serializable {
    private static final long serialVersionUID = 1L;

    public ComplexSeg(SegmenterConfig config, ADictionary dic) {
        super(config, dic);
    }

    @Override
    public IChunk getBestChunk(char[] chars, int index, int maxLen) {
        IWord[] mword3;
        IWord[] mword2;
        ArrayList<IWord> wList = new ArrayList<IWord>(12);
        IWord[] mWords = this.getNextMatch(maxLen, chars, index, wList);
        if (mWords.length == 1 && mWords[0].getType() == 17) {
            return new Chunk(new IWord[]{mWords[0]});
        }
        ArrayList<IChunk> chunkArr = new ArrayList<IChunk>();
        for (int x = 0; x < mWords.length; ++x) {
            int idx_2 = index + mWords[x].getLength();
            if (idx_2 < chars.length) {
                mword2 = this.getNextMatch(maxLen, chars, idx_2, wList);
                if (mword2.length == 1 && mword2[0].getType() == 17) {
                    return new Chunk(new IWord[]{mWords[mWords.length - 1]});
                }
                for (int y = 0; y < mword2.length; ++y) {
                    int idx_3 = idx_2 + mword2[y].getLength();
                    if (idx_3 < chars.length) {
                        mword3 = this.getNextMatch(maxLen, chars, idx_3, wList);
                        for (int z = 0; z < mword3.length; ++z) {
                            ArrayList<IWord> wArr = new ArrayList<IWord>(3);
                            wArr.add(mWords[x]);
                            wArr.add(mword2[y]);
                            if (mword3[z].getType() != 17) {
                                wArr.add(mword3[z]);
                            }
                            IWord[] words = new IWord[wArr.size()];
                            wArr.toArray(words);
                            wArr.clear();
                            chunkArr.add(new Chunk(words));
                        }
                        continue;
                    }
                    chunkArr.add(new Chunk(new IWord[]{mWords[x], mword2[y]}));
                }
                continue;
            }
            chunkArr.add(new Chunk(new IWord[]{mWords[x]}));
        }
        wList.clear();
        if (chunkArr.size() == 1) {
            return (IChunk)chunkArr.get(0);
        }
        mWords = null;
        mword2 = null;
        mword3 = null;
        ArrayList<IChunk> chunkBuf = new ArrayList<IChunk>(chunkArr.size());
        ArrayList<IChunk> chunks = MMSegFilter.getMaximumMatchChunks(chunkArr, chunkBuf);
        if (chunks.size() == 1) {
            return chunks.get(0);
        }
        chunks = MMSegFilter.getLargestAverageWordLengthChunks(chunkBuf, chunkArr);
        if (chunks.size() == 1) {
            return chunks.get(0);
        }
        chunks = MMSegFilter.getSmallestVarianceWordLengthChunks(chunkArr, chunkBuf);
        if (chunks.size() == 1) {
            return chunks.get(0);
        }
        chunks = MMSegFilter.getLargestSingleMorphemicFreedomChunks(chunkBuf, chunkArr);
        if (chunks.size() == 1) {
            return chunks.get(0);
        }
        return chunks.get(chunks.size() - 1);
    }

    protected static void printChunks(String scene, ArrayList<IChunk> chunks) {
        System.out.println(scene);
        for (IChunk c : chunks) {
            System.out.println(c.toString());
        }
        System.out.println("-+------------------------+-");
    }
}

