/*
 * Decompiled with CFR 0.152.
 */
package org.lionsoul.jcseg.segmenter;

import org.lionsoul.jcseg.IChunk;
import org.lionsoul.jcseg.IWord;

public class Chunk
implements IChunk {
    private final IWord[] words;
    private double avgWordsLength = -1.0;
    private double wordsVariance = -1.0;
    private double singleWordMorphemicFreedom = -1.0;
    private int singleWordFrequency = -1;
    private int length = -1;

    public Chunk(IWord[] words) {
        this.words = words;
    }

    @Override
    public IWord[] getWords() {
        return this.words;
    }

    @Override
    public double getAverageWordsLength() {
        if (this.avgWordsLength == -1.0) {
            this.avgWordsLength = (double)this.getLength() / (double)this.words.length;
        }
        return this.avgWordsLength;
    }

    @Override
    public double getWordsVariance() {
        if (this.wordsVariance == -1.0) {
            double variance = 0.0;
            for (IWord word : this.words) {
                double temp = (double)word.getLength() - this.getAverageWordsLength();
                variance += temp * temp;
            }
            this.wordsVariance = variance / (double)this.words.length;
        }
        return this.wordsVariance;
    }

    @Override
    public double getSingleWordsMorphemicFreedom() {
        if (this.singleWordMorphemicFreedom == -1.0) {
            this.singleWordMorphemicFreedom = 0.0;
            for (IWord word : this.words) {
                if (word.getLength() != 1) continue;
                this.singleWordMorphemicFreedom += word.getFrequency() > 0 ? Math.log(word.getFrequency()) : 0.0;
            }
        }
        return this.singleWordMorphemicFreedom;
    }

    @Override
    public int getSingleWordsFrequency() {
        if ((double)this.singleWordFrequency == -1.0) {
            this.singleWordFrequency = 0;
            for (IWord word : this.words) {
                if (word.getLength() != 1) continue;
                this.singleWordFrequency += Math.max(word.getFrequency(), 0);
            }
        }
        return this.singleWordFrequency;
    }

    @Override
    public int getLength() {
        if (this.length == -1) {
            this.length = 0;
            for (IWord word : this.words) {
                this.length += word.getValue().length();
            }
        }
        return this.length;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        String prefix = "chunk: ";
        sb.append("chunk: ");
        for (IWord word : this.words) {
            if (sb.length() > "chunk: ".length()) {
                sb.append("/");
            }
            sb.append(word);
        }
        return sb.toString();
    }
}

