/*
 * Decompiled with CFR 0.152.
 */
package org.lionsoul.jcseg.dic;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.lionsoul.jcseg.IWord;
import org.lionsoul.jcseg.dic.ADictionary;
import org.lionsoul.jcseg.segmenter.SegmenterConfig;
import org.lionsoul.jcseg.segmenter.Word;

public class HashMapDictionary
extends ADictionary
implements Serializable {
    private static final long serialVersionUID = 1L;
    public final Map<String, IWord>[] dictMap = new Map[11];

    public HashMapDictionary(SegmenterConfig config, Boolean sync) {
        super(config, sync);
        if (this.sync) {
            for (int j = 0; j < 11; ++j) {
                this.dictMap[j] = new ConcurrentHashMap<String, IWord>(16, 0.8f);
            }
        } else {
            for (int j = 0; j < 11; ++j) {
                this.dictMap[j] = new HashMap<String, IWord>(16, 0.8f);
            }
        }
    }

    @Override
    public boolean match(int t, String key) {
        if (t >= 0 && t < 11) {
            return this.dictMap[t].containsKey(key);
        }
        return false;
    }

    @Override
    public IWord add(int t, IWord word) {
        if (t >= 0 && t < 11) {
            if (this.dictMap[t].containsKey(word.getValue())) {
                return this.dictMap[t].get(word.getValue());
            }
            this.dictMap[t].put(word.getValue(), word);
            return word;
        }
        return null;
    }

    @Override
    public IWord add(int t, String key, int fre, int type, String[] entity) {
        if (t >= 0 && t < 11) {
            if (this.dictMap[t].containsKey(key)) {
                return this.dictMap[t].get(key);
            }
            Word word = new Word(key, fre, type, entity);
            this.dictMap[t].put(key, word);
            return word;
        }
        return null;
    }

    @Override
    public IWord add(int t, String key, int type) {
        return this.add(t, key, 0, type, null);
    }

    @Override
    public IWord add(int t, String key, int fre, int type) {
        return this.add(t, key, fre, type, null);
    }

    @Override
    public IWord add(int t, String key, int type, String[] entity) {
        return this.add(t, key, 0, type, entity);
    }

    @Override
    public IWord get(int t, String key) {
        if (t >= 0 && t < 11) {
            return this.dictMap[t].get(key);
        }
        return null;
    }

    @Override
    public void remove(int t, String key) {
        if (t >= 0 && t < 11) {
            this.dictMap[t].remove(key);
        }
    }

    @Override
    public int size(int t) {
        if (t >= 0 && t < 11) {
            return this.dictMap[t].size();
        }
        return 0;
    }
}

