/*
 * Decompiled with CFR 0.152.
 */
package org.lionsoul.jcseg.dic;

import java.io.IOException;
import org.lionsoul.jcseg.IDictionary;
import org.lionsoul.jcseg.dic.ADictionary;
import org.lionsoul.jcseg.segmenter.SegmenterConfig;

public class DictionaryFactory {
    private static final Object LOCK = new Object();
    private static ADictionary singletonDic = null;

    private DictionaryFactory() {
    }

    public static ADictionary createDefaultDictionary(SegmenterConfig config, boolean sync, boolean loadDic) {
        ADictionary dic = IDictionary.HASHMAP.factory.create(config, sync);
        if (!loadDic) {
            return dic;
        }
        try {
            String[] lexPath = config.getLexiconPath();
            if (lexPath == null) {
                dic.loadClassPath();
            } else {
                for (String lPath : lexPath) {
                    dic.loadDirectory(lPath);
                }
                if (config.isAutoload()) {
                    dic.startAutoload();
                }
            }
            dic.resetSynonymsNet();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return dic;
    }

    public static ADictionary createDefaultDictionary(SegmenterConfig config) {
        return DictionaryFactory.createDefaultDictionary(config, true);
    }

    public static ADictionary createDefaultDictionary(SegmenterConfig config, boolean loadDic) {
        return DictionaryFactory.createDefaultDictionary(config, config.isAutoload(), loadDic);
    }

    public static ADictionary createSingletonDictionary(SegmenterConfig config) {
        return DictionaryFactory.createSingletonDictionary(config, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ADictionary createSingletonDictionary(SegmenterConfig config, boolean loadDic) {
        Object object = LOCK;
        synchronized (object) {
            if (singletonDic == null) {
                singletonDic = DictionaryFactory.createDefaultDictionary(config, loadDic);
            }
        }
        return singletonDic;
    }
}

