/*
 * Decompiled with CFR 0.152.
 */
package org.lionsoul.jcseg.dic;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.security.CodeSource;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.lionsoul.jcseg.IDictionary;
import org.lionsoul.jcseg.IWord;
import org.lionsoul.jcseg.SynonymsEntry;
import org.lionsoul.jcseg.dic.AutoLoadFile;
import org.lionsoul.jcseg.segmenter.Entity;
import org.lionsoul.jcseg.segmenter.SegmenterConfig;
import org.lionsoul.jcseg.segmenter.Word;
import org.lionsoul.jcseg.util.StringUtil;

public abstract class ADictionary
implements IDictionary,
Serializable {
    private static final long serialVersionUID = 4471659405268497613L;
    public static final String AL_TODO_FILE = "lex-autoload.todo";
    public final SegmenterConfig config;
    public final boolean sync;
    private Thread autoloadThread = null;
    public volatile int mixSuffixLength = 1;
    public volatile int mixPrefixLength = 1;
    private final List<String[]> synBuffer = Collections.synchronizedList(new ArrayList());
    private final Map<String, SynonymsEntry> rootMap = new HashMap<String, SynonymsEntry>();

    public ADictionary(SegmenterConfig config, Boolean sync) {
        this.sync = sync;
        this.config = config;
    }

    public void load(File file) throws NumberFormatException, IOException {
        ADictionary.loadWords(this.config, this, file, this.synBuffer);
    }

    public void load(String file) throws NumberFormatException, IOException {
        ADictionary.loadWords(this.config, this, file, this.synBuffer);
    }

    public void load(InputStream is) throws NumberFormatException, IOException {
        ADictionary.loadWords(this.config, this, is, this.synBuffer);
    }

    public void loadDirectory(String lexDir) throws IOException {
        File path = new File(lexDir);
        if (!path.exists()) {
            throw new IOException("Lexicon directory [" + lexDir + "] is not exists.");
        }
        File[] files = path.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.startsWith("lex-") && name.endsWith(".lex");
            }
        });
        if (files != null) {
            for (File file : files) {
                this.load(file);
            }
        }
    }

    public void loadClassPath() throws IOException {
        Class<?> dClass = this.getClass();
        CodeSource codeSrc = this.getClass().getProtectionDomain().getCodeSource();
        if (codeSrc == null) {
            return;
        }
        String codePath = codeSrc.getLocation().getPath();
        if (codePath.toLowerCase().endsWith(".jar")) {
            ZipEntry e;
            ZipInputStream zip = new ZipInputStream(codeSrc.getLocation().openStream());
            while ((e = zip.getNextEntry()) != null) {
                String fileName = e.getName();
                if (!fileName.endsWith(".lex") || !fileName.startsWith("lexicon/lex-")) continue;
                this.load(dClass.getResourceAsStream("/" + fileName));
            }
        } else {
            File lexiconDir = new File(URLDecoder.decode(codeSrc.getLocation().getFile(), "utf-8"));
            this.loadDirectory(lexiconDir.getPath() + File.separator + "lexicon");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetSynonymsNet() {
        List<String[]> list = this.synBuffer;
        synchronized (list) {
            if (this.synBuffer.size() == 0) {
                return;
            }
            for (String[] synLine : this.synBuffer) {
                IWord baseWord = this.get(0, synLine[0]);
                if (baseWord == null) continue;
                SynonymsEntry synEntry = this.rootMap.get(baseWord.getValue());
                if (synEntry == null) {
                    synEntry = new SynonymsEntry(baseWord);
                    this.rootMap.put(baseWord.getValue(), synEntry);
                    synEntry.add(baseWord);
                }
                for (int i = 1; i < synLine.length; ++i) {
                    String[] parts = synLine[i].split("\\s*/\\s*");
                    for (IWord w : synEntry.getList()) {
                        if (!w.getValue().equals(parts[0])) continue;
                    }
                    IWord synWord = this.get(0, parts[0]);
                    if (synWord == null) {
                        synWord = new Word(parts[0], 1);
                        this.add(0, synWord);
                    }
                    if (synWord.getPartSpeech() == null) {
                        synWord.setPartSpeech(baseWord.getPartSpeech());
                    }
                    if (synWord.getEntity() == null) {
                        synWord.setEntity(baseWord.getEntity());
                    }
                    if (parts.length > 1) {
                        synWord.setPinyin(parts[1]);
                    }
                    synEntry.add(synWord);
                }
            }
            this.synBuffer.clear();
        }
    }

    public void startAutoload() {
        if (this.autoloadThread != null || this.config.getLexiconPath() == null) {
            return;
        }
        this.autoloadThread = new Thread(new Runnable(){

            @Override
            public void run() {
                String[] paths = ADictionary.this.config.getLexiconPath();
                AutoLoadFile[] files = new AutoLoadFile[paths.length];
                for (int i = 0; i < files.length; ++i) {
                    files[i] = new AutoLoadFile(paths[i] + "/" + ADictionary.AL_TODO_FILE);
                    files[i].setLastUpdateTime(files[i].getFile().lastModified());
                }
                while (true) {
                    try {
                        Thread.sleep((long)ADictionary.this.config.getPollTime() * 1000L);
                    }
                    catch (InterruptedException e) {
                        break;
                    }
                    File f = null;
                    AutoLoadFile af = null;
                    for (int i = 0; i < files.length; ++i) {
                        af = files[i];
                        f = files[i].getFile();
                        if (!f.exists() || f.lastModified() <= af.getLastUpdateTime()) continue;
                        try {
                            String line = null;
                            BufferedReader reader = new BufferedReader(new FileReader(f));
                            while ((line = reader.readLine()) != null) {
                                if ((line = line.trim()).indexOf(35) != -1 || "".equals(line)) continue;
                                ADictionary.this.load(paths[i] + "/" + line);
                            }
                            reader.close();
                            FileWriter fw = new FileWriter(f);
                            fw.write("");
                            fw.close();
                            af.setLastUpdateTime(f.lastModified());
                            continue;
                        }
                        catch (IOException e) {
                            break;
                        }
                    }
                    ADictionary.this.resetSynonymsNet();
                }
            }
        });
        this.autoloadThread.setDaemon(true);
        this.autoloadThread.start();
    }

    public void stopAutoload() {
        if (this.autoloadThread != null) {
            this.autoloadThread.interrupt();
            this.autoloadThread = null;
        }
    }

    public boolean isSync() {
        return this.sync;
    }

    public static int getIndex(String key) {
        if (key == null) {
            return -1;
        }
        if ((key = key.toUpperCase()).startsWith("CJK_WORD")) {
            return 0;
        }
        if (key.startsWith("CJK_CHAR")) {
            return 15;
        }
        if (key.startsWith("CJK_UNIT")) {
            return 1;
        }
        if (key.startsWith("CN_LNAME_ADORN")) {
            return 6;
        }
        if (key.startsWith("CN_LNAME")) {
            return 2;
        }
        if (key.startsWith("CN_SNAME")) {
            return 3;
        }
        if (key.startsWith("CN_DNAME_1")) {
            return 4;
        }
        if (key.startsWith("CN_DNAME_2")) {
            return 5;
        }
        if (key.startsWith("STOP_WORD")) {
            return 7;
        }
        if (key.startsWith("DOMAIN_SUFFIX")) {
            return 9;
        }
        if (key.startsWith("NUMBER_UNIT")) {
            return 10;
        }
        if (key.startsWith("CJK_SYN")) {
            return 16;
        }
        return 0;
    }

    public SegmenterConfig getConfig() {
        return this.config;
    }

    public static void loadWords(SegmenterConfig config, ADictionary dic, File file, List<String[]> buffer) throws NumberFormatException, IOException {
        ADictionary.loadWords(config, dic, Files.newInputStream(file.toPath(), new OpenOption[0]), buffer);
    }

    public static void loadWords(SegmenterConfig config, ADictionary dic, String file, List<String[]> buffer) throws NumberFormatException, IOException {
        ADictionary.loadWords(config, dic, Files.newInputStream(Paths.get(file, new String[0]), new OpenOption[0]), buffer);
    }

    public static void loadWords(SegmenterConfig config, ADictionary dic, InputStream is, List<String[]> buffer) throws NumberFormatException, IOException {
        boolean isFirstLine = true;
        int t = -1;
        String line = null;
        String gEntity = null;
        try (BufferedReader buffReader = new BufferedReader(new InputStreamReader(is, StandardCharsets.UTF_8));){
            block15: while ((line = buffReader.readLine()) != null) {
                if ("".equals(line = line.trim()) || line.charAt(0) == '#' && line.length() > 1) continue;
                if (isFirstLine) {
                    t = ADictionary.getIndex(line);
                    isFirstLine = false;
                    if (t >= 0) continue;
                }
                if (line.charAt(0) == ':' && line.length() > 1) {
                    String[] directive = line.substring(1).toLowerCase().split("\\s+");
                    if (!directive[0].equals("entity") || directive.length <= 1) continue;
                    String args = directive[1].trim();
                    gEntity = "null".equals(args) ? null : Entity.get(args);
                    continue;
                }
                IWord tword = null;
                String[] wd = null;
                switch (t) {
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: {
                        if (line.length() != 1) break;
                        dic.add(t, line, 1);
                        break;
                    }
                    case 10: {
                        wd = line.split("\\s*/\\s*");
                        IWord uw = dic.add(t, wd[0], 1);
                        if (wd.length == 1) {
                            dic.add(0, uw);
                            break;
                        }
                        if (wd.length != 2) break;
                        String entity = "null".equals(wd[1]) ? null : Entity.get(wd[1]);
                        uw.addEntity(entity);
                        dic.add(15, uw);
                        break;
                    }
                    case 1: {
                        wd = line.split("\\s*/\\s*");
                        IWord w = dic.add(t, wd[0], 1);
                        if (wd.length == 1) {
                            dic.add(0, w);
                            break;
                        }
                        if (wd.length == 2) {
                            String entity = "null".equals(wd[1]) ? null : Entity.get(wd[1]);
                            w.addEntity(entity);
                            dic.add(0, w).addEntity(entity);
                            break;
                        }
                        if (wd.length > 3) {
                            String entity = "null".equals(wd[3]) ? null : Entity.get(wd[3]);
                            w.addEntity(entity);
                            if (config.LOAD_PARAMETER && wd.length > 4 && !wd[4].equals("null")) {
                                w.setParameter(wd[4]);
                            }
                            dic.add(0, w).addEntity(entity);
                            tword = w;
                            break;
                        }
                        dic.add(0, w);
                        tword = w;
                        break;
                    }
                    case 6: {
                        dic.add(t, line, 1);
                        break;
                    }
                    case 7: {
                        dic.add(7, line, 1);
                        break;
                    }
                    case 9: {
                        wd = line.split("\\s*/\\s*");
                        dic.add(t, wd[0], 5);
                        break;
                    }
                    case 16: {
                        wd = line.split("\\s*,\\s*");
                        if (wd.length > 1 && buffer != null) {
                            buffer.add(wd);
                        }
                        wd = null;
                        break;
                    }
                    case 0: 
                    case 15: {
                        int cjkIndex;
                        wd = line.split("\\s*/\\s*", 5);
                        if (wd.length < 4) {
                            System.out.println("Word: \"" + wd[0] + "\" format error. -ignored");
                            continue block15;
                        }
                        if (t == 15 && !StringUtil.isDigit(wd[4])) {
                            System.out.println("Word: \"" + wd[0] + "\" format error(single word degree should be an integer). -ignored");
                            continue block15;
                        }
                        int latinIndex = StringUtil.latinIndexOf(wd[0]);
                        tword = dic.get(0, wd[0]);
                        if (tword == null) {
                            tword = t == 15 ? dic.add(0, wd[0], Integer.parseInt(wd[4]), 1) : dic.add(t, wd[0], 1);
                        } else if (t == 15) {
                            tword.setFrequency(Integer.parseInt(wd[4]));
                        }
                        if (config.LOAD_CJK_ENTITY && t != 15) {
                            if (wd.length > 3) {
                                if ("unset".equals(wd[3])) {
                                    tword.setEntity(null);
                                } else if ("extend".equals(wd[3])) {
                                    tword.addEntity(gEntity);
                                } else if ("null".equals(wd[3])) {
                                    tword.addEntity(gEntity);
                                } else {
                                    tword.addEntity(Entity.get(wd[3]));
                                }
                            } else if (gEntity != null) {
                                tword.addEntity(gEntity);
                            }
                        }
                        if (config.LOAD_PARAMETER && t != 15 && wd.length > 4 && !wd[4].equals("null")) {
                            tword.setParameter(wd[4]);
                        }
                        if (latinIndex < 0) break;
                        if (latinIndex > 0) {
                            ADictionary.resetPrefixLength(config, dic, latinIndex);
                            dic.add(8, wd[0].substring(0, latinIndex), 1);
                        }
                        if ((cjkIndex = StringUtil.CJKIndexOf(wd[0], latinIndex + 1)) > -1) {
                            ADictionary.resetSuffixLength(config, dic, wd[0].length() - cjkIndex);
                            dic.add(8, wd[0].substring(cjkIndex), 1);
                        }
                        if (latinIndex <= 0 || cjkIndex <= -1) break;
                        dic.add(8, wd[0].substring(0, cjkIndex), 5);
                    }
                }
                if (tword == null) continue;
                if (config.LOAD_CJK_PINYIN && !"null".equals(wd[2])) {
                    tword.setPinyin(wd[2]);
                }
                String[] arr = tword.getPartSpeech();
                if (!config.LOAD_CJK_POS || "null".equals(wd[1])) continue;
                String[] pos = wd[1].split(",");
                for (int j = 0; j < pos.length; ++j) {
                    pos[j] = pos[j].trim();
                    boolean add = true;
                    if (arr != null) {
                        for (String s : arr) {
                            if (!pos[j].equals(s)) continue;
                            add = false;
                            break;
                        }
                    }
                    if (!add) continue;
                    tword.addPartSpeech(pos[j].trim());
                }
            }
        }
    }

    public static void resetPrefixLength(SegmenterConfig config, ADictionary dic, int mixLength) {
        if (mixLength <= config.MAX_LENGTH && mixLength > dic.mixPrefixLength) {
            dic.mixPrefixLength = mixLength;
        }
    }

    public static void resetSuffixLength(SegmenterConfig config, ADictionary dic, int mixLength) {
        if (mixLength <= config.MAX_LENGTH && mixLength > dic.mixSuffixLength) {
            dic.mixSuffixLength = mixLength;
        }
    }
}

