/*
 * Decompiled with CFR 0.152.
 */
package org.lionsoul.jcseg.util;

import org.lionsoul.jcseg.tokenizer.core.ADictionary;
import org.lionsoul.jcseg.util.StringUtil;

public class EntityFormat {
    public static final boolean isMailAddress(String str) {
        int ptIndex;
        int atIndex = str.indexOf(64);
        if (atIndex == -1) {
            return false;
        }
        if (!StringUtil.isLetterOrNumeric(str, 0, atIndex)) {
            return false;
        }
        int ptStart = atIndex + 1;
        while ((ptIndex = str.indexOf(46, ptStart)) > 0) {
            if (ptIndex == ptStart) {
                return false;
            }
            if (!StringUtil.isLetterOrNumeric(str, ptStart, ptIndex)) {
                return false;
            }
            ptStart = ptIndex + 1;
        }
        return ptStart >= str.length() || StringUtil.isLetterOrNumeric(str, ptStart, str.length());
    }

    public static final boolean isUrlAddress(String str, ADictionary dic) {
        char chr;
        int i;
        int prIndex = str.indexOf("://");
        if (prIndex > -1 && !StringUtil.isLatin(str, 0, prIndex)) {
            return false;
        }
        int sIdx = prIndex > -1 ? prIndex + 3 : 0;
        int slIndex = str.indexOf(47, sIdx);
        int sgIndex = str.indexOf(63, sIdx);
        int eIdx = slIndex > -1 ? slIndex : (sgIndex > -1 ? sgIndex : str.length());
        int lpIndex = -1;
        for (i = sIdx; i < eIdx; ++i) {
            chr = str.charAt(i);
            if (chr == '.') {
                if (lpIndex == -1) {
                    lpIndex = i;
                    continue;
                }
                if (i - lpIndex == 1 || i == eIdx - 1) {
                    return false;
                }
                lpIndex = i;
                continue;
            }
            if (StringUtil.isEnLetter(chr) || StringUtil.isEnNumeric(chr)) continue;
            return false;
        }
        if (dic != null && !dic.match(9, str.substring(lpIndex + 1, eIdx))) {
            return false;
        }
        if (slIndex > -1) {
            sIdx = slIndex;
            eIdx = sgIndex > -1 ? sgIndex : str.length();
            lpIndex = -1;
            for (i = sIdx; i < eIdx; ++i) {
                chr = str.charAt(i);
                if ("./-_".indexOf(chr) > -1) {
                    if (lpIndex == -1) {
                        lpIndex = i;
                        continue;
                    }
                    if (i - lpIndex == 1 || chr == '.' && i == eIdx - 1) {
                        return false;
                    }
                    lpIndex = i;
                    continue;
                }
                if (StringUtil.isEnLetter(chr) || StringUtil.isEnNumeric(chr)) continue;
                return false;
            }
        }
        return true;
    }

    public static final boolean isMobileNumber(String str) {
        if (str.length() != 11) {
            return false;
        }
        if (str.charAt(0) != '1') {
            return false;
        }
        if ("34578".indexOf(str.charAt(1)) == -1) {
            return false;
        }
        return StringUtil.isNumeric(str, 2, str.length());
    }

    public static final boolean isIpAddress(String str) {
        int eIdx;
        if (str.length() < 7 && str.length() > 15) {
            return false;
        }
        int sIdx = 0;
        int pcount = 0;
        while ((eIdx = str.indexOf(46, sIdx)) > -1) {
            ++pcount;
            int diff = eIdx - sIdx;
            switch (diff) {
                case 0: {
                    return false;
                }
                case 1: 
                case 2: {
                    if (StringUtil.isNumeric(str, sIdx, eIdx)) break;
                    return false;
                }
                case 3: {
                    char chr = str.charAt(sIdx);
                    if (chr == '1') {
                        if (StringUtil.isNumeric(str, sIdx + 1, eIdx)) break;
                        return false;
                    }
                    if (chr != '2') break;
                    chr = str.charAt(sIdx + 1);
                    if (chr < '0' || chr > '5') {
                        return false;
                    }
                    chr = str.charAt(sIdx + 2);
                    if (chr >= '0' && chr <= '5') break;
                    return false;
                }
                default: {
                    return false;
                }
            }
            sIdx = eIdx + 1;
        }
        return pcount == 3;
    }

    public static final String isDate(String str, char delimiter) {
        char chr2;
        char chr1;
        char chr;
        String m;
        String y;
        int length = str.length();
        if (length > 10) {
            return null;
        }
        int sIdx = 0;
        int eIdx = 0;
        int idx = 0;
        String[] parts = new String[]{null, null, null};
        while ((eIdx = str.indexOf(delimiter, sIdx)) > -1) {
            parts[idx++] = str.substring(sIdx, eIdx);
            sIdx = eIdx + 1;
            if (idx <= 2) continue;
            return null;
        }
        if (sIdx < length) {
            parts[idx++] = str.substring(sIdx);
        }
        if (idx < 2 || idx > 3) {
            return null;
        }
        String d = null;
        if (idx == 2) {
            y = parts[0];
            m = parts[1];
        } else {
            y = parts[0];
            m = parts[1];
            d = parts[2];
        }
        if (y.length() != 4 || !StringUtil.isDigit(y) || y.charAt(0) == '0') {
            return null;
        }
        int len = m.length();
        if (len < 1 || len > 2) {
            return null;
        }
        if (len == 1) {
            chr = m.charAt(0);
            if (chr < '1' || chr > '9') {
                return null;
            }
        } else if (len == 2) {
            chr1 = m.charAt(0);
            chr2 = m.charAt(1);
            if (chr1 != '0' && chr1 != '1') {
                return null;
            }
            if (chr1 == '0' ? chr2 < '1' || chr2 > '9' : chr2 < '0' || chr2 > '2') {
                return null;
            }
        }
        if (idx == 3) {
            len = d.length();
            if (len < 1 || len > 2) {
                return null;
            }
            if (len == 1) {
                chr = d.charAt(0);
                if (chr < '1' || chr > '9') {
                    return null;
                }
            } else if (len == 2) {
                chr1 = d.charAt(0);
                chr2 = d.charAt(1);
                if ("0123".indexOf(chr1) == -1) {
                    return null;
                }
                if (chr1 < '3' ? chr2 < '1' && chr2 > '9' : chr2 < '0' || chr2 > '1') {
                    return null;
                }
            }
        }
        if (delimiter == '.') {
            return idx == 2 ? y + "-" + m : y + "-" + m + "-" + d;
        }
        return str;
    }

    public static final boolean isTime(String str) {
        char chr2;
        char chr1;
        char chr;
        String i;
        String h;
        int length = str.length();
        if (length > 8) {
            return false;
        }
        int sIdx = 0;
        int eIdx = 0;
        int idx = 0;
        String[] parts = new String[]{null, null, null};
        while ((eIdx = str.indexOf(58, sIdx)) > -1) {
            parts[idx++] = str.substring(sIdx, eIdx);
            sIdx = eIdx + 1;
            if (idx <= 2) continue;
            return false;
        }
        if (sIdx < length) {
            parts[idx++] = str.substring(sIdx);
        }
        if (idx < 2 || idx > 3) {
            return false;
        }
        String s = null;
        if (idx == 2) {
            h = parts[0];
            i = parts[1];
        } else {
            h = parts[0];
            i = parts[1];
            s = parts[2];
        }
        int len = h.length();
        if (len < 1 || len > 2) {
            return false;
        }
        if (len == 1) {
            chr = h.charAt(0);
            if (chr < '0' || chr > '9') {
                return false;
            }
        } else if (len == 2) {
            chr1 = h.charAt(0);
            chr2 = h.charAt(1);
            if (chr1 == '0' || chr1 == '1') {
                if (chr2 < '0' || chr2 > '9') {
                    return false;
                }
            } else if (chr1 == '2') {
                if (chr2 < '0' || chr2 > '4') {
                    return false;
                }
            } else {
                return false;
            }
        }
        if ((len = i.length()) < 1 || len > 2) {
            return false;
        }
        if (len == 1) {
            chr = i.charAt(0);
            if (chr < '0' || chr > '9') {
                return false;
            }
        } else if (len == 2) {
            chr1 = i.charAt(0);
            chr2 = i.charAt(1);
            if (chr1 >= '0' && chr1 <= '5') {
                if (chr2 < '0' || chr2 > '9') {
                    return false;
                }
            } else {
                return false;
            }
        }
        if (idx == 3) {
            len = s.length();
            if (len < 1 || len > 2) {
                return false;
            }
            if (len == 1) {
                chr = s.charAt(0);
                if (chr < '0' || chr > '9') {
                    return false;
                }
            } else if (len == 2) {
                chr1 = s.charAt(0);
                chr2 = s.charAt(1);
                if (chr1 >= '0' && chr1 <= '5') {
                    if (chr2 < '0' || chr2 > '9') {
                        return false;
                    }
                } else {
                    return false;
                }
            }
        }
        return true;
    }
}

