/*
 * Decompiled with CFR 0.152.
 */
package org.lionsoul.jcseg.tokenizer;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.LinkedList;
import org.lionsoul.jcseg.tokenizer.Word;
import org.lionsoul.jcseg.tokenizer.core.ADictionary;
import org.lionsoul.jcseg.tokenizer.core.ISegment;
import org.lionsoul.jcseg.tokenizer.core.IWord;
import org.lionsoul.jcseg.tokenizer.core.JcsegTaskConfig;
import org.lionsoul.jcseg.util.IPushbackReader;
import org.lionsoul.jcseg.util.IStringBuffer;
import org.lionsoul.jcseg.util.StringUtil;

public class DelimiterSeg
implements ISegment {
    private int idx;
    private char delimiter;
    private IPushbackReader reader = null;
    private IStringBuffer isb = null;
    protected LinkedList<IWord> wordPool = null;
    private ADictionary dic;
    private JcsegTaskConfig config;

    public DelimiterSeg(JcsegTaskConfig config, ADictionary dic) throws IOException {
        this(null, config, dic);
    }

    public DelimiterSeg(Reader input, JcsegTaskConfig config, ADictionary dic) throws IOException {
        this.config = config;
        this.dic = dic;
        this.delimiter = (char)32;
        this.wordPool = new LinkedList();
        this.isb = new IStringBuffer(64);
        this.reset(input);
    }

    @Override
    public void reset(Reader input) throws IOException {
        if (input != null) {
            this.reader = new IPushbackReader(new BufferedReader(input));
        }
        this.idx = -1;
    }

    @Override
    public int getStreamPosition() {
        return this.idx + 1;
    }

    protected int readNext() throws IOException {
        int c = this.reader.read();
        if (c != -1) {
            ++this.idx;
        }
        return c;
    }

    protected void pushBack(int data) throws IOException {
        this.reader.unread(data);
        --this.idx;
    }

    @Override
    public IWord next() throws IOException {
        int c;
        if (this.wordPool.size() > 0) {
            return this.wordPool.remove();
        }
        while ((c = this.readNext()) != -1) {
            if (c == this.delimiter) continue;
            int pos = this.idx;
            this.isb.clear().append((char)c);
            for (int i = 1; i < this.config.MAX_LATIN_LENGTH && (c = this.readNext()) != -1 && c != this.delimiter; ++i) {
                this.isb.append((char)c);
            }
            IWord wd = null;
            String val = this.isb.toString();
            if (this.dic != null && this.dic.match(0, val)) {
                wd = this.dic.get(0, val).clone();
            } else {
                wd = new Word(val, 1);
                if (StringUtil.isLatin(val)) {
                    wd.setPartSpeech(IWord.EN_POSPEECH);
                }
            }
            wd.setPosition(pos);
            if (this.dic != null && this.config.APPEND_CJK_PINYIN && this.config.LOAD_CJK_PINYIN && wd.getPinyin() != null) {
                Word pinyin = new Word(wd.getPinyin(), 8);
                pinyin.setPosition(pos);
                this.wordPool.add(pinyin);
            }
            String[] syns = null;
            Word syn = null;
            if (this.dic != null && this.config.APPEND_CJK_SYN && this.config.LOAD_CJK_SYN && (syns = wd.getSyn()) != null) {
                for (int j = 0; j < syns.length; ++j) {
                    syn = new Word(syns[j], wd.getType());
                    syn.setPartSpeech(wd.getPartSpeech());
                    syn.setPosition(pos);
                    this.wordPool.add(syn);
                }
            }
            return wd;
        }
        return null;
    }

    public char getDelimiter() {
        return this.delimiter;
    }

    public void setDelimiter(char delimiter) {
        this.delimiter = delimiter;
    }

    public ADictionary getDic() {
        return this.dic;
    }

    public void setDic(ADictionary dic) {
        this.dic = dic;
    }

    public JcsegTaskConfig getConfig() {
        return this.config;
    }

    public void setConfig(JcsegTaskConfig config) {
        this.config = config;
    }
}

