/*
 * Decompiled with CFR 0.152.
 */
package org.lionsoul.jcseg.extractor;

import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.List;
import org.lionsoul.jcseg.sentence.SentenceSeg;
import org.lionsoul.jcseg.tokenizer.core.ISegment;

public abstract class SummaryExtractor {
    protected ISegment wordSeg;
    protected SentenceSeg sentenceSeg;

    public SummaryExtractor(ISegment wordSeg, SentenceSeg sentenceSeg) {
        this.wordSeg = wordSeg;
        this.sentenceSeg = sentenceSeg;
    }

    public List<String> getKeySentenceFromString(String doc) throws IOException {
        return this.getKeySentence(new StringReader(doc));
    }

    public List<String> getKeySentenceFromFile(String file) throws IOException {
        return this.getKeySentence(new FileReader(file));
    }

    public abstract List<String> getKeySentence(Reader var1) throws IOException;

    public String getSummaryFromString(String doc, int length) throws IOException {
        return this.getSummary(new StringReader(doc), length);
    }

    public String getSummaryFromFile(String file, int length) throws IOException {
        return this.getSummary(new FileReader(file), length);
    }

    public abstract String getSummary(Reader var1, int var2) throws IOException;

    public ISegment getWordSeg() {
        return this.wordSeg;
    }

    public void setWordSeg(ISegment wordSeg) {
        this.wordSeg = wordSeg;
    }

    public SentenceSeg getSentenceSeg() {
        return this.sentenceSeg;
    }

    public void setSentenceSeg(SentenceSeg sentenceSeg) {
        this.sentenceSeg = sentenceSeg;
    }
}

