/*
 * Decompiled with CFR 0.152.
 */
package org.lionsoul.ip2region.xdb;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import org.lionsoul.ip2region.xdb.Header;
import org.lionsoul.ip2region.xdb.InetAddressException;
import org.lionsoul.ip2region.xdb.LittleEndian;
import org.lionsoul.ip2region.xdb.LongByteArray;
import org.lionsoul.ip2region.xdb.Util;
import org.lionsoul.ip2region.xdb.Version;
import org.lionsoul.ip2region.xdb.XdbException;

public class Searcher {
    public static final int STRUCTURE_20 = 2;
    public static final int STRUCTURE_30 = 3;
    public static final int HeaderInfoLength = 256;
    public static final int VectorIndexRows = 256;
    public static final int VectorIndexCols = 256;
    public static final int VectorIndexSize = 8;
    public static final int MAX_WRITE_BYTES = 0x7FFFF000;
    private final Version version;
    private final File xdbFile;
    private final RandomAccessFile handle;
    private int ioCount = 0;
    private final byte[] vectorIndex;
    private final LongByteArray contentBuff;

    public static Searcher newWithFileOnly(Version version, String xdbPath) throws IOException {
        return new Searcher(version, new File(xdbPath), null, null);
    }

    public static Searcher newWithFileOnly(Version version, File xdbFile) throws IOException {
        return new Searcher(version, xdbFile, null, null);
    }

    public static Searcher newWithVectorIndex(Version version, String xdbPath, byte[] vectorIndex) throws IOException {
        return new Searcher(version, new File(xdbPath), vectorIndex, null);
    }

    public static Searcher newWithVectorIndex(Version version, File xdbFile, byte[] vectorIndex) throws IOException {
        return new Searcher(version, xdbFile, vectorIndex, null);
    }

    public static Searcher newWithBuffer(Version version, LongByteArray cBuff) throws IOException {
        return new Searcher(version, null, null, cBuff);
    }

    public Searcher(Version version, File xdbFile, byte[] vectorIndex, LongByteArray cBuff) throws IOException {
        this.version = version;
        this.xdbFile = xdbFile;
        if (cBuff != null) {
            this.handle = null;
            this.vectorIndex = null;
            this.contentBuff = cBuff;
        } else {
            this.handle = new RandomAccessFile(xdbFile, "r");
            this.vectorIndex = vectorIndex;
            this.contentBuff = null;
        }
    }

    public void close() throws IOException {
        if (this.handle != null) {
            this.handle.close();
        }
    }

    public Version getIPVersion() {
        return this.version;
    }

    public int getIOCount() {
        return this.ioCount;
    }

    public String search(String ipStr) throws Exception {
        return this.search(Util.parseIP(ipStr));
    }

    public String search(byte[] ip) throws IOException, InetAddressException {
        if (ip.length != this.version.bytes) {
            throw new InetAddressException("invalid ip address (" + this.version.name + " expected)");
        }
        this.ioCount = 0;
        long sPtr = 0L;
        long ePtr = 0L;
        int il0 = ip[0] & 0xFF;
        int il1 = ip[1] & 0xFF;
        int idx = il0 * 256 * 8 + il1 * 8;
        if (this.vectorIndex != null) {
            sPtr = LittleEndian.getUint32(this.vectorIndex, idx);
            ePtr = LittleEndian.getUint32(this.vectorIndex, idx + 4);
        } else if (this.contentBuff != null) {
            sPtr = this.contentBuff.getUint32(256 + idx);
            ePtr = this.contentBuff.getUint32(256 + idx + 4);
        } else {
            byte[] buff = new byte[8];
            this.read(256 + idx, buff);
            sPtr = LittleEndian.getUint32(buff, 0);
            ePtr = LittleEndian.getUint32(buff, 4);
        }
        int bytes = ip.length;
        int dBytes = ip.length << 1;
        int segIndexSize = this.version.segmentIndexSize;
        byte[] buff = new byte[segIndexSize];
        int dataLen = 0;
        long dataPtr = 0L;
        long l = 0L;
        long h = (ePtr - sPtr) / (long)segIndexSize;
        while (l <= h) {
            long m = l + h >> 1;
            long p = sPtr + m * (long)segIndexSize;
            this.read(p, buff);
            if (this.version.ipSubCompare(ip, buff, 0) < 0) {
                h = m - 1L;
                continue;
            }
            if (this.version.ipSubCompare(ip, buff, bytes) > 0) {
                l = m + 1L;
                continue;
            }
            dataLen = LittleEndian.getUint16(buff, dBytes);
            dataPtr = LittleEndian.getUint32(buff, dBytes + 2);
            break;
        }
        if (dataLen == 0) {
            return "";
        }
        byte[] regionBuff = new byte[dataLen];
        this.read(dataPtr, regionBuff);
        return new String(regionBuff, "utf-8");
    }

    protected void read(long offset, byte[] buffer) throws IOException {
        if (this.contentBuff != null) {
            this.contentBuff.copy(offset, buffer, 0, buffer.length);
            return;
        }
        assert (this.handle != null);
        this.handle.seek(offset);
        ++this.ioCount;
        int rLen = this.handle.read(buffer);
        if (rLen != buffer.length) {
            throw new IOException("incomplete read: read bytes should be " + buffer.length);
        }
    }

    public String toString() {
        return String.format("%s->{version:%s, xdb:%s, vIndex:%s, cBuffer:%s}", super.toString(), this.version.name, this.xdbFile == null ? "null" : this.xdbFile.getAbsolutePath(), this.vectorIndex == null ? "null" : String.valueOf(this.vectorIndex.length), this.contentBuff == null ? "null" : String.valueOf(this.contentBuff.length()));
    }

    public static Header loadHeader(RandomAccessFile handle) throws IOException {
        handle.seek(0L);
        byte[] buff = new byte[256];
        handle.read(buff);
        return new Header(buff);
    }

    public static Header loadHeaderFromFile(File xdbFile) throws IOException {
        RandomAccessFile handle = new RandomAccessFile(xdbFile, "r");
        Header header = Searcher.loadHeader(handle);
        handle.close();
        return header;
    }

    public static Header loadHeaderFromFile(String xdbPath) throws IOException {
        return Searcher.loadHeaderFromFile(new File(xdbPath));
    }

    public static Header loadHeaderFromBuffer(LongByteArray cBuffer) throws IOException {
        return new Header(cBuffer.slice(0L, 256));
    }

    public static byte[] loadVectorIndex(RandomAccessFile handle) throws IOException {
        handle.seek(256L);
        int len = 524288;
        byte[] buff = new byte[len];
        int rLen = handle.read(buff);
        if (rLen != len) {
            throw new IOException("incomplete read: read bytes should be " + len);
        }
        return buff;
    }

    public static byte[] loadVectorIndexFromFile(File xdbFile) throws IOException {
        RandomAccessFile handle = new RandomAccessFile(xdbFile, "r");
        byte[] vIndex = Searcher.loadVectorIndex(handle);
        handle.close();
        return vIndex;
    }

    public static byte[] loadVectorIndexFromFile(String xdbPath) throws IOException {
        return Searcher.loadVectorIndexFromFile(new File(xdbPath));
    }

    public static byte[] loadVectorIndexFromBuffer(LongByteArray cBuffer) throws IOException {
        int len = 524288;
        return cBuffer.slice(256L, 524288);
    }

    public static LongByteArray loadContent(RandomAccessFile handle) throws IOException {
        int rLen;
        handle.seek(0L);
        LongByteArray byteArray = new LongByteArray();
        for (long toRead = handle.length(); toRead > 0L; toRead -= (long)rLen) {
            byte[] buff = new byte[(int)Math.min(toRead, 0x7FFFF000L)];
            rLen = handle.read(buff);
            if (rLen != buff.length) {
                throw new IOException("incomplete read: read bytes should be " + buff.length + ", got `" + rLen + "`");
            }
            byteArray.append(buff);
        }
        return byteArray;
    }

    public static LongByteArray loadContentFromFile(File xdbFile) throws IOException {
        RandomAccessFile handle = new RandomAccessFile(xdbFile, "r");
        LongByteArray content = Searcher.loadContent(handle);
        handle.close();
        return content;
    }

    public static LongByteArray loadContentFromFile(String xdbPath) throws IOException {
        return Searcher.loadContentFromFile(new File(xdbPath));
    }

    public static LongByteArray loadContentFromInputStream(InputStream is) throws IOException {
        boolean done;
        LongByteArray byteArray = new LongByteArray();
        do {
            done = false;
            int tBytes = 0;
            byte[] buff = new byte[0x7FFFF000];
            while (true) {
                int rLen;
                if ((rLen = is.read(buff, tBytes, buff.length - tBytes)) == -1) {
                    done = true;
                    break;
                }
                if (rLen == 0) break;
                tBytes += rLen;
            }
            if (tBytes == buff.length) {
                byteArray.append(buff);
                continue;
            }
            byte[] nBuff = new byte[tBytes];
            System.arraycopy(buff, 0, nBuff, 0, tBytes);
            byteArray.append(nBuff);
        } while (!done);
        return byteArray;
    }

    public static void verify(Header header, long fileBytes) throws IOException, XdbException {
        int runtimePtrBytes = 0;
        if (header.version == 2) {
            runtimePtrBytes = 4;
        } else if (header.version == 3) {
            runtimePtrBytes = header.runtimePtrBytes;
        } else {
            throw new XdbException("invalid structure version `" + header.version + "`");
        }
        long maxFilePtr = (1L << runtimePtrBytes * 8) - 1L;
        if (fileBytes > maxFilePtr) {
            throw new XdbException("xdb file exceeds the maximum supported bytes: " + maxFilePtr + "");
        }
    }

    public static void verify(RandomAccessFile handle) throws IOException, XdbException {
        Searcher.verify(Searcher.loadHeader(handle), handle.length());
    }

    public static void verifyFromFile(File xdbFile) throws IOException, XdbException {
        RandomAccessFile handle = new RandomAccessFile(xdbFile, "r");
        Searcher.verify(handle);
        handle.close();
    }

    public static void verifyFromFile(String xdbPath) throws IOException, XdbException {
        Searcher.verifyFromFile(new File(xdbPath));
    }
}

