/*
 * Decompiled with CFR 0.152.
 */
package org.lionsoul.ip2region.xdb;

import java.text.SimpleDateFormat;
import java.util.Date;

public class Log {
    public static final int DEBUG = 0;
    public static final int INFO = 1;
    public static final int WARN = 2;
    public static final int ERROR = 3;
    public static final String[] level_string = new String[]{"DEBUG", "INFO", "WARN", "ERROR"};
    public final Class<?> baseClass;
    private int level = 1;

    public Log(Class<?> baseClass) {
        this.baseClass = baseClass;
    }

    public static Log getLogger(Class<?> baseClass) {
        return new Log(baseClass);
    }

    public String format(int level, String format, Object ... args) {
        StringBuilder sb = new StringBuilder();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        sb.append(String.format("%s %-5s ", sdf.format(new Date()), level_string[level]));
        sb.append(this.baseClass.getName()).append(' ');
        sb.append(String.format(format, args));
        return sb.toString();
    }

    public void printf(int level, String format, Object ... args) {
        if (level < 0 || level > 3) {
            throw new IndexOutOfBoundsException("invalid level index " + level);
        }
        if (level < this.level) {
            return;
        }
        System.out.println(this.format(level, format, args));
        System.out.flush();
    }

    public String getDebugf(String format, Object ... args) {
        return this.format(0, format, args);
    }

    public void debugf(String format, Object ... args) {
        this.printf(0, format, args);
    }

    public String getInfof(String format, Object ... args) {
        return this.format(1, format, args);
    }

    public void infof(String format, Object ... args) {
        this.printf(1, format, args);
    }

    public String getWarnf(String format, Object ... args) {
        return this.format(2, format, args);
    }

    public void warnf(String format, Object ... args) {
        this.printf(2, format, args);
    }

    public String getErrorf(String format, Object ... args) {
        return this.format(3, format, args);
    }

    public void errorf(String format, Object ... args) {
        this.printf(3, format, args);
    }

    public Log setLevel(int level) {
        this.level = level;
        return this;
    }

    public Log setLevel(String level) {
        String v = level.toLowerCase();
        if ("debug".equals(v)) {
            this.level = 0;
        } else if ("info".equals(v)) {
            this.level = 1;
        } else if ("warn".equals(v)) {
            this.level = 2;
        } else if ("error".equals(v)) {
            this.level = 3;
        }
        return this;
    }
}

