/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.plugin;

import java.io.File;
import java.util.List;
import org.mortbay.jetty.plugin.Jetty6MavenConfiguration;
import org.mortbay.jetty.plus.webapp.EnvConfiguration;
import org.mortbay.jetty.webapp.Configuration;
import org.mortbay.jetty.webapp.JettyWebXmlConfiguration;
import org.mortbay.jetty.webapp.TagLibConfiguration;
import org.mortbay.jetty.webapp.WebAppContext;
import org.mortbay.jetty.webapp.WebInfConfiguration;

public class Jetty6PluginWebAppContext
extends WebAppContext {
    private List classpathFiles;
    private File jettyEnvXmlFile;
    private File webXmlFile;
    private WebInfConfiguration webInfConfig = new WebInfConfiguration();
    private EnvConfiguration envConfig = new EnvConfiguration();
    private Jetty6MavenConfiguration mvnConfig = new Jetty6MavenConfiguration();
    private JettyWebXmlConfiguration jettyWebConfig = new JettyWebXmlConfiguration();
    private TagLibConfiguration tagConfig = new TagLibConfiguration();
    private Configuration[] configs = new Configuration[]{this.webInfConfig, this.envConfig, this.mvnConfig, this.jettyWebConfig, this.tagConfig};

    public Jetty6PluginWebAppContext() throws Exception {
        this.setConfigurations(this.configs);
    }

    public void setClassPathFiles(List classpathFiles) {
        this.classpathFiles = classpathFiles;
    }

    public void setWebXmlFile(File webXmlFile) {
        this.webXmlFile = webXmlFile;
    }

    public void setJettyEnvXmlFile(File jettyEnvXmlFile) {
        this.jettyEnvXmlFile = jettyEnvXmlFile;
    }

    public void configure() {
        this.setConfigurations(this.configs);
        this.mvnConfig.setClassPathConfiguration(this.classpathFiles);
        this.mvnConfig.setWebXml(this.webXmlFile);
        try {
            if (this.jettyEnvXmlFile != null) {
                this.envConfig.setJettyEnvXml(this.jettyEnvXmlFile.toURL());
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void doStart() throws Exception {
        this.setShutdown(false);
        super.doStart();
    }

    public void doStop() throws Exception {
        this.setShutdown(true);
        Thread.currentThread();
        Thread.sleep(500L);
        super.doStop();
    }
}

