/*
 * Decompiled with CFR 0.152.
 */
package org.jxls.reader;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.poi.ss.usermodel.Sheet;
import org.jxls.reader.ConvertUtilsBeanProvider;
import org.jxls.reader.ConvertUtilsBeanProviderDelegate;
import org.jxls.reader.XLSBlockReader;
import org.jxls.reader.XLSReadStatus;
import org.jxls.reader.XLSRowCursorImpl;
import org.jxls.reader.XLSSheetReader;

public class XLSSheetReaderImpl
implements XLSSheetReader {
    List blockReaders = new ArrayList();
    String sheetName;
    int sheetIdx = -1;
    XLSReadStatus readStatus = new XLSReadStatus();
    ConvertUtilsBeanProviderDelegate convertUtilsBeanProvider = new ConvertUtilsBeanProviderDelegate();

    @Override
    public XLSReadStatus read(Sheet sheet, Map beans) {
        this.readStatus.clear();
        XLSRowCursorImpl cursor = new XLSRowCursorImpl(this.sheetName, sheet);
        for (int i = 0; i < this.blockReaders.size(); ++i) {
            XLSBlockReader blockReader = (XLSBlockReader)this.blockReaders.get(i);
            this.readStatus.mergeReadStatus(blockReader.read(cursor, beans));
            cursor.moveForward();
        }
        return this.readStatus;
    }

    public String getSheetNameBySheetIdx(Sheet sheet, int idx) {
        Sheet sheetAtIdx = sheet.getWorkbook().getSheetAt(idx);
        return sheetAtIdx.getSheetName();
    }

    @Override
    public void setConvertUtilsBeanProvider(ConvertUtilsBeanProvider provider) {
        this.convertUtilsBeanProvider.setDelegate(provider);
    }

    @Override
    public List getBlockReaders() {
        return this.blockReaders;
    }

    @Override
    public void setBlockReaders(List blockReaders) {
        this.blockReaders = blockReaders;
        Iterator it = this.blockReaders.iterator();
        while (it.hasNext()) {
            ((XLSBlockReader)it.next()).setConvertUtilsBeanProvider(this.convertUtilsBeanProvider);
        }
    }

    @Override
    public void addBlockReader(XLSBlockReader blockReader) {
        blockReader.setConvertUtilsBeanProvider(this.convertUtilsBeanProvider);
        this.blockReaders.add(blockReader);
    }

    @Override
    public String getSheetName() {
        return this.sheetName;
    }

    @Override
    public void setSheetName(String sheetName) {
        this.sheetName = sheetName;
    }

    @Override
    public int getSheetIdx() {
        return this.sheetIdx;
    }

    @Override
    public void setSheetIdx(int sheetIdx) {
        this.sheetIdx = sheetIdx;
    }
}

