/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.engine.descriptor;

import java.util.HashSet;
import java.util.Set;
import java.util.function.Predicate;
import org.apiguardian.api.API;
import org.junit.platform.engine.UniqueId;

@API(status=API.Status.INTERNAL, since="5.1")
public class DynamicDescendantFilter
implements Predicate<UniqueId> {
    private final Set<UniqueId> allowed = new HashSet<UniqueId>();
    private Mode mode = Mode.EXPLICIT;

    public void allow(UniqueId uniqueId) {
        if (this.mode == Mode.EXPLICIT) {
            this.allowed.add(uniqueId);
        }
    }

    public void allowAll() {
        this.mode = Mode.ALLOW_ALL;
        this.allowed.clear();
    }

    @Override
    public boolean test(UniqueId uniqueId) {
        return this.allowed.isEmpty() || this.allowed.stream().anyMatch(allowedUniqueId -> this.isAllowed(uniqueId, (UniqueId)allowedUniqueId));
    }

    private boolean isAllowed(UniqueId currentUniqueId, UniqueId allowedUniqueId) {
        return allowedUniqueId.hasPrefix(currentUniqueId) || currentUniqueId.hasPrefix(allowedUniqueId);
    }

    private static enum Mode {
        EXPLICIT,
        ALLOW_ALL;

    }
}

