/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime.ivars;

import com.headius.invokebinder.Binder;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import org.jruby.RubyBasicObject;
import org.jruby.RubyClass;
import org.jruby.runtime.Helpers;
import org.jruby.runtime.ivars.VariableAccessor;
import org.jruby.specialized.RubyObjectSpecializer;

public class FieldVariableAccessor
extends VariableAccessor {
    private final MethodHandle getter;
    private final MethodHandle setter;
    private static final MethodHandle ENSURE_SETTABLE = Binder.from(Object.class, Object.class, (Class[])new Class[]{Object.class}).dropLast().cast(Void.TYPE, new Class[]{RubyBasicObject.class}).invokeVirtualQuiet(RubyObjectSpecializer.LOOKUP, "ensureInstanceVariablesSettable");

    public FieldVariableAccessor(RubyClass realClass, String name2, int index2, int classId, MethodHandle getter, MethodHandle setter) {
        super(realClass, name2, index2, classId);
        this.getter = getter;
        this.setter = setter = MethodHandles.foldArguments(setter, ENSURE_SETTABLE.asType(setter.type()));
    }

    public MethodHandle getGetter() {
        return this.getter;
    }

    public MethodHandle getSetter() {
        return this.setter;
    }

    @Override
    public Object get(Object object) {
        try {
            return this.getter.invoke(object);
        }
        catch (Throwable t) {
            Helpers.throwException(t);
            return null;
        }
    }

    @Override
    public void set(Object object, Object value2) {
        try {
            this.setter.invoke(object, value2);
        }
        catch (Throwable t) {
            Helpers.throwException(t);
        }
    }
}

