/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime.load;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.AccessControlException;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Function;
import java.util.jar.JarFile;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.zip.ZipException;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyDir;
import org.jruby.RubyFile;
import org.jruby.RubyHash;
import org.jruby.RubyInstanceConfig;
import org.jruby.RubyString;
import org.jruby.RubyThread;
import org.jruby.ast.executable.Script;
import org.jruby.exceptions.CatchThrow;
import org.jruby.exceptions.JumpException;
import org.jruby.exceptions.LoadError;
import org.jruby.exceptions.MainExitException;
import org.jruby.exceptions.RaiseException;
import org.jruby.exceptions.StandardError;
import org.jruby.exceptions.Unrescuable;
import org.jruby.ext.rbconfig.RbConfigLibrary;
import org.jruby.platform.Platform;
import org.jruby.runtime.Helpers;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.load.BasicLibraryService;
import org.jruby.runtime.load.ClassExtensionLibrary;
import org.jruby.runtime.load.ExternalScript;
import org.jruby.runtime.load.JarredScript;
import org.jruby.runtime.load.JavaCompiledScript;
import org.jruby.runtime.load.Library;
import org.jruby.runtime.load.LibrarySearcher;
import org.jruby.runtime.load.LoadServiceResource;
import org.jruby.util.FileResource;
import org.jruby.util.JRubyFile;
import org.jruby.util.URLUtil;
import org.jruby.util.collections.StringArraySet;
import org.jruby.util.log.Logger;
import org.jruby.util.log.LoggerFactory;

public class LoadService {
    static final Logger LOG = LoggerFactory.getLogger(LoadService.class);
    private final LoadTimer loadTimer;
    private boolean canGetAbsolutePath = true;
    protected static final Pattern sourcePattern = Pattern.compile("\\.(?:rb)$");
    protected static final Pattern extensionPattern = Pattern.compile("\\.(?:so|o|jar)$");
    protected RubyArray loadPath;
    protected StringArraySet loadedFeatures;
    protected final Map<String, JarFile> jarFiles = new HashMap<String, JarFile>();
    protected final Ruby runtime;
    protected LibrarySearcher librarySearcher;
    final RequireLocks requireLocks = new RequireLocks();
    private static final Pattern URI_PATTERN = Pattern.compile("([a-z]+?://.*)$");
    @Deprecated
    protected final Map<String, Library> builtinLibraries = new HashMap<String, Library>(36);

    public LoadService(Ruby runtime2) {
        this.runtime = runtime2;
        this.loadTimer = RubyInstanceConfig.DEBUG_LOAD_TIMINGS ? new TracingLoadTimer() : new LoadTimer();
    }

    public void init(List<String> prependDirectories) {
        this.loadPath = RubyArray.newArray(this.runtime);
        String jrubyHome = this.runtime.getJRubyHome();
        this.loadedFeatures = new StringArraySet(this.runtime);
        this.librarySearcher = new LibrarySearcher(this);
        this.addPaths(prependDirectories);
        RubyHash env = (RubyHash)this.runtime.getObject().getConstant("ENV");
        RubyString env_rubylib = this.runtime.newString("RUBYLIB");
        ThreadContext currentContext = this.runtime.getCurrentContext();
        if (env.has_key_p(currentContext, env_rubylib).isTrue()) {
            String rubylib = env.op_aref(currentContext, env_rubylib).toString();
            String[] paths = rubylib.split(File.pathSeparator);
            this.addPaths(paths);
        }
        try {
            if (jrubyHome != null) {
                String rubygemsDir;
                this.addPath(RbConfigLibrary.getSiteDir(this.runtime));
                if (!RbConfigLibrary.isSiteVendorSame(this.runtime).booleanValue()) {
                    this.addPath(RbConfigLibrary.getVendorDir(this.runtime));
                }
                if ((rubygemsDir = RbConfigLibrary.getRubygemsDir(this.runtime)) != null) {
                    this.addPath(rubygemsDir);
                }
                this.addPath(RbConfigLibrary.getRubyLibDir(this.runtime));
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        this.addPaths(this.runtime.getInstanceConfig().getExtraLoadPaths());
    }

    public void addPaths(List<String> additionalDirectories) {
        for (String dir : additionalDirectories) {
            this.addPath(dir);
        }
    }

    public void addPaths(String ... additionalDirectories) {
        for (String dir : additionalDirectories) {
            this.addPath(dir);
        }
    }

    public void provide(String name2) {
        this.librarySearcher.provideFeature(this.runtime.newString(name2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addPath(String path2) {
        RubyArray loadPath;
        if (path2 == null || path2.length() == 0) {
            return;
        }
        RubyArray rubyArray = loadPath = this.loadPath;
        synchronized (rubyArray) {
            RubyString pathToAdd = this.runtime.newString(path2.replace('\\', '/'));
            if (loadPath.includes(this.runtime.getCurrentContext(), pathToAdd)) {
                return;
            }
            loadPath.append(pathToAdd);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load(String file2, boolean wrap2) {
        long startTime = this.loadTimer.startLoad(file2);
        int currentLine = this.runtime.getCurrentLine();
        try {
            if (!this.runtime.getProfile().allowLoad(file2)) {
                throw this.runtime.newLoadError("no such file to load -- " + file2, file2);
            }
            LibrarySearcher.FoundLibrary library2 = this.librarySearcher.findLibraryForLoad(file2);
            if (library2 == null) {
                FileResource fileResource = JRubyFile.createResourceAsFile(this.runtime, file2);
                if (!fileResource.exists()) {
                    throw this.runtime.newLoadError("no such file to load -- " + file2, file2);
                }
                library2 = new LibrarySearcher.FoundLibrary(file2, file2, LibrarySearcher.ResourceLibrary.create(file2, file2, fileResource));
            }
            try {
                library2.load(this.runtime, wrap2);
            }
            catch (IOException e) {
                LoadService.debugLoadException(this.runtime, e);
                throw LoadService.newLoadErrorFromThrowable(this.runtime, file2, e);
            }
        }
        finally {
            this.runtime.setCurrentLine(currentLine);
            this.loadTimer.endLoad(file2, startTime);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadFromClassLoader(ClassLoader classLoader, String file2, boolean wrap2) {
        long startTime = this.loadTimer.startLoad("classloader:" + file2);
        int currentLine = this.runtime.getCurrentLine();
        try {
            String[] fileHolder = new String[]{file2};
            LibrarySearcher.getSuffixTypeForLoad(fileHolder);
            String baseName = fileHolder[0];
            LoadServiceResource resource2 = this.getClassPathResource(classLoader, file2);
            if (resource2 == null) {
                throw this.runtime.newLoadError("no such file to load -- " + file2);
            }
            String loadName = this.resolveLoadName(resource2, file2);
            LibrarySearcher.FoundLibrary library2 = new LibrarySearcher.FoundLibrary(baseName, loadName, this.createLibrary(baseName, loadName, resource2));
            try {
                library2.load(this.runtime, wrap2);
            }
            catch (IOException e) {
                LoadService.debugLoadException(this.runtime, e);
                throw LoadService.newLoadErrorFromThrowable(this.runtime, file2, e);
            }
        }
        finally {
            this.runtime.setCurrentLine(currentLine);
            this.loadTimer.endLoad("classloader:" + file2, startTime);
        }
    }

    public boolean require(String requireName) {
        return this.smartLoadInternal(requireName, true) == RequireState.LOADED;
    }

    public boolean autoloadRequire(RubyString requireName) {
        return this.runtime.getTopSelf().callMethod(this.runtime.getCurrentContext(), "require", requireName).isTrue();
    }

    protected void warnCircularRequire(String requireName) {
        StringBuilder sb = new StringBuilder("loading in progress, circular require considered harmful - " + requireName);
        this.runtime.getCurrentContext().renderCurrentBacktrace(sb);
        this.runtime.getWarnings().warn(sb.toString());
    }

    private RequireState smartLoadInternal(String file2, boolean circularRequireWarning) {
        this.checkEmptyLoad(file2);
        if (!this.runtime.getProfile().allowRequire(file2)) {
            throw this.runtime.newLoadError("no such file to load -- " + file2, file2);
        }
        LibrarySearcher.FoundLibrary[] libraryHolder = new LibrarySearcher.FoundLibrary[]{null};
        char found = this.searchForRequire(file2, libraryHolder);
        if (found == '\u0000') {
            throw this.runtime.newLoadError("no such file to load -- " + file2, file2);
        }
        LibrarySearcher.FoundLibrary library2 = libraryHolder[0];
        if (library2 == null) {
            return RequireState.ALREADY_LOADED;
        }
        String loadName = library2.getLoadName();
        return this.requireLocks.lock(loadName, circularRequireWarning, RequireState.ALREADY_LOADED, name2 -> {
            if (this.librarySearcher.getLoadedFeature((String)name2) != null) {
                return RequireState.ALREADY_LOADED;
            }
            if (name2.length() == 0) {
                this.provide((String)name2);
                return RequireState.LOADED;
            }
            long startTime = this.loadTimer.startLoad((String)name2);
            try {
                this.tryLoadingLibraryOrScript(this.runtime, library2, library2.getSearchName());
                this.provide((String)name2);
                RequireState requireState = RequireState.LOADED;
                return requireState;
            }
            finally {
                this.loadTimer.endLoad((String)name2, startTime);
            }
        });
    }

    public static void reflectedLoad(Ruby runtime2, String libraryName, String className, ClassLoader classLoader, boolean wrap2) {
        block6: {
            try {
                Object libObject;
                if (classLoader == null && Ruby.isSecurityRestricted()) {
                    classLoader = runtime2.getInstanceConfig().getLoader();
                }
                if ((libObject = classLoader.loadClass(className).getConstructor(new Class[0]).newInstance(new Object[0])) instanceof Library) {
                    Library library2 = (Library)libObject;
                    library2.load(runtime2, false);
                    break block6;
                }
                if (libObject instanceof BasicLibraryService) {
                    BasicLibraryService service = (BasicLibraryService)libObject;
                    service.basicLoad(runtime2);
                    break block6;
                }
                throw runtime2.newLoadError("library `" + libraryName + "' is not of type Library or BasicLibraryService", libraryName);
            }
            catch (RaiseException re) {
                throw re;
            }
            catch (Throwable e) {
                LoadService.debugLoadException(runtime2, e);
                throw runtime2.newLoadError("library `" + libraryName + "' could not be loaded: " + e, libraryName);
            }
        }
    }

    private static void debugLoadException(Ruby runtime2, Throwable ex) {
        if (runtime2.isDebug()) {
            ex.printStackTrace(runtime2.getErr());
        }
    }

    public IRubyObject getLoadPath() {
        return this.loadPath;
    }

    public IRubyObject getLoadedFeatures() {
        return this.loadedFeatures;
    }

    protected boolean isJarfileLibrary(Library library2, String file2) {
        return library2 instanceof JarredScript && file2.endsWith(".jar");
    }

    protected boolean tryLoadingLibraryOrScript(Ruby runtime2, Library library2, String searchFile) {
        try {
            library2.load(runtime2, false);
            return true;
        }
        catch (MainExitException ex) {
            throw ex;
        }
        catch (RaiseException ex) {
            if (ex instanceof Unrescuable) {
                Helpers.throwException(ex);
            }
            if (this.isJarfileLibrary(library2, searchFile)) {
                return true;
            }
            throw ex;
        }
        catch (JumpException ex) {
            throw ex;
        }
        catch (CatchThrow ex) {
            throw ex;
        }
        catch (Throwable ex) {
            if (ex instanceof Unrescuable) {
                Helpers.throwException(ex);
            }
            if (this.isJarfileLibrary(library2, searchFile)) {
                return true;
            }
            LoadService.debugLoadException(runtime2, ex);
            RaiseException re = LoadService.newLoadErrorFromThrowable(runtime2, searchFile, ex);
            re.initCause(ex);
            throw re;
        }
    }

    private static RaiseException newLoadErrorFromThrowable(Ruby runtime2, String file2, Throwable t) {
        if (RubyInstanceConfig.DEBUG_PARSER || RubyInstanceConfig.IR_READING_DEBUG) {
            t.printStackTrace();
        }
        return runtime2.newLoadError(String.format("load error: %s -- %s: %s", file2, t.getClass().getName(), t.getMessage()), file2);
    }

    protected void checkEmptyLoad(String file2) throws RaiseException {
        if (file2.isEmpty()) {
            throw this.runtime.newLoadError("no such file to load -- " + file2, file2);
        }
    }

    protected final void debugLogTry(String what, String msg) {
        if (RubyInstanceConfig.DEBUG_LOAD_SERVICE) {
            LOG.info("trying {}: {}", what, msg);
        }
    }

    protected final void debugLogFound(LoadServiceResource resource2) {
        if (RubyInstanceConfig.DEBUG_LOAD_SERVICE) {
            String resourceUrl;
            try {
                resourceUrl = resource2.getURL().toString();
            }
            catch (IOException e) {
                resourceUrl = e.getMessage();
            }
            LOG.info("found: {}", resourceUrl);
        }
    }

    protected final void debugLogFound(String what, String msg) {
        if (RubyInstanceConfig.DEBUG_LOAD_SERVICE) {
            LOG.info("found {}: {}", what, msg);
        }
    }

    protected char searchForRequire(String file2, LibrarySearcher.FoundLibrary[] path2) {
        return this.librarySearcher.findLibraryForRequire(file2, path2);
    }

    protected LibrarySearcher.FoundLibrary searchForLoad(String file2) {
        return this.librarySearcher.findLibraryForLoad(file2);
    }

    public boolean featureAlreadyLoaded(String feature) {
        return this.librarySearcher.featureAlreadyLoaded(feature, null);
    }

    public boolean featureAlreadyLoaded(String feature, String[] loading) {
        return this.librarySearcher.featureAlreadyLoaded(feature, loading);
    }

    protected LibrarySearcher.FoundLibrary findLibraryWithClassloaders(String baseName, SuffixType suffixType) {
        for (LibrarySearcher.Suffix suffix : suffixType.getSuffixSet()) {
            String file2 = baseName + (Object)((Object)suffix);
            LoadServiceResource resource2 = this.findFileInClasspath(file2);
            if (resource2 == null) continue;
            String loadName = this.resolveLoadName(resource2, file2);
            return new LibrarySearcher.FoundLibrary(baseName, loadName, this.createLibrary(baseName, loadName, resource2));
        }
        return null;
    }

    protected Library createLibrary(String baseName, String loadName, LoadServiceResource resource2) {
        if (resource2 == null) {
            return null;
        }
        String file2 = resource2.getName();
        String location = loadName;
        if (file2.endsWith(".so") || file2.endsWith(".dll") || file2.endsWith(".bundle")) {
            throw this.runtime.newLoadError("C extensions are not supported, can't load `" + resource2.getName() + "'", resource2.getName());
        }
        if (file2.endsWith(".jar")) {
            return new JarredScript(resource2, baseName);
        }
        if (file2.endsWith(".class")) {
            return new JavaCompiledScript(resource2);
        }
        return new ExternalScript(resource2, location);
    }

    protected String getLoadPathEntry(IRubyObject entry) {
        return RubyFile.get_path(this.runtime.getCurrentContext(), entry).asJavaString();
    }

    public JarFile getJarFile(String jarFileName) {
        JarFile jarFile = this.jarFiles.get(jarFileName);
        if (null == jarFile) {
            try {
                jarFile = new JarFile(jarFileName);
                this.jarFiles.put(jarFileName, jarFile);
            }
            catch (ZipException ignored) {
                if (this.runtime.getInstanceConfig().isDebug()) {
                    LOG.info("ZipException trying to access " + jarFileName, ignored);
                }
            }
            catch (FileNotFoundException ignored) {
            }
            catch (IOException e) {
                throw this.runtime.newIOErrorFromException(e);
            }
        }
        return jarFile;
    }

    protected boolean loadPathLooksLikeJarURL(String loadPathEntry) {
        return loadPathEntry.startsWith("jar:") || loadPathEntry.endsWith(".jar") || loadPathEntry.startsWith("file:") && loadPathEntry.indexOf("!") != -1;
    }

    protected boolean loadPathLooksLikeClasspathURL(String loadPathEntry) {
        return loadPathEntry.startsWith("classpath:");
    }

    private String[] splitJarUrl(String loadPathEntry) {
        String entry;
        String unescaped = loadPathEntry;
        try {
            unescaped = new URI(loadPathEntry).getSchemeSpecificPart();
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        int idx = unescaped.indexOf(33);
        if (idx == -1) {
            return new String[]{unescaped, ""};
        }
        String filename2 = unescaped.substring(0, idx);
        String string2 = entry = idx + 2 < unescaped.length() ? unescaped.substring(idx + 2) : "";
        if (filename2.startsWith("jar:")) {
            filename2 = filename2.substring(4);
        }
        if (filename2.startsWith("file:")) {
            filename2 = filename2.substring(5);
        }
        return new String[]{filename2, entry};
    }

    protected LoadServiceResource findFileInClasspath(String name2) {
        ClassLoader classLoader = this.runtime.getJRubyClassLoader();
        if (Ruby.isSecurityRestricted() && classLoader == null) {
            classLoader = this.runtime.getInstanceConfig().getLoader();
        }
        if (name2.startsWith("classpath:/")) {
            LoadServiceResource foundResource = this.getClassPathResource(classLoader, name2);
            if (foundResource != null) {
                return foundResource;
            }
        } else if (name2.startsWith("classpath:")) {
            name2 = name2.substring("classpath:".length());
        }
        for (int i2 = 0; i2 < this.loadPath.size(); ++i2) {
            String entry = this.getLoadPathEntry((IRubyObject)this.loadPath.eltInternal(i2));
            if (entry.length() == 0 || entry.charAt(0) == '/' || entry.length() > 1 && entry.charAt(1) == ':') continue;
            if (entry.startsWith("classpath:/")) {
                entry = entry.substring("classpath:/".length());
            } else if (entry.startsWith("classpath:")) {
                entry = entry.substring("classpath:".length());
            }
            String entryName = name2.startsWith(entry) ? name2.substring(entry.length()) : name2;
            LoadServiceResource foundResource = this.getClassPathResource(classLoader, entry + "/" + entryName);
            if (foundResource == null) continue;
            return foundResource;
        }
        if (name2.charAt(0) == '/' || name2.length() > 1 && name2.charAt(1) == ':') {
            return null;
        }
        LoadServiceResource foundResource = this.getClassPathResource(classLoader, name2);
        if (foundResource != null) {
            return foundResource;
        }
        return null;
    }

    protected static boolean isRequireable(URL loc) {
        if (loc != null) {
            if (loc.getProtocol().equals("file") && new File(URLUtil.getPath(loc)).isDirectory()) {
                return false;
            }
            try {
                loc.openConnection();
                return true;
            }
            catch (Exception exception2) {
                // empty catch block
            }
        }
        return false;
    }

    public LoadServiceResource getClassPathResource(ClassLoader classLoader, String name2) {
        URL loc;
        boolean isClasspathScheme = false;
        if (name2.startsWith("classpath:/")) {
            isClasspathScheme = true;
            name2 = name2.substring("classpath:/".length());
        } else if (name2.startsWith("classpath:")) {
            isClasspathScheme = true;
            name2 = name2.substring("classpath:".length());
        } else if (name2.startsWith("file:") && name2.indexOf("!/") != -1) {
            name2 = name2.substring(name2.indexOf("!/") + 2);
        }
        Matcher m = URI_PATTERN.matcher(name2);
        if (m.matches()) {
            this.debugLogTry("fileInClassloader", m.group(1));
            try {
                loc = new URL(m.group(1).replaceAll("([^:])//", "$1/"));
                loc.openStream();
            }
            catch (IOException e) {
                loc = null;
            }
        } else {
            this.debugLogTry("fileInClasspath", name2);
            try {
                loc = classLoader.getResource(name2);
            }
            catch (IllegalArgumentException e) {
                loc = null;
            }
        }
        if (loc != null) {
            String path2 = LoadService.classpathFilenameFromURL(name2, loc, isClasspathScheme);
            LoadServiceResource foundResource = new LoadServiceResource(loc, path2);
            this.debugLogFound(foundResource);
            return foundResource;
        }
        return null;
    }

    public static String classpathFilenameFromURL(String name2, URL loc, boolean isClasspathScheme) {
        String path2 = "classpath:/" + name2;
        if (!isClasspathScheme && (loc.getProtocol().equals("jar") || loc.getProtocol().equals("file")) && LoadService.isRequireable(loc)) {
            path2 = URLUtil.getPath(loc);
            if (Platform.IS_WINDOWS && loc.getProtocol().equals("file")) {
                path2 = new File(path2).getPath();
            }
        }
        return path2;
    }

    private String expandRelativeJarPath(String path2) {
        return path2.replaceAll("/[^/]+/\\.\\.|[^/]+/\\.\\./|\\./", "").replace("^\\\\", "/");
    }

    protected String resolveLoadName(LoadServiceResource foundResource, String previousPath) {
        if (this.canGetAbsolutePath) {
            try {
                String path2 = foundResource.getAbsolutePath();
                if (Platform.IS_WINDOWS) {
                    path2 = path2.replace('\\', '/');
                }
                return path2;
            }
            catch (AccessControlException ace) {
                this.runtime.getWarnings().warn("can't canonicalize loaded names due to security restrictions; disabling");
                this.canGetAbsolutePath = false;
            }
        }
        return this.resolveLoadName(foundResource, previousPath);
    }

    @Deprecated
    protected String getFileName(JRubyFile file2, String namePlusSuffix) {
        return file2.getAbsolutePath();
    }

    @Deprecated
    public void addBuiltinLibrary(String name2, Library library2) {
        this.builtinLibraries.put(name2, library2);
    }

    @Deprecated
    public void removeBuiltinLibrary(String name2) {
        this.builtinLibraries.remove(name2);
    }

    @Deprecated
    public List<String> getBuiltinLibraries() {
        return this.builtinLibraries.keySet().stream().collect(Collectors.toList());
    }

    @Deprecated
    public boolean smartLoad(String file2) {
        return this.require(file2);
    }

    @Deprecated
    protected void addLoadedFeature(String name2) {
        this.addLoadedFeature(name2, name2);
    }

    @Deprecated
    protected String buildClassName(String className) {
        int lastDot = (className = className.replaceFirst("^\\.\\/", "")).lastIndexOf(46);
        if (lastDot != -1) {
            className = className.substring(0, lastDot);
        }
        className = className.replace("-", "_minus_").replace('.', '_');
        return className;
    }

    @Deprecated
    protected Library findBuiltinLibrary(SearchState state2, String baseName, SuffixType suffixType) {
        for (String suffix : suffixType.getSuffixes()) {
            String namePlusSuffix = baseName + suffix;
            this.debugLogTry("builtinLib", namePlusSuffix);
            if (!this.builtinLibraries.containsKey(namePlusSuffix)) continue;
            state2.setLoadName(namePlusSuffix);
            Library lib = this.builtinLibraries.get(namePlusSuffix);
            this.debugLogFound("builtinLib", namePlusSuffix);
            return lib;
        }
        return null;
    }

    @Deprecated
    protected Library findLibraryWithoutCWD(SearchState state2, String baseName, SuffixType suffixType) {
        Library library2 = null;
        switch (suffixType) {
            case Both: {
                library2 = this.findBuiltinLibrary(state2, baseName, SuffixType.Source);
                if (library2 == null) {
                    library2 = this.createLibrary(state2, this.tryResourceFromJarURL(state2, baseName, SuffixType.Source));
                }
                if (library2 == null) {
                    library2 = this.createLibrary(state2, this.tryResourceFromLoadPathOrURL(state2, baseName, SuffixType.Source));
                }
                if (library2 == null) {
                    library2 = this.findBuiltinLibrary(state2, baseName, SuffixType.Extension);
                }
                if (library2 == null) {
                    library2 = this.createLibrary(state2, this.tryResourceFromJarURL(state2, baseName, SuffixType.Extension));
                }
                if (library2 != null) break;
                library2 = this.createLibrary(state2, this.tryResourceFromLoadPathOrURL(state2, baseName, SuffixType.Extension));
                break;
            }
            case Source: 
            case Extension: {
                library2 = this.findBuiltinLibrary(state2, baseName, suffixType);
                if (library2 == null) {
                    library2 = this.createLibrary(state2, this.tryResourceFromJarURL(state2, baseName, suffixType));
                }
                if (library2 != null) break;
                library2 = this.createLibrary(state2, this.tryResourceFromLoadPathOrURL(state2, baseName, suffixType));
                break;
            }
            case Neither: {
                library2 = this.createLibrary(state2, this.tryResourceFromJarURL(state2, baseName, SuffixType.Neither));
                if (library2 != null) break;
                library2 = this.createLibrary(state2, this.tryResourceFromLoadPathOrURL(state2, baseName, SuffixType.Neither));
            }
        }
        return library2;
    }

    @Deprecated
    protected LoadServiceResource tryResourceFromCWD(SearchState state2, String baseName, SuffixType suffixType) throws RaiseException {
        LoadServiceResource foundResource = null;
        for (String suffix : suffixType.getSuffixes()) {
            String namePlusSuffix = baseName + suffix;
            try {
                JRubyFile file2 = JRubyFile.create(this.runtime.getCurrentDirectory(), RubyFile.expandUserPath(this.runtime.getCurrentContext(), namePlusSuffix));
                this.debugLogTry("resourceFromCWD", file2.toString());
                if (!file2.isFile() || !file2.isAbsolute() || !file2.canRead()) continue;
                boolean absolute = true;
                foundResource = new LoadServiceResource((File)((Object)file2), this.getFileName(file2, namePlusSuffix), absolute);
                this.debugLogFound(foundResource);
                state2.setLoadName(this.resolveLoadName(foundResource, namePlusSuffix));
                break;
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
        return foundResource;
    }

    @Deprecated
    protected LoadServiceResource tryResourceFromDotSlash(SearchState state2, String baseName, SuffixType suffixType) throws RaiseException {
        LoadServiceResource foundResource = null;
        for (String suffix : suffixType.getSuffixes()) {
            String namePlusSuffix = baseName + suffix;
            foundResource = this.tryResourceAsIs(namePlusSuffix, "resourceFromDotSlash");
            if (foundResource != null) break;
        }
        return foundResource;
    }

    @Deprecated
    protected LoadServiceResource tryResourceFromHome(SearchState state2, String baseName, SuffixType suffixType) throws RaiseException {
        LoadServiceResource foundResource = null;
        Optional<String> maybeHome = RubyDir.getHomeFromEnv(this.runtime);
        if (!maybeHome.isPresent()) {
            return null;
        }
        String home2 = maybeHome.get();
        String path2 = baseName.substring(2);
        for (String suffix : suffixType.getSuffixes()) {
            String namePlusSuffix = path2 + suffix;
            try {
                JRubyFile file2 = JRubyFile.create(home2, RubyFile.expandUserPath(this.runtime.getCurrentContext(), namePlusSuffix));
                this.debugLogTry("resourceFromHome", file2.toString());
                if (!file2.isFile() || !file2.isAbsolute() || !file2.canRead()) continue;
                boolean absolute = true;
                state2.setLoadName(file2.getPath());
                foundResource = new LoadServiceResource((File)((Object)file2), state2.loadName, absolute);
                this.debugLogFound(foundResource);
                break;
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
        return foundResource;
    }

    @Deprecated
    protected LoadServiceResource tryResourceFromJarURL(SearchState state2, String baseName, SuffixType suffixType) {
        LoadServiceResource foundResource;
        block14: {
            block15: {
                foundResource = null;
                if (baseName.startsWith("jar:file:")) {
                    return this.tryResourceFromJarURL(state2, baseName.replaceFirst("jar:", ""), suffixType);
                }
                if (!baseName.startsWith("jar:")) break block15;
                for (String suffix : suffixType.getSuffixes()) {
                    String namePlusSuffix = baseName + suffix;
                    try {
                        URI resourceUri = new URI("jar", namePlusSuffix.substring(4), null);
                        URL url = resourceUri.toURL();
                        this.debugLogTry("resourceFromJarURL", url.toString());
                        if (url.openStream() != null) {
                            foundResource = new LoadServiceResource(url, namePlusSuffix);
                            this.debugLogFound(foundResource);
                        }
                    }
                    catch (FileNotFoundException resourceUri) {
                    }
                    catch (URISyntaxException e) {
                        throw this.runtime.newIOError(e.getMessage());
                    }
                    catch (MalformedURLException e) {
                        throw this.runtime.newIOErrorFromException(e);
                    }
                    catch (IOException e) {
                        throw this.runtime.newIOErrorFromException(e);
                    }
                    if (foundResource == null) continue;
                    state2.setLoadName(this.resolveLoadName(foundResource, namePlusSuffix));
                    break block14;
                }
                break block14;
            }
            if (!baseName.startsWith("file:") || baseName.indexOf("!/") == -1) break block14;
            for (String suffix : suffixType.getSuffixes()) {
                String namePlusSuffix = baseName + suffix;
                try {
                    String jarFile = namePlusSuffix.substring(5, namePlusSuffix.indexOf("!/"));
                    JarFile file2 = new JarFile(jarFile);
                    String expandedFilename = this.expandRelativeJarPath(namePlusSuffix.substring(namePlusSuffix.indexOf("!/") + 2));
                    this.debugLogTry("resourceFromJarURL", expandedFilename);
                    if (file2.getJarEntry(expandedFilename) != null) {
                        URI resourceUri = new URI("jar", "file:" + jarFile + "!/" + expandedFilename, null);
                        foundResource = new LoadServiceResource(resourceUri.toURL(), namePlusSuffix);
                        this.debugLogFound(foundResource);
                    }
                }
                catch (URISyntaxException e) {
                    throw this.runtime.newIOError(e.getMessage());
                }
                catch (MalformedURLException e) {
                    throw this.runtime.newIOErrorFromException(e);
                }
                catch (Exception exception2) {
                    // empty catch block
                }
                if (foundResource == null) continue;
                state2.setLoadName(this.resolveLoadName(foundResource, namePlusSuffix));
                break;
            }
        }
        return foundResource;
    }

    @Deprecated
    protected LoadServiceResource tryResourceFromLoadPathOrURL(SearchState state2, String baseName, SuffixType suffixType) {
        LoadServiceResource foundResource = null;
        if (baseName.startsWith("./")) {
            foundResource = this.tryResourceFromDotSlash(state2, baseName, suffixType);
            if (foundResource != null) {
                state2.setLoadName(this.resolveLoadName(foundResource, foundResource.getName()));
            }
            return foundResource;
        }
        if (baseName.startsWith("~/")) {
            foundResource = this.tryResourceFromHome(state2, baseName, suffixType);
            if (foundResource != null) {
                state2.setLoadName(this.resolveLoadName(foundResource, foundResource.getName()));
            }
            return foundResource;
        }
        if (new File(baseName).isAbsolute() || baseName.startsWith("../")) {
            for (String suffix : suffixType.getSuffixes()) {
                String namePlusSuffix = baseName + suffix;
                foundResource = this.tryResourceAsIs(namePlusSuffix);
                if (foundResource == null) continue;
                state2.setLoadName(this.resolveLoadName(foundResource, namePlusSuffix));
                return foundResource;
            }
            return null;
        }
        block1: for (int i2 = 0; i2 < this.loadPath.size(); ++i2) {
            String loadPathEntry = this.getLoadPathEntry((IRubyObject)this.loadPath.eltInternal(i2));
            if (loadPathEntry.equals(".") || loadPathEntry.equals("")) {
                foundResource = this.tryResourceFromCWD(state2, baseName, suffixType);
                if (foundResource == null) continue;
                String ss = foundResource.getName();
                if (ss.startsWith("./")) {
                    ss = ss.substring(2);
                }
                state2.setLoadName(this.resolveLoadName(foundResource, ss));
                break;
            }
            boolean looksLikeJarURL = this.loadPathLooksLikeJarURL(loadPathEntry);
            boolean looksLikeClasspathURL = this.loadPathLooksLikeClasspathURL(loadPathEntry);
            for (String suffix : suffixType.getSuffixes()) {
                String namePlusSuffix = baseName + suffix;
                foundResource = looksLikeJarURL ? this.tryResourceFromJarURLWithLoadPath(namePlusSuffix, loadPathEntry) : (looksLikeClasspathURL ? this.findFileInClasspath(loadPathEntry + "/" + namePlusSuffix) : this.tryResourceFromLoadPath(namePlusSuffix, loadPathEntry));
                if (foundResource == null) continue;
                String ss = namePlusSuffix;
                if (ss.startsWith("./")) {
                    ss = ss.substring(2);
                }
                state2.setLoadName(this.resolveLoadName(foundResource, ss));
                break block1;
            }
        }
        return foundResource;
    }

    @Deprecated
    protected LoadServiceResource tryResourceFromJarURLWithLoadPath(String namePlusSuffix, String loadPathEntry) {
        LoadServiceResource foundResource = null;
        String[] urlParts = this.splitJarUrl(loadPathEntry);
        String jarFileName = urlParts[0];
        String entryPath = urlParts[1];
        JarFile current2 = this.getJarFile(jarFileName);
        if (current2 != null) {
            String canonicalEntry = (entryPath.length() > 0 ? entryPath + "/" : "") + namePlusSuffix;
            this.debugLogTry("resourceFromJarURLWithLoadPath", current2.getName() + "!/" + canonicalEntry);
            if (current2.getJarEntry(canonicalEntry) != null) {
                try {
                    URI resourceUri = new URI("jar", "file:" + jarFileName + "!/" + canonicalEntry, null);
                    foundResource = new LoadServiceResource(resourceUri.toURL(), resourceUri.getSchemeSpecificPart());
                    this.debugLogFound(foundResource);
                }
                catch (URISyntaxException e) {
                    throw this.runtime.newIOError(e.getMessage());
                }
                catch (MalformedURLException e) {
                    throw this.runtime.newIOErrorFromException(e);
                }
            }
        }
        return foundResource;
    }

    @Deprecated
    protected LoadServiceResource tryResourceFromLoadPath(String namePlusSuffix, String loadPathEntry) throws RaiseException {
        LoadServiceResource foundResource = null;
        try {
            if (!Ruby.isSecurityRestricted()) {
                String reportedPath = loadPathEntry + "/" + namePlusSuffix;
                boolean absolute = true;
                if (!new File(reportedPath).isAbsolute()) {
                    absolute = false;
                    if (reportedPath.charAt(0) != '.') {
                        reportedPath = "./" + reportedPath;
                    }
                    loadPathEntry = JRubyFile.create(this.runtime.getCurrentDirectory(), loadPathEntry).getAbsolutePath();
                }
                JRubyFile actualPath = JRubyFile.create(loadPathEntry, RubyFile.expandUserPath(this.runtime.getCurrentContext(), namePlusSuffix));
                if (RubyInstanceConfig.DEBUG_LOAD_SERVICE) {
                    this.debugLogTry("resourceFromLoadPath", "'" + actualPath.toString() + "' " + actualPath.isFile() + " " + actualPath.canRead());
                }
                if (actualPath.canRead()) {
                    foundResource = new LoadServiceResource((File)((Object)actualPath), reportedPath, absolute);
                    this.debugLogFound(foundResource);
                }
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        return foundResource;
    }

    @Deprecated
    protected LoadServiceResource tryResourceAsIs(String namePlusSuffix) throws RaiseException {
        return this.tryResourceAsIs(namePlusSuffix, "resourceAsIs");
    }

    @Deprecated
    protected LoadServiceResource tryResourceAsIs(String namePlusSuffix, String debugName) throws RaiseException {
        LoadServiceResource foundResource;
        block9: {
            foundResource = null;
            try {
                Object actualPath;
                if (Ruby.isSecurityRestricted()) break block9;
                String reportedPath = namePlusSuffix;
                if (new File(reportedPath).isAbsolute()) {
                    actualPath = new File(RubyFile.expandUserPath(this.runtime.getCurrentContext(), namePlusSuffix));
                } else {
                    if (reportedPath.charAt(0) == '.' && reportedPath.charAt(1) == '/') {
                        reportedPath = reportedPath.replaceFirst("\\./", this.runtime.getCurrentDirectory());
                    }
                    actualPath = JRubyFile.create(this.runtime.getCurrentDirectory(), RubyFile.expandUserPath(this.runtime.getCurrentContext(), namePlusSuffix));
                }
                this.debugLogTry(debugName, ((File)actualPath).toString());
                if (reportedPath.contains("..")) {
                    try {
                        actualPath = ((File)actualPath).getCanonicalFile();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                if (((File)actualPath).isFile() && ((File)actualPath).canRead()) {
                    foundResource = new LoadServiceResource((File)actualPath, reportedPath);
                    this.debugLogFound(foundResource);
                }
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
        return foundResource;
    }

    @Deprecated
    public void removeInternalLoadedFeature(String name2) {
        this.loadedFeatures.deleteString(this.runtime.getCurrentContext(), name2);
    }

    @Deprecated
    protected void reraiseRaiseExceptions(Throwable e) throws RaiseException {
        if (e instanceof RaiseException) {
            throw (RaiseException)e;
        }
    }

    @Deprecated
    public SearchState findFileForLoad(String file2) {
        SearchState state2 = new SearchState(file2);
        this.findLibraryBySearchState(state2);
        return state2;
    }

    @Deprecated
    protected Library createLibrary(SearchState state2, LoadServiceResource resource2) {
        if (resource2 == null) {
            return null;
        }
        String file2 = resource2.getName();
        String location = state2.loadName;
        if (file2.endsWith(".so") || file2.endsWith(".dll") || file2.endsWith(".bundle")) {
            throw this.runtime.newLoadError("C extensions are not supported, can't load `" + resource2.getName() + "'", resource2.getName());
        }
        if (file2.endsWith(".jar")) {
            return new JarredScript(resource2, state2.searchFile);
        }
        if (file2.endsWith(".class")) {
            return new JavaCompiledScript(resource2);
        }
        return new ExternalScript(resource2, location);
    }

    @Deprecated
    protected Library findLibraryWithClassloaders(SearchState state2, String baseName, SuffixType suffixType) {
        for (String suffix : suffixType.getSuffixes()) {
            String file2 = baseName + suffix;
            LoadServiceResource resource2 = this.findFileInClasspath(file2);
            if (resource2 == null) continue;
            state2.setLoadName(this.resolveLoadName(resource2, file2));
            return this.createLibrary(state2, resource2);
        }
        return null;
    }

    @Deprecated
    protected boolean tryLoadingLibraryOrScript(Ruby runtime2, SearchState state2) {
        return this.tryLoadingLibraryOrScript(runtime2, state2.library, state2.searchFile);
    }

    @Deprecated
    protected boolean isJarfileLibrary(SearchState state2, String file2) {
        return this.isJarfileLibrary(state2.library, file2);
    }

    @Deprecated
    protected Library findLibraryBySearchState(SearchState state2) {
        return this.librarySearcher.findLibrary(state2.searchFile, state2.suffixType);
    }

    @Deprecated
    public void provide(String shortName, String fullName) {
        this.provide(fullName);
    }

    @Deprecated
    protected void addLoadedFeature(String shortName, String name2) {
        RubyString strName = this.runtime.newString(name2);
        this.loadedFeatures.append(strName);
        this.librarySearcher.addFeatureToIndex(strName.toString(), this.runtime.freezeAndDedupString(strName));
    }

    @Deprecated
    public class ScriptClassSearcher
    implements LoadSearcher {
        @Override
        public boolean shouldTrySearch(SearchState state2) {
            return state2.library == null;
        }

        @Override
        public boolean trySearch(SearchState state2) throws RaiseException {
            Script script;
            String className = LoadService.this.buildClassName(state2.searchFile);
            int lastSlashIndex = className.lastIndexOf(47);
            if (lastSlashIndex > -1 && lastSlashIndex < className.length() - 1 && !Character.isJavaIdentifierStart(className.charAt(lastSlashIndex + 1))) {
                className = lastSlashIndex == -1 ? '_' + className : className.substring(0, lastSlashIndex + 1) + '_' + className.substring(lastSlashIndex + 1);
            }
            className = className.replace('/', '.');
            try {
                Class<?> scriptClass = Class.forName(className);
                script = (Script)scriptClass.newInstance();
            }
            catch (Exception cnfe) {
                return true;
            }
            state2.library = new ScriptClassLibrary(script);
            return true;
        }

        public class ScriptClassLibrary
        implements Library {
            private final Script script;

            public ScriptClassLibrary(Script script) {
                this.script = script;
            }

            @Override
            public void load(Ruby runtime2, boolean wrap2) {
                runtime2.loadScript(this.script, wrap2);
            }
        }
    }

    @Deprecated
    public class ExtensionSearcher
    implements LoadSearcher {
        @Override
        public boolean shouldTrySearch(SearchState state2) {
            return (state2.library == null || state2.library instanceof JarredScript) && state2.searchFile.length() > 0;
        }

        @Override
        public boolean trySearch(SearchState state2) {
            LoadService.this.debugLogTry("jarWithExtension", state2.searchFile);
            Library oldLibrary = state2.library;
            state2.library = ClassExtensionLibrary.tryFind(LoadService.this.runtime, state2.searchFile);
            LoadService.this.debugLogFound("jarWithExtension", state2.searchFile);
            if (state2.library == null && oldLibrary != null) {
                state2.library = oldLibrary;
            }
            return true;
        }
    }

    @Deprecated
    public class ClassLoaderSearcher
    implements LoadSearcher {
        @Override
        public boolean shouldTrySearch(SearchState state2) {
            return state2.library == null;
        }

        @Override
        public boolean trySearch(SearchState state2) {
            state2.library = LoadService.this.findLibraryWithClassloaders(state2, state2.searchFile, state2.suffixType);
            return true;
        }
    }

    @Deprecated
    public class NormalSearcher
    implements LoadSearcher {
        @Override
        public boolean shouldTrySearch(SearchState state2) {
            return state2.library == null;
        }

        @Override
        public boolean trySearch(SearchState state2) {
            state2.library = LoadService.this.findLibraryWithoutCWD(state2, state2.searchFile, state2.suffixType);
            return true;
        }
    }

    @Deprecated
    public class SourceBailoutSearcher
    extends BailoutSearcher {
        @Override
        public boolean shouldTrySearch(SearchState state2) {
            return !extensionPattern.matcher(state2.loadName).find();
        }

        @Override
        public boolean trySearch(SearchState state2) {
            return super.trySearch(state2.searchFile, SuffixType.Source);
        }
    }

    @Deprecated
    public class BailoutSearcher
    implements LoadSearcher {
        @Override
        public boolean shouldTrySearch(SearchState state2) {
            return state2.library == null;
        }

        protected boolean trySearch(String file2, SuffixType suffixType) {
            for (String suffix : suffixType.getSuffixes()) {
                String searchName = file2 + suffix;
                if (!LoadService.this.featureAlreadyLoaded(searchName)) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean trySearch(SearchState state2) {
            return this.trySearch(state2.searchFile, state2.suffixType);
        }
    }

    @Deprecated
    public static interface LoadSearcher {
        public boolean shouldTrySearch(SearchState var1);

        public boolean trySearch(SearchState var1);
    }

    @Deprecated
    public static class SearchState {
        public Library library;
        public String loadName;
        public SuffixType suffixType;
        public String searchFile;

        public SearchState(String file2) {
            this.loadName = file2;
        }

        @Deprecated
        public void prepareRequireSearch(String file2) {
            String[] fileHolder = new String[]{file2};
            this.suffixType = LibrarySearcher.getSuffixTypeForRequire(fileHolder);
            this.searchFile = fileHolder[0];
        }

        @Deprecated
        public void prepareLoadSearch(String file2) {
            String[] fileHolder = new String[]{file2};
            this.suffixType = LibrarySearcher.getSuffixTypeForLoad(fileHolder);
            this.searchFile = fileHolder[0];
        }

        public void setLoadName(String loadName) {
            this.loadName = loadName;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.getClass().getName()).append(": ");
            sb.append("library=").append(this.library.toString());
            sb.append(", loadName=").append(this.loadName);
            sb.append(", suffixType=").append(this.suffixType.toString());
            sb.append(", searchFile=").append(this.searchFile);
            return sb.toString();
        }
    }

    private static final class TracingLoadTimer
    extends LoadTimer {
        private final AtomicInteger indent = new AtomicInteger(0);

        private TracingLoadTimer() {
        }

        private StringBuilder getIndentString() {
            int i2 = this.indent.get();
            StringBuilder buf = new StringBuilder(i2 * 2);
            for (int j = 0; j < i2; ++j) {
                buf.append(' ').append(' ');
            }
            return buf;
        }

        @Override
        public long startLoad(String file2) {
            this.indent.incrementAndGet();
            LOG.info("{}-> {}", this.getIndentString(), file2);
            return System.currentTimeMillis();
        }

        @Override
        public void endLoad(String file2, long startTime) {
            LOG.info("{}<- {} - {}ms", this.getIndentString(), file2, System.currentTimeMillis() - startTime);
            this.indent.decrementAndGet();
        }
    }

    private static class LoadTimer {
        private LoadTimer() {
        }

        public long startLoad(String file2) {
            return 0L;
        }

        public void endLoad(String file2, long startTime) {
        }
    }

    final class RequireLocks {
        final ConcurrentHashMap<String, RequireLock> pool = new ConcurrentHashMap(8, 0.75f, 2);

        private RequireLocks() {
        }

        private RequireState lock(String path2, boolean circularRequireWarning, RequireState defaultResult, Function<String, RequireState> ifLocked) {
            RequireLock newLock;
            ThreadContext currentContext = LoadService.this.runtime.getCurrentContext();
            RubyThread thread2 = currentContext.getThread();
            RequireLock lock2 = this.pool.get(path2);
            if (lock2 == null && (lock2 = this.pool.computeIfAbsent(path2, arg_0 -> RequireLocks.lambda$lock$0(thread2, newLock = new RequireLock(), arg_0))) == newLock) {
                return this.executeAndClearLock(path2, ifLocked, thread2, lock2);
            }
            if (lock2.isHeldByCurrentThread()) {
                if (circularRequireWarning && LoadService.this.runtime.isVerbose()) {
                    LoadService.this.warnCircularRequire(path2);
                }
                return null;
            }
            while (true) {
                try {
                    thread2.lockInterruptibly(lock2);
                }
                catch (InterruptedException ie) {
                    currentContext.pollThreadEvents();
                    continue;
                }
                break;
            }
            if (lock2.destroyed) {
                thread2.unlock(lock2);
                return defaultResult;
            }
            return this.executeAndClearLock(path2, ifLocked, thread2, lock2);
        }

        private RequireState executeAndClearLock(String path2, Function<String, RequireState> ifLocked, RubyThread thread2, RequireLock lock2) {
            boolean destroyLock = false;
            try {
                RequireState state2 = ifLocked.apply(path2);
                destroyLock = true;
                RequireState requireState = state2;
                return requireState;
            }
            catch (LoadError le) {
                destroyLock = true;
                throw le;
            }
            catch (StandardError se) {
                destroyLock = false;
                throw se;
            }
            finally {
                if (destroyLock) {
                    lock2.destroyed = true;
                    this.pool.remove(path2);
                }
                thread2.unlock(lock2);
            }
        }

        private static /* synthetic */ RequireLock lambda$lock$0(RubyThread thread2, RequireLock newLock, String name2) {
            thread2.lock(newLock);
            return newLock;
        }

        final class RequireLock
        extends ReentrantLock {
            volatile boolean destroyed;

            RequireLock() {
            }
        }
    }

    static enum LockResult {
        LOCKED,
        CIRCULAR;

    }

    private static enum RequireState {
        LOADED,
        ALREADY_LOADED,
        CIRCULAR;

    }

    public static enum SuffixType {
        Source(LibrarySearcher.Suffix.SOURCES),
        Extension(LibrarySearcher.Suffix.EXTENSIONS),
        Both(LibrarySearcher.Suffix.ALL),
        Neither(EnumSet.noneOf(LibrarySearcher.Suffix.class));

        public final EnumSet<LibrarySearcher.Suffix> suffixes;
        @Deprecated
        public static final String[] sourceSuffixes;
        @Deprecated
        public static final String[] extensionSuffixes;

        private SuffixType(EnumSet suffixes) {
            this.suffixes = suffixes;
        }

        public EnumSet<LibrarySearcher.Suffix> getSuffixSet() {
            return this.suffixes;
        }

        @Deprecated
        public String[] getSuffixes() {
            return (String[])this.suffixes.stream().map(suffix -> suffix.name()).toArray(String[]::new);
        }

        static {
            sourceSuffixes = (String[])LibrarySearcher.Suffix.SOURCES.stream().map(suffix -> suffix.name()).toArray(String[]::new);
            extensionSuffixes = (String[])LibrarySearcher.Suffix.EXTENSIONS.stream().map(suffix -> suffix.name()).toArray(String[]::new);
        }
    }
}

