/*
 * Decompiled with CFR 0.152.
 */
package jodd.util;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jodd.io.StreamGobbler;
import jodd.util.ProcessRunner;
import jodd.util.StringPool;
import jodd.util.StringUtil;

public class CommandLine {
    public static final int OK = 0;
    protected final List<String> cmdLine = new ArrayList<String>();
    protected Map<String, String> env = null;
    protected boolean cleanEnvironment = false;
    protected File workingDirectory;
    protected String outPrefix = "out> ";
    protected String errPrefix = "err> ";
    protected OutputStream out = System.out;
    protected OutputStream err = System.err;

    protected CommandLine(String command) {
        this.cmdLine.add(command);
    }

    public static CommandLine cmd(String command) {
        return new CommandLine(command);
    }

    public CommandLine workingDirectory(File workDirectory) {
        this.workingDirectory = workDirectory;
        return this;
    }

    public CommandLine workingDirectory(String workDirectory) {
        this.workingDirectory = new File(workDirectory);
        return this;
    }

    public CommandLine arg(String argument) {
        this.cmdLine.add(argument);
        return this;
    }

    public CommandLine args(String ... arguments) {
        if (arguments != null && arguments.length > 0) {
            Collections.addAll(this.cmdLine, arguments);
        }
        return this;
    }

    public CommandLine outPrefix(String prefix) {
        this.outPrefix = prefix;
        return this;
    }

    public CommandLine errPrefix(String prefix) {
        this.errPrefix = prefix;
        return this;
    }

    public CommandLine out(OutputStream out) {
        this.out = out;
        return this;
    }

    public CommandLine err(OutputStream err) {
        this.err = err;
        return this;
    }

    public CommandLine env(String key, String value) {
        if (this.env == null) {
            this.env = new HashMap<String, String>();
        }
        this.env.put(key, value);
        return this;
    }

    public CommandLine newEnv(boolean clean) {
        this.cleanEnvironment = clean;
        return this;
    }

    public ProcessRunner.ProcessResult run() {
        int result;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        this.out = this.err = baos;
        try {
            baos.write(StringUtil.join(this.cmdLine, ' ').getBytes());
            baos.write(StringPool.BYTES_NEW_LINE);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        ProcessBuilder processBuilder = new ProcessBuilder(new String[0]);
        processBuilder.command(this.cmdLine);
        if (this.cleanEnvironment) {
            processBuilder.environment().clear();
        }
        if (this.env != null) {
            processBuilder.environment().putAll(this.env);
        }
        processBuilder.directory(this.workingDirectory);
        Process process = null;
        try {
            process = processBuilder.start();
        }
        catch (IOException ioex) {
            return this.writeException(baos, ioex);
        }
        StreamGobbler outputGobbler = new StreamGobbler(process.getInputStream(), this.out, this.outPrefix);
        StreamGobbler errorGobbler = new StreamGobbler(process.getErrorStream(), this.err, this.errPrefix);
        outputGobbler.start();
        errorGobbler.start();
        try {
            result = process.waitFor();
        }
        catch (InterruptedException iex) {
            return this.writeException(baos, iex);
        }
        outputGobbler.waitFor();
        errorGobbler.waitFor();
        return new ProcessRunner.ProcessResult(result, baos.toString());
    }

    private ProcessRunner.ProcessResult writeException(ByteArrayOutputStream baos, Exception ex) {
        try {
            baos.write(this.errPrefix.getBytes());
        }
        catch (IOException iOException) {
            // empty catch block
        }
        ex.printStackTrace(new PrintStream(baos));
        return new ProcessRunner.ProcessResult(-1, baos.toString());
    }
}

