/*
 * Decompiled with CFR 0.152.
 */
package org.jodconverter.core.job;

import java.io.File;
import java.util.Optional;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.jodconverter.core.document.DocumentFormat;
import org.jodconverter.core.job.DocumentSpecs;
import org.jodconverter.core.util.AssertUtils;

public abstract class AbstractDocumentSpecs
implements DocumentSpecs {
    private File file;
    private DocumentFormat documentFormat;

    protected AbstractDocumentSpecs() {
    }

    protected AbstractDocumentSpecs(@NonNull File file) {
        AssertUtils.notNull(file, "file must not be null");
        this.file = file;
    }

    @Override
    public @NonNull File getFile() {
        return this.file;
    }

    @Override
    public @Nullable DocumentFormat getFormat() {
        return this.documentFormat;
    }

    void setDocumentFormat(DocumentFormat documentFormat) {
        AssertUtils.notNull(documentFormat, "documentFormat must not be null");
        this.documentFormat = documentFormat;
    }

    public @NonNull String toString() {
        return this.getClass().getSimpleName() + "{file=" + Optional.ofNullable(this.file).map(File::getName).orElse("null") + ", format=" + Optional.ofNullable(this.documentFormat).map(DocumentFormat::getExtension).orElse("null") + '}';
    }
}

