/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.org.eclipse.aether.internal.impl.filter;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jetbrains.kotlin.org.eclipse.aether.RepositorySystemSession;
import org.jetbrains.kotlin.org.eclipse.aether.artifact.Artifact;
import org.jetbrains.kotlin.org.eclipse.aether.impl.RemoteRepositoryFilterManager;
import org.jetbrains.kotlin.org.eclipse.aether.internal.impl.filter.DefaultRemoteRepositoryFilterManager$$Lambda$0;
import org.jetbrains.kotlin.org.eclipse.aether.internal.impl.filter.DefaultRemoteRepositoryFilterManager$Consensus$$Lambda$0;
import org.jetbrains.kotlin.org.eclipse.aether.internal.impl.filter.DefaultRemoteRepositoryFilterManager$Consensus$$Lambda$1;
import org.jetbrains.kotlin.org.eclipse.aether.internal.impl.filter.DefaultRemoteRepositoryFilterManager$Consensus$$Lambda$2;
import org.jetbrains.kotlin.org.eclipse.aether.internal.impl.filter.DefaultRemoteRepositoryFilterManager$Participants$$Lambda$0;
import org.jetbrains.kotlin.org.eclipse.aether.internal.impl.filter.DefaultRemoteRepositoryFilterManager$Participants$$Lambda$1;
import org.jetbrains.kotlin.org.eclipse.aether.internal.impl.filter.DefaultRemoteRepositoryFilterManager$Participants$$Lambda$2;
import org.jetbrains.kotlin.org.eclipse.aether.metadata.Metadata;
import org.jetbrains.kotlin.org.eclipse.aether.repository.RemoteRepository;
import org.jetbrains.kotlin.org.eclipse.aether.spi.connector.filter.RemoteRepositoryFilter;
import org.jetbrains.kotlin.org.eclipse.aether.spi.connector.filter.RemoteRepositoryFilterSource;

@Singleton
@Named
public final class DefaultRemoteRepositoryFilterManager
implements RemoteRepositoryFilterManager {
    private static final String INSTANCE_KEY = DefaultRemoteRepositoryFilterManager.class.getName() + ".instance";
    private final Map<String, RemoteRepositoryFilterSource> sources = new HashMap<String, RemoteRepositoryFilterSource>();

    @Deprecated
    public DefaultRemoteRepositoryFilterManager() {
    }

    @Override
    public RemoteRepositoryFilter getRemoteRepositoryFilter(RepositorySystemSession session) {
        RepositorySystemSession repositorySystemSession = session;
        DefaultRemoteRepositoryFilterManager defaultRemoteRepositoryFilterManager = this;
        return (RemoteRepositoryFilter)session.getData().computeIfAbsent(INSTANCE_KEY, new DefaultRemoteRepositoryFilterManager$$Lambda$0(defaultRemoteRepositoryFilterManager, repositorySystemSession));
    }

    private /* synthetic */ Object lambda$getRemoteRepositoryFilter$0(RepositorySystemSession session) {
        HashMap<String, RemoteRepositoryFilter> filters = new HashMap<String, RemoteRepositoryFilter>();
        for (Map.Entry<String, RemoteRepositoryFilterSource> entry : this.sources.entrySet()) {
            RemoteRepositoryFilter filter = entry.getValue().getRemoteRepositoryFilter(session);
            if (filter == null) continue;
            filters.put(entry.getKey(), filter);
        }
        if (!filters.isEmpty()) {
            return new Participants(filters);
        }
        return null;
    }

    static /* synthetic */ Object accessor$DefaultRemoteRepositoryFilterManager$lambda0(DefaultRemoteRepositoryFilterManager defaultRemoteRepositoryFilterManager, RepositorySystemSession repositorySystemSession) {
        return defaultRemoteRepositoryFilterManager.lambda$getRemoteRepositoryFilter$0(repositorySystemSession);
    }

    private static class Participants
    implements RemoteRepositoryFilter {
        private final Map<String, RemoteRepositoryFilter> participants;

        private Participants(Map<String, RemoteRepositoryFilter> participants) {
            this.participants = Collections.unmodifiableMap(participants);
        }

        @Override
        public RemoteRepositoryFilter.Result acceptArtifact(RemoteRepository remoteRepository, Artifact artifact) {
            Artifact artifact2 = artifact;
            RemoteRepository remoteRepository2 = remoteRepository;
            return new Consensus(this.participants.entrySet().stream().collect(Collectors.toMap(DefaultRemoteRepositoryFilterManager$Participants$$Lambda$0.INSTANCE, new DefaultRemoteRepositoryFilterManager$Participants$$Lambda$1(remoteRepository2, artifact2))));
        }

        @Override
        public RemoteRepositoryFilter.Result acceptMetadata(RemoteRepository remoteRepository, Metadata metadata) {
            Metadata metadata2 = metadata;
            RemoteRepository remoteRepository2 = remoteRepository;
            return new Consensus(this.participants.entrySet().stream().collect(Collectors.toMap(DefaultRemoteRepositoryFilterManager$Participants$$Lambda$0.INSTANCE, new DefaultRemoteRepositoryFilterManager$Participants$$Lambda$2(remoteRepository2, metadata2))));
        }

        private static /* synthetic */ RemoteRepositoryFilter.Result lambda$acceptMetadata$1(RemoteRepository remoteRepository, Metadata metadata, Map.Entry e) {
            return ((RemoteRepositoryFilter)e.getValue()).acceptMetadata(remoteRepository, metadata);
        }

        private static /* synthetic */ RemoteRepositoryFilter.Result lambda$acceptArtifact$0(RemoteRepository remoteRepository, Artifact artifact, Map.Entry e) {
            return ((RemoteRepositoryFilter)e.getValue()).acceptArtifact(remoteRepository, artifact);
        }

        static /* synthetic */ RemoteRepositoryFilter.Result accessor$DefaultRemoteRepositoryFilterManager$Participants$lambda1(RemoteRepository remoteRepository, Artifact artifact, Map.Entry entry) {
            return Participants.lambda$acceptArtifact$0(remoteRepository, artifact, entry);
        }

        static /* synthetic */ RemoteRepositoryFilter.Result accessor$DefaultRemoteRepositoryFilterManager$Participants$lambda2(RemoteRepository remoteRepository, Metadata metadata, Map.Entry entry) {
            return Participants.lambda$acceptMetadata$1(remoteRepository, metadata, entry);
        }
    }

    private static class Consensus
    implements RemoteRepositoryFilter.Result {
        private final boolean accepted;
        private final String reasoning;

        Consensus(Map<String, RemoteRepositoryFilter.Result> results) {
            this.accepted = results.values().stream().allMatch(DefaultRemoteRepositoryFilterManager$Consensus$$Lambda$0.INSTANCE);
            this.reasoning = results.values().stream().filter(DefaultRemoteRepositoryFilterManager$Consensus$$Lambda$1.INSTANCE).map(DefaultRemoteRepositoryFilterManager$Consensus$$Lambda$2.INSTANCE).collect(Collectors.joining("; "));
        }

        @Override
        public boolean isAccepted() {
            return this.accepted;
        }

        @Override
        public String reasoning() {
            return this.reasoning;
        }

        private static /* synthetic */ boolean lambda$new$0(RemoteRepositoryFilter.Result r) {
            return !r.isAccepted();
        }

        static /* synthetic */ boolean accessor$DefaultRemoteRepositoryFilterManager$Consensus$lambda1(RemoteRepositoryFilter.Result result) {
            return Consensus.lambda$new$0(result);
        }
    }
}

