/*
 * Decompiled with CFR 0.152.
 */
package org.jeecgframework.poi.excel.export;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Drawing;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;
import org.jeecgframework.poi.excel.annotation.ExcelTarget;
import org.jeecgframework.poi.excel.entity.ExportParams;
import org.jeecgframework.poi.excel.entity.enmus.ExcelType;
import org.jeecgframework.poi.excel.entity.params.ExcelExportEntity;
import org.jeecgframework.poi.excel.export.base.ExcelExportBase;
import org.jeecgframework.poi.excel.export.styler.IExcelExportStyler;
import org.jeecgframework.poi.exception.excel.ExcelExportException;
import org.jeecgframework.poi.exception.excel.enums.ExcelExportEnum;
import org.jeecgframework.poi.util.PoiExcelGraphDataUtil;
import org.jeecgframework.poi.util.PoiPublicUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExcelExportServer
extends ExcelExportBase {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExcelExportServer.class);
    private int MAX_NUM = 60000;

    protected int createHeaderAndTitle(ExportParams entity, Sheet sheet, Workbook workbook, List<ExcelExportEntity> excelParams) {
        int rows = 0;
        int feildWidth = this.getFieldWidth(excelParams);
        if (entity.getTitle() != null) {
            rows += this.createHeaderRow(entity, sheet, workbook, feildWidth);
        }
        rows += this.createTitleRow(entity, sheet, workbook, rows, excelParams);
        if (entity.isFixedTitle()) {
            sheet.createFreezePane(0, rows, 0, rows);
        }
        return rows;
    }

    public int createHeaderRow(ExportParams entity, Sheet sheet, Workbook workbook, int feildWidth) {
        Row row = sheet.createRow(0);
        row.setHeight(entity.getTitleHeight());
        this.createStringCell(row, 0, entity.getTitle(), this.getExcelExportStyler().getHeaderStyle(entity.getHeaderColor()), null);
        for (int i = 1; i <= feildWidth; ++i) {
            this.createStringCell(row, i, "", this.getExcelExportStyler().getHeaderStyle(entity.getHeaderColor()), null);
        }
        try {
            sheet.addMergedRegion(new CellRangeAddress(0, 0, 0, feildWidth));
        }
        catch (IllegalArgumentException e) {
            LOGGER.error("\u5408\u5e76\u5355\u5143\u683c\u9519\u8bef\u65e5\u5fd7\uff1a" + e.getMessage());
            e.fillInStackTrace();
        }
        if (entity.getSecondTitle() != null) {
            row = sheet.createRow(1);
            row.setHeight(entity.getSecondTitleHeight());
            CellStyle style = workbook.createCellStyle();
            style.setAlignment(HorizontalAlignment.RIGHT);
            this.createStringCell(row, 0, entity.getSecondTitle(), style, null);
            for (int i = 1; i <= feildWidth; ++i) {
                this.createStringCell(row, i, "", this.getExcelExportStyler().getHeaderStyle(entity.getHeaderColor()), null);
            }
            try {
                sheet.addMergedRegion(new CellRangeAddress(1, 1, 0, feildWidth));
            }
            catch (IllegalArgumentException e) {
                LOGGER.error("\u5408\u5e76\u5355\u5143\u683c\u9519\u8bef\u65e5\u5fd7\uff1a" + e.getMessage());
                e.fillInStackTrace();
            }
            return 2;
        }
        return 1;
    }

    public void createSheet(Workbook workbook, ExportParams entity, Class<?> pojoClass, Collection<?> dataSet, String[] exportFields) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Excel export start ,class is {}", pojoClass);
            LOGGER.debug("Excel version is {}", (Object)(entity.getType().equals((Object)ExcelType.HSSF) ? "03" : "07"));
        }
        if (workbook == null || entity == null || pojoClass == null || dataSet == null) {
            throw new ExcelExportException(ExcelExportEnum.PARAMETER_ERROR);
        }
        this.type = entity.getType();
        if (this.type.equals((Object)ExcelType.XSSF)) {
            this.MAX_NUM = 1000000;
        }
        Sheet sheet = null;
        try {
            sheet = workbook.createSheet(entity.getSheetName());
        }
        catch (Exception e) {
            sheet = workbook.createSheet();
        }
        try {
            int index;
            ExcelTarget etarget;
            this.dataHanlder = entity.getDataHanlder();
            if (this.dataHanlder != null) {
                this.needHanlderList = Arrays.asList(this.dataHanlder.getNeedHandlerFields());
            }
            this.setExcelExportStyler((IExcelExportStyler)entity.getStyle().getConstructor(Workbook.class).newInstance(workbook));
            Drawing patriarch = sheet.createDrawingPatriarch();
            ArrayList<ExcelExportEntity> excelParams = new ArrayList<ExcelExportEntity>();
            if (entity.isAddIndex()) {
                excelParams.add(this.indexExcelEntity(entity));
            }
            Object fileds = PoiPublicUtil.getClassFields(pojoClass);
            if (exportFields != null) {
                ArrayList<Field> list = new ArrayList<Field>(Arrays.asList(fileds));
                for (int i = 0; i < list.size(); ++i) {
                    if (Arrays.asList(exportFields).contains(((Field)list.get(i)).getName())) continue;
                    list.remove(i);
                    --i;
                }
                fileds = list != null && list.size() > 0 ? list.toArray(new Field[0]) : null;
            }
            String targetId = (etarget = pojoClass.getAnnotation(ExcelTarget.class)) == null ? null : etarget.value();
            this.getAllExcelField(entity.getExclusions(), targetId, (Field[])fileds, (List<ExcelExportEntity>)excelParams, pojoClass, null);
            this.reConfigExcelExportParams(excelParams, entity);
            int titleHeight = index = entity.isCreateHeadRows() ? this.createHeaderAndTitle(entity, sheet, workbook, excelParams) : 0;
            this.setCellWith(excelParams, sheet);
            this.setColumnHidden(excelParams, sheet);
            short rowHeight = this.getRowHeight(excelParams);
            this.setCurrentIndex(1);
            Iterator<?> its = dataSet.iterator();
            ArrayList tempList = new ArrayList();
            while (its.hasNext()) {
                Object t = its.next();
                index += this.createCells(patriarch, index, t, excelParams, sheet, workbook, rowHeight);
                tempList.add(t);
                if (index < this.MAX_NUM) continue;
                break;
            }
            this.mergeCells(sheet, excelParams, titleHeight);
            if (entity.getFreezeCol() != 0) {
                sheet.createFreezePane(entity.getFreezeCol(), 0, entity.getFreezeCol(), 0);
            }
            its = dataSet.iterator();
            int le = tempList.size();
            for (int i = 0; i < le; ++i) {
                its.next();
                its.remove();
            }
            this.addStatisticsRow(this.getExcelExportStyler().getStyles(true, null), sheet);
            if (dataSet.size() > 0) {
                this.createSheet(workbook, entity, pojoClass, dataSet, exportFields);
            }
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            throw new ExcelExportException(ExcelExportEnum.EXPORT_ERROR, e.getCause());
        }
    }

    public void createSheetForMap(Workbook workbook, ExportParams entity, List<ExcelExportEntity> entityList, Collection<? extends Map<?, ?>> dataSet) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Excel version is {}", (Object)(entity.getType().equals((Object)ExcelType.HSSF) ? "03" : "07"));
        }
        if (workbook == null || entity == null || entityList == null || dataSet == null) {
            throw new ExcelExportException(ExcelExportEnum.PARAMETER_ERROR);
        }
        this.type = entity.getType();
        if (this.type.equals((Object)ExcelType.XSSF)) {
            this.MAX_NUM = 1000000;
        }
        Sheet sheet = null;
        try {
            sheet = workbook.createSheet(entity.getSheetName());
        }
        catch (Exception e) {
            sheet = workbook.createSheet();
        }
        try {
            int index;
            this.dataHanlder = entity.getDataHanlder();
            if (this.dataHanlder != null) {
                this.needHanlderList = Arrays.asList(this.dataHanlder.getNeedHandlerFields());
            }
            this.setExcelExportStyler((IExcelExportStyler)entity.getStyle().getConstructor(Workbook.class).newInstance(workbook));
            Drawing patriarch = sheet.createDrawingPatriarch();
            ArrayList<ExcelExportEntity> excelParams = new ArrayList<ExcelExportEntity>();
            if (entity.isAddIndex()) {
                excelParams.add(this.indexExcelEntity(entity));
            }
            excelParams.addAll(entityList);
            this.sortAllParams(excelParams);
            int titleHeight = index = entity.isCreateHeadRows() ? this.createHeaderAndTitle(entity, sheet, workbook, excelParams) : 0;
            this.setCellWith(excelParams, sheet);
            this.setColumnHidden(excelParams, sheet);
            short rowHeight = this.getRowHeight(excelParams);
            this.setCurrentIndex(1);
            Iterator<Map<?, ?>> its = dataSet.iterator();
            ArrayList tempList = new ArrayList();
            while (its.hasNext()) {
                Map<?, ?> t = its.next();
                index += this.createCells(patriarch, index, t, excelParams, sheet, workbook, rowHeight);
                tempList.add(t);
                if (index < this.MAX_NUM) continue;
                break;
            }
            if (entity.getFreezeCol() != 0) {
                sheet.createFreezePane(entity.getFreezeCol(), 0, entity.getFreezeCol(), 0);
            }
            this.mergeCells(sheet, excelParams, titleHeight);
            its = dataSet.iterator();
            int le = tempList.size();
            for (int i = 0; i < le; ++i) {
                its.next();
                its.remove();
            }
            if (dataSet.size() > 0) {
                this.createSheetForMap(workbook, entity, entityList, dataSet);
            }
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            throw new ExcelExportException(ExcelExportEnum.EXPORT_ERROR, e.getCause());
        }
    }

    private int createTitleRow(ExportParams title, Sheet sheet, Workbook workbook, int index, List<ExcelExportEntity> excelParams) {
        Row row = sheet.createRow(index);
        int rows = this.getRowNums(excelParams);
        row.setHeight((short)450);
        Row listRow = null;
        if (rows == 2) {
            listRow = sheet.createRow(index + 1);
            listRow.setHeight((short)450);
        }
        int cellIndex = 0;
        CellStyle titleStyle = this.getExcelExportStyler().getTitleStyle(title.getColor());
        int exportFieldTitleSize = excelParams.size();
        for (int i = 0; i < exportFieldTitleSize; ++i) {
            ExcelExportEntity entity = excelParams.get(i);
            if (entity.isColspan()) {
                List<String> subList = entity.getSubColumnList();
                if (subList == null || subList.size() == 0) continue;
                entity.initSubExportEntity(excelParams);
            }
            if (StringUtils.isNotBlank((CharSequence)entity.getName())) {
                this.createStringCell(row, cellIndex, entity.getName(), titleStyle, entity);
            }
            if (entity.getList() != null) {
                List<ExcelExportEntity> sTitel = entity.getList();
                if (StringUtils.isNotBlank((CharSequence)entity.getName())) {
                    try {
                        sheet.addMergedRegion(new CellRangeAddress(index, index, cellIndex, cellIndex + sTitel.size() - 1));
                    }
                    catch (IllegalArgumentException e) {
                        LOGGER.error("\u5408\u5e76\u5355\u5143\u683c\u9519\u8bef\u65e5\u5fd7\uff1a" + e.getMessage());
                        e.fillInStackTrace();
                    }
                }
                int size = sTitel.size();
                for (int j = 0; j < size; ++j) {
                    this.createStringCell(rows == 2 ? listRow : row, cellIndex, sTitel.get(j).getName(), titleStyle, entity);
                    ++cellIndex;
                }
                --cellIndex;
            } else if (rows == 2) {
                this.createStringCell(listRow, cellIndex, "", titleStyle, entity);
                try {
                    sheet.addMergedRegion(new CellRangeAddress(index, index + 1, cellIndex, cellIndex));
                }
                catch (IllegalArgumentException e) {
                    LOGGER.error("\u5408\u5e76\u5355\u5143\u683c\u9519\u8bef\u65e5\u5fd7\uff1a" + e.getMessage());
                    e.fillInStackTrace();
                }
            }
            ++cellIndex;
        }
        return rows;
    }

    private int getRowNums(List<ExcelExportEntity> excelParams) {
        for (int i = 0; i < excelParams.size(); ++i) {
            ExcelExportEntity temp = excelParams.get(i);
            if (temp.getList() == null && !temp.isColspan() || !StringUtils.isNotBlank((CharSequence)temp.getName())) continue;
            return 2;
        }
        return 1;
    }

    protected ExcelExportEntity indexExcelEntity(ExportParams entity) {
        ExcelExportEntity exportEntity = new ExcelExportEntity();
        exportEntity.setOrderNum(0);
        exportEntity.setName(entity.getIndexName());
        exportEntity.setWidth(10.0);
        exportEntity.setFormat("isAddIndex");
        return exportEntity;
    }

    protected void insertDataToSheet(Workbook workbook, ExportParams entity, List<ExcelExportEntity> entityList, Collection<? extends Map<?, ?>> dataSet, Sheet sheet) {
        try {
            int index;
            this.dataHanlder = entity.getDataHanlder();
            if (this.dataHanlder != null && this.dataHanlder.getNeedHandlerFields() != null) {
                this.needHanlderList = Arrays.asList(this.dataHanlder.getNeedHandlerFields());
            }
            this.setExcelExportStyler((IExcelExportStyler)entity.getStyle().getConstructor(Workbook.class).newInstance(workbook));
            Drawing patriarch = PoiExcelGraphDataUtil.getDrawingPatriarch(sheet);
            ArrayList<ExcelExportEntity> excelParams = new ArrayList<ExcelExportEntity>();
            if (entity.isAddIndex()) {
                excelParams.add(this.indexExcelEntity(entity));
            }
            excelParams.addAll(entityList);
            this.sortAllParams(excelParams);
            int titleHeight = index = entity.isCreateHeadRows() ? this.createHeaderAndTitle(entity, sheet, workbook, excelParams) : 0;
            this.setCellWith(excelParams, sheet);
            this.setColumnHidden(excelParams, sheet);
            short rowHeight = entity.getHeight() != 0 ? entity.getHeight() : this.getRowHeight(excelParams);
            this.setCurrentIndex(1);
            Iterator<Map<?, ?>> its = dataSet.iterator();
            ArrayList tempList = new ArrayList();
            while (its.hasNext()) {
                Map<?, ?> t = its.next();
                index += this.createCells(patriarch, index, t, excelParams, sheet, workbook, rowHeight, 0)[0];
                tempList.add(t);
                if (index < this.MAX_NUM) continue;
                break;
            }
            if (entity.getFreezeCol() != 0) {
                sheet.createFreezePane(entity.getFreezeCol(), 0, entity.getFreezeCol(), 0);
            }
            this.mergeCells(sheet, excelParams, titleHeight);
            its = dataSet.iterator();
            int le = tempList.size();
            for (int i = 0; i < le; ++i) {
                its.next();
                its.remove();
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("List data more than max ,data size is {}", (Object)dataSet.size());
            }
            if (dataSet.size() > 0) {
                this.createSheetForMap(workbook, entity, entityList, dataSet);
            } else {
                this.addStatisticsRow(this.getExcelExportStyler().getStyles(true, null), sheet);
            }
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            throw new ExcelExportException(ExcelExportEnum.EXPORT_ERROR, e.getCause());
        }
    }
}

