/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.xml;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.jboss.weld.bootstrap.spi.BeanDiscoveryMode;
import org.jboss.weld.bootstrap.spi.BeansXml;
import org.jboss.weld.bootstrap.spi.ClassAvailableActivation;
import org.jboss.weld.bootstrap.spi.Filter;
import org.jboss.weld.bootstrap.spi.Metadata;
import org.jboss.weld.bootstrap.spi.SystemPropertyActivation;
import org.jboss.weld.logging.XmlLogger;
import org.jboss.weld.metadata.BeansXmlImpl;
import org.jboss.weld.metadata.ClassAvailableActivationImpl;
import org.jboss.weld.metadata.FilterImpl;
import org.jboss.weld.metadata.ScanningImpl;
import org.jboss.weld.metadata.SystemPropertyActivationImpl;
import org.jboss.weld.metadata.WeldFilterImpl;
import org.jboss.weld.util.collections.ImmutableSet;
import org.jboss.weld.xml.XmlMetadata;

public class BeansXmlStreamParser {
    public static final String JAVAEE_LEGACY_URI = "http://java.sun.com/xml/ns/javaee";
    public static final String JAVAEE_URI = "http://xmlns.jcp.org/xml/ns/javaee";
    public static final Set<String> JAVAEE_URIS = ImmutableSet.of(new String[]{"http://java.sun.com/xml/ns/javaee", "http://xmlns.jcp.org/xml/ns/javaee"});
    public static final String WELD_URI = "http://jboss.org/schema/weld/beans";
    public static final Set<String> SCANNING_URIS = ImmutableSet.of(new String[]{"http://jboss.org/schema/weld/beans", "http://xmlns.jcp.org/xml/ns/javaee", "http://java.sun.com/xml/ns/javaee"});
    private static final String VERSION_ATTRIBUTE_NAME = "version";
    private static final String BEAN_DISCOVERY_MODE_ATTRIBUTE_NAME = "bean-discovery-mode";
    private static final String NAME_ATTRIBUTE_NAME = "name";
    private static final String VALUE_ATTRIBUTE_NAME = "value";
    private static final String PATTERN_ATTRIBUTE_NAME = "pattern";
    private static final String IF_CLASS_AVAILABLE = "if-class-available";
    private static final String IF_CLASS_NOT_AVAILABLE = "if-class-not-available";
    private static final String IF_SYSTEM_PROPERTY = "if-system-property";
    private static final String CLASS = "class";
    private static final String STEREOTYPE = "stereotype";
    private static final String INCLUDE = "include";
    private static final String EXCLUDE = "exclude";
    private static final String TRIM = "trim";
    private static final String BEANS = "beans";
    private static final String ALTERNATIVES = "alternatives";
    private static final String INTERCEPTORS = "interceptors";
    private static final String DECORATORS = "decorators";
    private static final String SCAN = "scan";
    private List<Metadata<String>> enabledInterceptors = null;
    private List<Metadata<String>> enabledDecorators = null;
    private List<Metadata<String>> selectedAlternatives = null;
    private List<Metadata<String>> selectedAlternativeStereotypes = null;
    private List<Metadata<Filter>> includes = null;
    private List<Metadata<Filter>> excludes = null;
    private BeanDiscoveryMode discoveryMode = BeanDiscoveryMode.ALL;
    private String version;
    private boolean isTrimmed;
    private final URL beansXml;
    private final Function<String, String> interpolator;

    public BeansXmlStreamParser(URL beansXml) {
        this(beansXml, Function.identity());
    }

    public BeansXmlStreamParser(URL beansXml, Function<String, String> interpolator) {
        this.beansXml = beansXml;
        this.interpolator = interpolator;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @SuppressFBWarnings(value={"RCN_REDUNDANT_NULLCHECK_WOULD_HAVE_BEEN_A_NPE"}, justification="False positive, see https://github.com/spotbugs/spotbugs/issues/259")
    public BeansXml parse() {
        if (this.beansXml == null) {
            throw XmlLogger.LOG.loadError("unknown", null);
        }
        try (InputStream in = this.beansXml.openStream();){
            if (in.available() == 0) {
                BeansXml beansXml = BeansXml.EMPTY_BEANS_XML;
                return beansXml;
            }
            XMLInputFactory factory = XMLInputFactory.newInstance();
            XMLEventReader reader = factory.createXMLEventReader(in);
            StartElement element = this.nextStartElement(reader, BEANS, JAVAEE_URIS);
            if (element != null) {
                XMLEvent event;
                this.parseBeans(element);
                while (reader.hasNext() && !this.isEnd(event = reader.nextEvent(), BEANS)) {
                    if (this.isStartElement(event, ALTERNATIVES)) {
                        this.parseAlternatives(reader, event);
                        continue;
                    }
                    if (this.isStartElement(event, INTERCEPTORS)) {
                        this.parseInterceptors(reader, event);
                        continue;
                    }
                    if (this.isStartElement(event, DECORATORS)) {
                        this.parseDecorators(reader, event);
                        continue;
                    }
                    if (this.isStartElement(event, SCAN, SCANNING_URIS)) {
                        this.parseScan(reader, event);
                        continue;
                    }
                    if (!this.isStartElement(event, TRIM)) continue;
                    this.isTrimmed = true;
                }
            }
            reader.close();
            return new BeansXmlImpl(this.orEmpty(this.selectedAlternatives), this.orEmpty(this.selectedAlternativeStereotypes), this.orEmpty(this.enabledDecorators), this.orEmpty(this.enabledInterceptors), new ScanningImpl(this.orEmpty(this.includes), this.orEmpty(this.excludes)), this.beansXml, this.discoveryMode, this.version, this.isTrimmed);
        }
        catch (IOException e) {
            throw XmlLogger.LOG.loadError(this.beansXml, e);
        }
        catch (XMLStreamException e) {
            throw XmlLogger.LOG.parsingError(this.beansXml, e);
        }
    }

    private StartElement nextStartElement(XMLEventReader reader, String localName, Set<String> namespaces) throws XMLStreamException {
        StartElement startElement = this.nextStartElement(reader);
        if (startElement != null && localName.equals(startElement.getName().getLocalPart()) && this.isInNamespace(startElement.getName(), namespaces)) {
            return startElement;
        }
        return null;
    }

    private StartElement nextStartElement(XMLEventReader reader) throws XMLStreamException {
        while (reader.hasNext()) {
            XMLEvent event = reader.nextEvent();
            if (!event.isStartElement()) continue;
            return event.asStartElement();
        }
        return null;
    }

    private void parseBeans(StartElement element) {
        Iterator<Attribute> attributes = element.getAttributes();
        while (attributes.hasNext()) {
            Attribute attribute = attributes.next();
            if (this.isLocalName(attribute.getName(), VERSION_ATTRIBUTE_NAME)) {
                this.version = attribute.getValue();
                continue;
            }
            if (!this.isLocalName(attribute.getName(), BEAN_DISCOVERY_MODE_ATTRIBUTE_NAME)) continue;
            this.discoveryMode = this.parseDiscoveryMode(this.interpolate(attribute.getValue()).trim().toUpperCase());
        }
    }

    private boolean isLocalName(QName name, String value) {
        Objects.requireNonNull(name);
        Objects.requireNonNull(value);
        return value.equals(name.getLocalPart());
    }

    private void parseAlternatives(XMLEventReader reader, XMLEvent event) throws XMLStreamException {
        if (this.selectedAlternatives != null) {
            throw XmlLogger.LOG.multipleAlternatives(this.beansXml + "@" + event.asStartElement().getLocation().getLineNumber());
        }
        this.selectedAlternatives = new LinkedList<Metadata<String>>();
        this.selectedAlternativeStereotypes = new LinkedList<Metadata<String>>();
        while (reader.hasNext()) {
            event = reader.nextEvent();
            if (this.isEnd(event, ALTERNATIVES)) {
                return;
            }
            if (!event.isStartElement()) continue;
            StartElement element = (StartElement)event;
            if (this.isStartElement(element, CLASS)) {
                this.selectedAlternatives.add(new XmlMetadata<String>(element.getName().toString(), this.getTrimmedElementText(reader), this.beansXml, element.getLocation().getLineNumber()));
                continue;
            }
            if (!this.isStartElement(element, STEREOTYPE)) continue;
            this.selectedAlternativeStereotypes.add(new XmlMetadata<String>(element.getName().toString(), this.getTrimmedElementText(reader), this.beansXml, element.getLocation().getLineNumber()));
        }
    }

    private void parseInterceptors(XMLEventReader reader, XMLEvent event) throws XMLStreamException {
        if (this.enabledInterceptors != null) {
            throw XmlLogger.LOG.multipleInterceptors(this.beansXml + "@" + event.asStartElement().getLocation().getLineNumber());
        }
        this.enabledInterceptors = new LinkedList<Metadata<String>>();
        while (reader.hasNext()) {
            StartElement element;
            event = reader.nextEvent();
            if (this.isEnd(event, INTERCEPTORS)) {
                return;
            }
            if (!event.isStartElement() || !this.isStartElement(element = event.asStartElement(), CLASS)) continue;
            this.enabledInterceptors.add(new XmlMetadata<String>(element.getName().toString(), this.getTrimmedElementText(reader), this.beansXml, element.getLocation().getLineNumber()));
        }
    }

    private void parseDecorators(XMLEventReader reader, XMLEvent event) throws XMLStreamException {
        if (this.enabledDecorators != null) {
            throw XmlLogger.LOG.multipleDecorators(this.beansXml + "@" + event.asStartElement().getLocation().getLineNumber());
        }
        this.enabledDecorators = new LinkedList<Metadata<String>>();
        while (reader.hasNext()) {
            StartElement element;
            event = reader.nextEvent();
            if (this.isEnd(event, DECORATORS)) {
                return;
            }
            if (!event.isStartElement() || !this.isStartElement(element = event.asStartElement(), CLASS)) continue;
            this.enabledDecorators.add(new XmlMetadata<String>(element.getName().toString(), this.getTrimmedElementText(reader), this.beansXml, element.getLocation().getLineNumber()));
        }
    }

    private void parseScan(XMLEventReader reader, XMLEvent event) throws XMLStreamException {
        if (this.excludes != null) {
            throw XmlLogger.LOG.multipleScanning(this.beansXml + "@" + event.asStartElement().getLocation().getLineNumber());
        }
        this.excludes = new LinkedList<Metadata<Filter>>();
        this.includes = new LinkedList<Metadata<Filter>>();
        while (reader.hasNext()) {
            event = reader.nextEvent();
            if (this.isEnd(event, SCAN, SCANNING_URIS)) {
                return;
            }
            if (!event.isStartElement()) continue;
            StartElement element = (StartElement)event;
            if (this.isStartElement(element, EXCLUDE, SCANNING_URIS)) {
                this.handleFilter(element, reader, this.excludes::add);
                continue;
            }
            if (!this.isStartElement(element, INCLUDE, SCANNING_URIS)) continue;
            this.handleFilter(element, reader, this.includes::add);
        }
    }

    private void handleFilter(StartElement filterElement, XMLEventReader reader, Consumer<XmlMetadata<Filter>> consumer) throws XMLStreamException {
        String pattern;
        String name = this.getAttribute(filterElement, NAME_ATTRIBUTE_NAME);
        String string = pattern = name != null ? null : this.getAttribute(filterElement, PATTERN_ATTRIBUTE_NAME);
        if (name != null || pattern != null) {
            LinkedList<Metadata<SystemPropertyActivation>> systemPropertyActivations = new LinkedList<Metadata<SystemPropertyActivation>>();
            LinkedList<Metadata<ClassAvailableActivation>> classAvailableActivations = new LinkedList<Metadata<ClassAvailableActivation>>();
            while (reader.hasNext()) {
                XMLEvent event = reader.nextEvent();
                if (this.isEnd(event, EXCLUDE, SCANNING_URIS) || this.isEnd(event, INCLUDE, SCANNING_URIS)) {
                    FilterImpl filter = filterElement.getName().getNamespaceURI().equals(WELD_URI) ? new WeldFilterImpl(name, systemPropertyActivations, classAvailableActivations, pattern) : new FilterImpl(name, systemPropertyActivations, classAvailableActivations);
                    consumer.accept(new XmlMetadata<FilterImpl>(filterElement.getName().toString(), filter, this.beansXml, filterElement.getLocation().getLineNumber()));
                    return;
                }
                if (!event.isStartElement()) continue;
                StartElement element = (StartElement)event;
                if (this.isStartElement(element, IF_CLASS_AVAILABLE, SCANNING_URIS)) {
                    this.classAvailable(element, classAvailableActivations::add, false);
                    continue;
                }
                if (this.isStartElement(element, IF_CLASS_NOT_AVAILABLE, SCANNING_URIS)) {
                    this.classAvailable(element, classAvailableActivations::add, true);
                    continue;
                }
                if (!this.isStartElement(element, IF_SYSTEM_PROPERTY, SCANNING_URIS)) continue;
                this.systemProperty(element, systemPropertyActivations::add);
            }
        }
    }

    private void classAvailable(StartElement element, Consumer<Metadata<ClassAvailableActivation>> consumer, boolean inverse) {
        String className = this.getAttribute(element, NAME_ATTRIBUTE_NAME);
        XmlMetadata<ClassAvailableActivationImpl> classAvailableActivation = new XmlMetadata<ClassAvailableActivationImpl>(element.getName().toString(), new ClassAvailableActivationImpl(className, inverse), this.beansXml, element.getLocation().getLineNumber());
        consumer.accept(classAvailableActivation);
    }

    private void systemProperty(StartElement element, Consumer<Metadata<SystemPropertyActivation>> consumer) {
        String name = this.getAttribute(element, NAME_ATTRIBUTE_NAME);
        String value = this.getAttribute(element, VALUE_ATTRIBUTE_NAME);
        XmlMetadata<SystemPropertyActivationImpl> activation = new XmlMetadata<SystemPropertyActivationImpl>(element.getName().toString(), new SystemPropertyActivationImpl(name, value), this.beansXml, element.getLocation().getLineNumber());
        consumer.accept(activation);
    }

    private String getAttribute(StartElement element, String name) {
        Iterator<Attribute> attributes = element.getAttributes();
        while (attributes.hasNext()) {
            Attribute attribute = attributes.next();
            if (!attribute.getName().getLocalPart().equals(name)) continue;
            return this.interpolate(attribute.getValue().trim());
        }
        return null;
    }

    private boolean isStartElement(XMLEvent event, String name, Set<String> namespaces) {
        if (event.isStartElement()) {
            StartElement element = event.asStartElement();
            return this.isLocalName(element.getName(), name) && this.isInNamespace(element.getName(), namespaces);
        }
        return false;
    }

    private boolean isStartElement(XMLEvent event, String name) {
        return this.isStartElement(event, name, JAVAEE_URIS);
    }

    private boolean isEnd(XMLEvent event, String name) {
        return this.isEnd(event, name, JAVAEE_URIS);
    }

    private boolean isEnd(XMLEvent event, String name, Set<String> namespaces) {
        if (event.isEndElement()) {
            EndElement element = (EndElement)event;
            return this.isLocalName(element.getName(), name) && this.isInNamespace(element.getName(), namespaces);
        }
        return false;
    }

    private BeanDiscoveryMode parseDiscoveryMode(String value) {
        for (BeanDiscoveryMode mode : BeanDiscoveryMode.values()) {
            if (!mode.toString().equals(value)) continue;
            return mode;
        }
        throw new IllegalStateException("Unknown bean discovery mode: " + value);
    }

    private <T> List<T> orEmpty(List<T> list) {
        return list == null ? Collections.emptyList() : list;
    }

    private boolean isInNamespace(QName name, Set<String> uris) {
        String uri = name.getNamespaceURI();
        if (uris == null || uri.isEmpty()) {
            return true;
        }
        return uris.contains(uri);
    }

    private String getTrimmedElementText(XMLEventReader reader) throws XMLStreamException {
        return this.interpolate(reader.getElementText().trim());
    }

    protected String interpolate(String value) {
        return this.interpolator.apply(value);
    }
}

