/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.threads;

import java.lang.reflect.Field;
import java.security.AccessController;
import java.security.Permission;
import java.security.PrivilegedAction;
import java.util.Collection;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import org.jboss.logging.Logger;
import org.jboss.threads.BlockingExecutor;
import org.jboss.threads.BlockingExecutorService;
import org.jboss.threads.CleanupExecutor;
import org.jboss.threads.CompositeTask;
import org.jboss.threads.ContextClassLoaderExecutor;
import org.jboss.threads.ContextClassLoaderSavingRunnable;
import org.jboss.threads.DelegatingBlockingExecutor;
import org.jboss.threads.DelegatingBlockingExecutorService;
import org.jboss.threads.DelegatingDirectBlockingExecutor;
import org.jboss.threads.DelegatingDirectExecutorService;
import org.jboss.threads.DelegatingExecutorService;
import org.jboss.threads.DelegatingScheduledExecutorService;
import org.jboss.threads.DelegatingWrappedExecutor;
import org.jboss.threads.DelegatingWrappingExecutor;
import org.jboss.threads.DependencyTaskBuilder;
import org.jboss.threads.DirectExecutor;
import org.jboss.threads.DirectExecutorService;
import org.jboss.threads.DiscardingExecutor;
import org.jboss.threads.ExceptionLoggingExecutor;
import org.jboss.threads.ExecutionInterruptedException;
import org.jboss.threads.ExecutorTask;
import org.jboss.threads.HandoffRejectedExecutionHandler;
import org.jboss.threads.InitializingExecutor;
import org.jboss.threads.LoggingUncaughtExceptionHandler;
import org.jboss.threads.Messages;
import org.jboss.threads.NotifyingDirectExecutor;
import org.jboss.threads.NotifyingRunnable;
import org.jboss.threads.NullRunnable;
import org.jboss.threads.PrivilegedExecutor;
import org.jboss.threads.RejectingExecutor;
import org.jboss.threads.SimpleDirectExecutor;
import org.jboss.threads.TaskNotifier;
import org.jboss.threads.ThreadFactoryExecutor;
import org.jboss.threads.ThreadFormattedNameExecutor;
import org.jboss.threads.ThreadLocalResetter;
import org.jboss.threads.ThreadNameExecutor;
import org.jboss.threads.ThreadNameNotatingExecutor;
import org.jboss.threads.UninterruptibleExecutor;
import org.jboss.threads.WrappingExecutor;
import org.jboss.threads.WrappingThreadFactory;
import org.wildfly.common.Assert;
import sun.misc.Unsafe;

public final class JBossExecutors {
    private static final Logger THREAD_ERROR_LOGGER = Logger.getLogger((String)"org.jboss.threads.errors");
    private static final RuntimePermission MODIFY_THREAD_PERMISSION = new RuntimePermission("modifyThread");
    private static final RuntimePermission COPY_CONTEXT_CLASSLOADER_PERMISSION = new RuntimePermission("copyClassLoader");
    private static final DirectExecutorService DIRECT_EXECUTOR_SERVICE = new DelegatingDirectExecutorService(SimpleDirectExecutor.INSTANCE);
    private static final DirectExecutorService REJECTING_EXECUTOR_SERVICE = new DelegatingDirectExecutorService(RejectingExecutor.INSTANCE);
    private static final DirectExecutorService DISCARDING_EXECUTOR_SERVICE = new DelegatingDirectExecutorService(DiscardingExecutor.INSTANCE);
    @Deprecated
    private static final BlockingExecutor BLOCKING_DIRECT_EXECUTOR = new DelegatingDirectBlockingExecutor(SimpleDirectExecutor.INSTANCE);
    @Deprecated
    private static final BlockingExecutor BLOCKING_REJECTING_EXECUTOR = new DelegatingDirectBlockingExecutor(RejectingExecutor.INSTANCE);
    @Deprecated
    private static final BlockingExecutor BLOCKING_DISCARDING_EXECUTOR = new DelegatingDirectBlockingExecutor(DiscardingExecutor.INSTANCE);
    private static final RejectedExecutionHandler ABORT_POLICY = new ThreadPoolExecutor.AbortPolicy();
    private static final RejectedExecutionHandler CALLER_RUNS_POLICY = new ThreadPoolExecutor.CallerRunsPolicy();
    private static final RejectedExecutionHandler DISCARD_OLDEST_POLICY = new ThreadPoolExecutor.DiscardOldestPolicy();
    private static final RejectedExecutionHandler DISCARD_POLICY = new ThreadPoolExecutor.DiscardPolicy();
    private static final Runnable TCCL_RESETTER = new Runnable(){

        @Override
        public void run() {
            Thread.currentThread().setContextClassLoader(null);
        }

        public String toString() {
            return "ContextClassLoader-resetting Runnable";
        }
    };
    private static final Runnable NULL_RUNNABLE = NullRunnable.getInstance();
    private static final Runnable THREAD_LOCAL_RESETTER;
    static final ClassLoader SAFE_CL;
    static final Unsafe unsafe;
    static final long contextClassLoaderOffs;
    private static final Thread.UncaughtExceptionHandler LOGGING_HANDLER;

    private JBossExecutors() {
    }

    public static DirectExecutor directExecutor() {
        return SimpleDirectExecutor.INSTANCE;
    }

    public static DirectExecutorService directExecutorService() {
        return DIRECT_EXECUTOR_SERVICE;
    }

    public static DirectExecutor rejectingExecutor() {
        return RejectingExecutor.INSTANCE;
    }

    public static DirectExecutor rejectingExecutor(String message) {
        return new RejectingExecutor(message);
    }

    public static DirectExecutorService rejectingExecutorService() {
        return REJECTING_EXECUTOR_SERVICE;
    }

    public static DirectExecutorService rejectingExecutorService(String message) {
        return JBossExecutors.protectedDirectExecutorService(JBossExecutors.rejectingExecutor(message));
    }

    public static DirectExecutor discardingExecutor() {
        return DiscardingExecutor.INSTANCE;
    }

    public static DirectExecutorService discardingExecutorService() {
        return DISCARDING_EXECUTOR_SERVICE;
    }

    public static DirectExecutor privilegedExecutor(DirectExecutor delegate) {
        return new PrivilegedExecutor(delegate);
    }

    public static DirectExecutor contextClassLoaderExecutor(DirectExecutor delegate, ClassLoader taskClassLoader) {
        return new ContextClassLoaderExecutor(taskClassLoader, delegate);
    }

    public static DirectExecutor threadNameExecutor(DirectExecutor delegate, String newName) {
        return new ThreadNameExecutor(newName, delegate);
    }

    public static DirectExecutor threadFormattedNameExecutor(DirectExecutor delegate, String newName) {
        return new ThreadFormattedNameExecutor(newName, delegate);
    }

    public static DirectExecutor threadNameNotateExecutor(DirectExecutor delegate, String notation) {
        return new ThreadNameNotatingExecutor(notation, delegate);
    }

    public static DirectExecutor exceptionLoggingExecutor(DirectExecutor delegate, Logger log) {
        return new ExceptionLoggingExecutor(delegate, log);
    }

    public static DirectExecutor exceptionLoggingExecutor(DirectExecutor delegate, Logger log, Logger.Level level) {
        return new ExceptionLoggingExecutor(delegate, log, level);
    }

    public static DirectExecutor exceptionLoggingExecutor(DirectExecutor delegate) {
        return JBossExecutors.exceptionLoggingExecutor(delegate, THREAD_ERROR_LOGGER);
    }

    public static DirectExecutor resettingExecutor(DirectExecutor delegate) throws SecurityException {
        return JBossExecutors.cleanupExecutor(delegate, JBossExecutors.threadLocalResetter());
    }

    public static DirectExecutor initializingExecutor(DirectExecutor delegate, Runnable initializer) {
        return new InitializingExecutor(initializer, delegate);
    }

    public static DirectExecutor cleanupExecutor(DirectExecutor delegate, Runnable cleaner) {
        return new CleanupExecutor(cleaner, delegate);
    }

    @Deprecated
    public static BlockingExecutor blockingDirectExecutor() {
        return BLOCKING_DIRECT_EXECUTOR;
    }

    @Deprecated
    public static BlockingExecutor blockingDiscardingExecutor() {
        return BLOCKING_DISCARDING_EXECUTOR;
    }

    @Deprecated
    public static BlockingExecutor blockingRejectingExecutor() {
        return BLOCKING_REJECTING_EXECUTOR;
    }

    public static Executor wrappingExecutor(DirectExecutor taskWrapper, Executor delegate) {
        return JBossExecutors.executor(JBossExecutors.wrappingExecutor(delegate), taskWrapper);
    }

    @Deprecated
    public static BlockingExecutor directBlockingExecutor(DirectExecutor delegate) {
        return new DelegatingDirectBlockingExecutor(delegate);
    }

    public static WrappingExecutor wrappingExecutor(Executor delegate) {
        return new DelegatingWrappingExecutor(delegate);
    }

    public static Executor executor(WrappingExecutor delegate, DirectExecutor taskWrapper) {
        return new DelegatingWrappedExecutor(delegate, taskWrapper);
    }

    @Deprecated
    public static BlockingExecutor threadFactoryExecutor(ThreadFactory factory) {
        return new ThreadFactoryExecutor(factory, Integer.MAX_VALUE, false, JBossExecutors.directExecutor());
    }

    @Deprecated
    public static BlockingExecutor threadFactoryExecutor(ThreadFactory factory, int maxThreads) {
        return new ThreadFactoryExecutor(factory, maxThreads, false, JBossExecutors.directExecutor());
    }

    @Deprecated
    public static BlockingExecutor threadFactoryExecutor(ThreadFactory factory, int maxThreads, boolean blocking) {
        return new ThreadFactoryExecutor(factory, maxThreads, blocking, JBossExecutors.directExecutor());
    }

    @Deprecated
    public static BlockingExecutor threadFactoryExecutor(ThreadFactory factory, int maxThreads, boolean blocking, DirectExecutor taskExecutor) {
        return new ThreadFactoryExecutor(factory, maxThreads, blocking, taskExecutor);
    }

    public static RejectedExecutionHandler abortPolicy() {
        return ABORT_POLICY;
    }

    public static RejectedExecutionHandler callerRunsPolicy() {
        return CALLER_RUNS_POLICY;
    }

    public static RejectedExecutionHandler discardOldestPolicy() {
        return DISCARD_OLDEST_POLICY;
    }

    public static RejectedExecutionHandler discardPolicy() {
        return DISCARD_POLICY;
    }

    public static RejectedExecutionHandler handoffPolicy(Executor target) {
        return new HandoffRejectedExecutionHandler(target);
    }

    @Deprecated
    public static BlockingExecutor protectedBlockingExecutor(BlockingExecutor target) {
        return new DelegatingBlockingExecutor(target);
    }

    public static ExecutorService protectedExecutorService(Executor target) {
        return new DelegatingExecutorService(target);
    }

    public static DirectExecutorService protectedDirectExecutorService(DirectExecutor target) {
        return new DelegatingDirectExecutorService(target);
    }

    public static ScheduledExecutorService protectedScheduledExecutorService(ScheduledExecutorService target) {
        return new DelegatingScheduledExecutorService(target);
    }

    @Deprecated
    public static BlockingExecutorService protectedBlockingExecutorService(BlockingExecutor target) {
        return new DelegatingBlockingExecutorService(target);
    }

    public static ThreadFactory resettingThreadFactory(ThreadFactory delegate) throws SecurityException {
        return JBossExecutors.wrappingThreadFactory(JBossExecutors.resettingExecutor(JBossExecutors.directExecutor()), delegate);
    }

    public static ThreadFactory wrappingThreadFactory(DirectExecutor taskWrapper, ThreadFactory delegate) {
        return new WrappingThreadFactory(delegate, taskWrapper);
    }

    public static Runnable nullRunnable() {
        return NULL_RUNNABLE;
    }

    public static Runnable threadLocalResetter() throws SecurityException {
        JBossExecutors.checkAccess(MODIFY_THREAD_PERMISSION);
        return THREAD_LOCAL_RESETTER;
    }

    public static Runnable contextClassLoaderResetter() {
        return TCCL_RESETTER;
    }

    public static Runnable executorTask(DirectExecutor executor, Runnable task) {
        return new ExecutorTask(executor, task);
    }

    public static Runnable compositeTask(Runnable ... runnables) {
        return new CompositeTask((Runnable[])runnables.clone());
    }

    public static Runnable classLoaderPreservingTask(Runnable delegate) throws SecurityException {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(COPY_CONTEXT_CLASSLOADER_PERMISSION);
        }
        return JBossExecutors.classLoaderPreservingTaskUnchecked(delegate);
    }

    static Runnable classLoaderPreservingTaskUnchecked(Runnable delegate) {
        Assert.checkNotNullParam((String)"delegate", (Object)delegate);
        return new ContextClassLoaderSavingRunnable(JBossExecutors.getContextClassLoader(Thread.currentThread()), delegate);
    }

    static ClassLoader getContextClassLoader(Thread thread) {
        return (ClassLoader)unsafe.getObject(thread, contextClassLoaderOffs);
    }

    static ClassLoader getAndSetContextClassLoader(Thread thread, ClassLoader newClassLoader) {
        try {
            ClassLoader classLoader = JBossExecutors.getContextClassLoader(thread);
            return classLoader;
        }
        finally {
            JBossExecutors.setContextClassLoader(thread, newClassLoader);
        }
    }

    static void setContextClassLoader(Thread thread, ClassLoader classLoader) {
        unsafe.putObject(thread, contextClassLoaderOffs, classLoader);
    }

    static void clearContextClassLoader(Thread thread) {
        unsafe.putObject(thread, contextClassLoaderOffs, SAFE_CL);
    }

    public static Runnable compositeTask(Collection<Runnable> runnables) {
        return new CompositeTask(runnables.toArray(new Runnable[runnables.size()]));
    }

    static void checkAccess(Permission permission) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(permission);
        }
    }

    public static Thread.UncaughtExceptionHandler loggingExceptionHandler(Logger log) {
        return new LoggingUncaughtExceptionHandler(log);
    }

    public static Thread.UncaughtExceptionHandler loggingExceptionHandler(String categoryName) {
        return new LoggingUncaughtExceptionHandler(Logger.getLogger((String)categoryName));
    }

    public static Thread.UncaughtExceptionHandler loggingExceptionHandler() {
        return LOGGING_HANDLER;
    }

    private static <R extends Runnable> void logError(R runnable, Throwable t, String method) {
        THREAD_ERROR_LOGGER.errorf(t, "Notifier %s() method invocation failed for task %s", (Object)method, runnable);
    }

    private static <R extends Runnable, A> void started(TaskNotifier<? super R, ? super A> notifier, R runnable, A attachment) {
        try {
            notifier.started(runnable, attachment);
        }
        catch (Throwable t) {
            JBossExecutors.logError(runnable, t, "started");
        }
    }

    private static <R extends Runnable, A> void finished(TaskNotifier<? super R, ? super A> notifier, R runnable, A attachment) {
        try {
            notifier.finished(runnable, attachment);
        }
        catch (Throwable t) {
            JBossExecutors.logError(runnable, t, "finished");
        }
    }

    private static <R extends Runnable, A> void failed(TaskNotifier<? super R, ? super A> notifier, Throwable reason, R runnable, A attachment) {
        try {
            notifier.failed(runnable, reason, attachment);
        }
        catch (Throwable t) {
            JBossExecutors.logError(runnable, t, "failed");
        }
    }

    public static <R extends Runnable, A> void run(R task, DirectExecutor directExecutor, TaskNotifier<? super R, ? super A> notifier, A attachment) {
        JBossExecutors.started(notifier, task, attachment);
        boolean ok = false;
        try {
            directExecutor.execute(task);
            ok = true;
        }
        catch (RuntimeException t) {
            JBossExecutors.failed(notifier, t, task, attachment);
            throw t;
        }
        catch (Error t) {
            JBossExecutors.failed(notifier, t, task, attachment);
            throw t;
        }
        catch (Throwable t) {
            JBossExecutors.failed(notifier, t, task, attachment);
            throw Messages.msg.unknownThrowable(t);
        }
        finally {
            if (ok) {
                JBossExecutors.finished(notifier, task, attachment);
            }
        }
    }

    public static <R extends Runnable, A> void run(R task, TaskNotifier<? super R, ? super A> notifier, A attachment) {
        JBossExecutors.run(task, JBossExecutors.directExecutor(), notifier, attachment);
    }

    public static <R extends Runnable, A> Runnable notifyingRunnable(R task, TaskNotifier<? super R, ? super A> notifier, A attachment) {
        return new NotifyingRunnable<R, A>(task, notifier, attachment);
    }

    public static <A> DirectExecutor notifyingDirectExecutor(DirectExecutor delegate, TaskNotifier<Runnable, ? super A> notifier, A attachment) {
        return new NotifyingDirectExecutor<A>(delegate, notifier, attachment);
    }

    public static void executeUninterruptibly(Executor executor, Runnable task) throws RejectedExecutionException {
        boolean intr = Thread.interrupted();
        while (true) {
            try {
                executor.execute(task);
                return;
            }
            catch (ExecutionInterruptedException e) {
                intr |= Thread.interrupted();
                continue;
            }
            break;
        }
        finally {
            if (intr) {
                Thread.currentThread().interrupt();
            }
        }
    }

    public static Executor uninterruptibleExecutor(Executor delegate) {
        if (delegate instanceof UninterruptibleExecutor) {
            return delegate;
        }
        return new UninterruptibleExecutor(delegate);
    }

    public static DependencyTaskBuilder dependencyTaskBuilder(Executor executor, Runnable task) {
        return new DependencyTaskBuilder(executor, task);
    }

    static {
        ClassLoader safeClassLoader = JBossExecutors.class.getClassLoader();
        if (safeClassLoader == null) {
            safeClassLoader = ClassLoader.getSystemClassLoader();
        }
        if (safeClassLoader == null) {
            safeClassLoader = new ClassLoader(){};
        }
        SAFE_CL = safeClassLoader;
        unsafe = AccessController.doPrivileged(new PrivilegedAction<Unsafe>(){

            @Override
            public Unsafe run() {
                try {
                    Field field = Unsafe.class.getDeclaredField("theUnsafe");
                    field.setAccessible(true);
                    return (Unsafe)field.get(null);
                }
                catch (IllegalAccessException e) {
                    throw new IllegalAccessError(e.getMessage());
                }
                catch (NoSuchFieldException e) {
                    throw new NoSuchFieldError(e.getMessage());
                }
            }
        });
        try {
            contextClassLoaderOffs = unsafe.objectFieldOffset(Thread.class.getDeclaredField("contextClassLoader"));
        }
        catch (NoSuchFieldException e) {
            throw new NoSuchFieldError(e.getMessage());
        }
        THREAD_LOCAL_RESETTER = ThreadLocalResetter.getInstance();
        LOGGING_HANDLER = JBossExecutors.loggingExceptionHandler(THREAD_ERROR_LOGGER);
    }
}

