/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.plugins.server.sun.http;

import com.sun.net.httpserver.HttpExchange;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.NewCookie;
import javax.ws.rs.ext.RuntimeDelegate;
import org.jboss.resteasy.spi.HttpResponse;
import org.jboss.resteasy.spi.ResteasyProviderFactory;
import org.jboss.resteasy.util.CaseInsensitiveMap;

public class HttpServerResponse
implements HttpResponse {
    private int status = 200;
    private MultivaluedMap<String, Object> outputHeaders;
    private HttpExchange exchange;
    private OutputStream streamWrapper;
    private boolean committed;
    private ResteasyProviderFactory factory;

    public HttpServerResponse(ResteasyProviderFactory factory, HttpExchange ex) {
        this.exchange = ex;
        this.factory = factory;
        this.outputHeaders = new CaseInsensitiveMap();
        this.streamWrapper = new OutputStream(){

            @Override
            public void write(int i) throws IOException {
                HttpServerResponse.this.commitHeaders();
                HttpServerResponse.this.exchange.getResponseBody().write(i);
            }

            @Override
            public void write(byte[] bytes) throws IOException {
                HttpServerResponse.this.commitHeaders();
                HttpServerResponse.this.exchange.getResponseBody().write(bytes);
            }

            @Override
            public void write(byte[] bytes, int i, int i1) throws IOException {
                HttpServerResponse.this.commitHeaders();
                HttpServerResponse.this.exchange.getResponseBody().write(bytes, i, i1);
            }

            @Override
            public void flush() throws IOException {
                HttpServerResponse.this.commitHeaders();
                HttpServerResponse.this.exchange.getResponseBody().flush();
            }
        };
    }

    protected void addHeader(String name, Object value) {
        RuntimeDelegate.HeaderDelegate delegate = this.factory.getHeaderDelegate(value.getClass());
        if (delegate != null) {
            this.exchange.getResponseHeaders().add(name, delegate.toString(value));
        } else {
            this.exchange.getResponseHeaders().add(name, value.toString());
        }
    }

    public void commitHeaders() throws IOException {
        if (this.committed) {
            return;
        }
        long len = 0L;
        len = this.outputHeaders.containsKey((Object)"Content-Length") ? Long.valueOf(this.outputHeaders.getFirst((Object)"Content-Length").toString()) : (this.outputHeaders.containsKey((Object)"Content-Type") ? 0L : -1L);
        for (Map.Entry entry : this.outputHeaders.entrySet()) {
            for (Object val : (List)entry.getValue()) {
                this.addHeader((String)entry.getKey(), val);
            }
        }
        this.exchange.sendResponseHeaders(this.status, len);
        this.committed = true;
    }

    public int getStatus() {
        return this.status;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public MultivaluedMap<String, Object> getOutputHeaders() {
        return this.outputHeaders;
    }

    public OutputStream getOutputStream() throws IOException {
        return this.streamWrapper;
    }

    public void setOutputStream(OutputStream os) {
        this.streamWrapper = os;
    }

    public void addNewCookie(NewCookie cookie) {
        this.outputHeaders.add((Object)"Set-Cookie", (Object)cookie);
    }

    public void sendError(int status) throws IOException {
        this.status = status;
        this.exchange.sendResponseHeaders(status, -1L);
        this.committed = true;
    }

    public void sendError(int status, String message) throws IOException {
        this.status = status;
        this.exchange.sendResponseHeaders(status, -1L);
        this.committed = true;
    }

    public boolean isCommitted() {
        return this.committed;
    }

    public void reset() {
        this.outputHeaders.clear();
    }
}

