/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.vfs;

import java.io.Serializable;
import java.security.Permission;
import java.security.PermissionCollection;
import org.jboss.vfs.VFSMessages;
import org.jboss.vfs.VFSUtils;
import org.jboss.vfs.VirtualFilePermissionCollection;

public final class VirtualFilePermission
extends Permission
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final int actionFlags;
    public static final int FLAG_READ = Integer.parseInt("0000000000000001", 2);
    public static final int FLAG_DELETE = Integer.parseInt("0000000000000010", 2);
    public static final int FLAG_GET_FILE = Integer.parseInt("0000000000000100", 2);
    public static final int VALID_FLAGS = Integer.parseInt("0000000000000111", 2);

    VirtualFilePermission(String path, int actionFlags, boolean canonicalize) {
        super(canonicalize ? VFSUtils.canonicalize(path) : path);
        this.actionFlags = actionFlags & VALID_FLAGS;
    }

    public VirtualFilePermission(String path, String actions) {
        this(path, VirtualFilePermission.parseActions(actions), true);
    }

    public VirtualFilePermission(String path, int actionFlags) {
        this(path, actionFlags, true);
    }

    private static boolean in(char c, char t1, char t2) {
        return c == t1 || c == t2;
    }

    private static boolean lenIs(String s, int idx, int len, int wlen) {
        return idx == len - wlen || idx < len - wlen && s.charAt(idx + wlen) == ',';
    }

    static int parseActions(String actions) {
        int len = actions.length();
        int res = 0;
        for (int i = 0; i < len; ++i) {
            if (VirtualFilePermission.lenIs(actions, i, len, 4) && VirtualFilePermission.in(actions.charAt(i), 'r', 'R') && VirtualFilePermission.in(actions.charAt(i + 1), 'e', 'E') && VirtualFilePermission.in(actions.charAt(i + 2), 'a', 'A') && VirtualFilePermission.in(actions.charAt(i + 3), 'd', 'D')) {
                res |= FLAG_READ;
                i += 4;
                continue;
            }
            if (VirtualFilePermission.lenIs(actions, i, len, 6) && VirtualFilePermission.in(actions.charAt(i), 'd', 'D') && VirtualFilePermission.in(actions.charAt(i + 1), 'e', 'E') && VirtualFilePermission.in(actions.charAt(i + 2), 'l', 'L') && VirtualFilePermission.in(actions.charAt(i + 3), 'e', 'E') && VirtualFilePermission.in(actions.charAt(i + 4), 't', 'T') && VirtualFilePermission.in(actions.charAt(i + 5), 'e', 'E')) {
                res |= FLAG_DELETE;
                i += 6;
                continue;
            }
            if (VirtualFilePermission.lenIs(actions, i, len, 7) && VirtualFilePermission.in(actions.charAt(i), 'g', 'G') && VirtualFilePermission.in(actions.charAt(i + 1), 'e', 'E') && VirtualFilePermission.in(actions.charAt(i + 2), 't', 'T') && VirtualFilePermission.in(actions.charAt(i + 3), 'f', 'F') && VirtualFilePermission.in(actions.charAt(i + 4), 'i', 'I') && VirtualFilePermission.in(actions.charAt(i + 5), 'l', 'L') && VirtualFilePermission.in(actions.charAt(i + 6), 'e', 'E')) {
                res |= FLAG_GET_FILE;
                i += 7;
                continue;
            }
            if (VirtualFilePermission.lenIs(actions, i, len, 1) && actions.charAt(i) == '*') {
                res |= FLAG_READ | FLAG_DELETE | FLAG_GET_FILE;
                continue;
            }
            throw VFSMessages.MESSAGES.invalidActionsString(actions);
        }
        return res;
    }

    @Override
    public boolean implies(Permission permission) {
        return permission instanceof VirtualFilePermission && this.implies((VirtualFilePermission)permission);
    }

    public boolean implies(VirtualFilePermission permission) {
        return permission != null && this.impliesUnchecked(permission);
    }

    private boolean impliesUnchecked(VirtualFilePermission permission) {
        int theirFlags = permission.actionFlags;
        return (this.actionFlags & theirFlags) == theirFlags && VirtualFilePermission.impliesPath(this.getName(), permission.getName());
    }

    private static int ourIndexOf(String str, char ch, int start) {
        int idx = str.indexOf(ch, start);
        return idx == -1 ? str.length() : idx;
    }

    static boolean impliesPath(String ourName, String theirName) {
        if ("<<ALL FILES>>".equals(ourName)) {
            return true;
        }
        return VirtualFilePermission.impliesPath(ourName, theirName, 0);
    }

    private static boolean impliesPath(String ourName, String theirName, int idx) {
        int ourLen = ourName.length();
        int theirLen = theirName.length();
        int ei1 = VirtualFilePermission.ourIndexOf(ourName, '/', idx);
        int ei2 = VirtualFilePermission.ourIndexOf(theirName, '/', idx);
        if (ei1 == idx + 1) {
            char ch = ourName.charAt(idx);
            if (ch == '-') {
                return theirLen > idx;
            }
            if (ch == '*') {
                return theirLen > idx && ei2 == theirLen && (ei2 != ei1 || theirName.charAt(idx) != '-');
            }
        }
        if (ei1 == ei2) {
            if (ei1 == ourLen && ei2 == theirLen) {
                return true;
            }
            return VirtualFilePermission.impliesPath(ourName, theirName, ei1 + 1);
        }
        return false;
    }

    @Override
    public String getActions() {
        StringBuilder builder = new StringBuilder();
        if ((this.actionFlags & FLAG_READ) != 0) {
            builder.append("read");
        }
        if ((this.actionFlags & FLAG_DELETE) != 0) {
            if (builder.length() > 0) {
                builder.append(',');
            }
            builder.append("delete");
        }
        if ((this.actionFlags & FLAG_GET_FILE) != 0) {
            if (builder.length() > 0) {
                builder.append(',');
            }
            builder.append("getfile");
        }
        return builder.toString();
    }

    public int getActionFlags() {
        return this.actionFlags;
    }

    @Override
    public PermissionCollection newPermissionCollection() {
        return new VirtualFilePermissionCollection();
    }

    @Override
    public boolean equals(Object permission) {
        return permission instanceof VirtualFilePermission && this.equals((VirtualFilePermission)permission);
    }

    public boolean equals(Permission permission) {
        return permission instanceof VirtualFilePermission && this.equals((VirtualFilePermission)permission);
    }

    public boolean equals(VirtualFilePermission permission) {
        return permission != null && permission.actionFlags == this.actionFlags && permission.getName().equals(permission.getName());
    }

    @Override
    public int hashCode() {
        return this.getName().hashCode() * 11 + this.actionFlags;
    }
}

