/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dmr;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.Charset;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.dmr.stream.ModelEvent;
import org.jboss.dmr.stream.ModelException;
import org.jboss.dmr.stream.ModelReader;
import org.jboss.dmr.stream.ModelStreamFactory;

final class ModelNodeFactory {
    static final ModelNodeFactory INSTANCE = new ModelNodeFactory();

    private ModelNodeFactory() {
    }

    ModelNode readFrom(Reader input, boolean jsonCompatible) throws IOException, ModelException {
        ModelReader reader = ModelStreamFactory.getInstance(jsonCompatible).newModelReader(input);
        return this.readFrom(reader);
    }

    ModelNode readFrom(String input, boolean jsonCompatible) throws IOException, ModelException {
        StringReader reader = new StringReader(input);
        return this.readFrom(reader, jsonCompatible);
    }

    ModelNode readFrom(InputStream input, boolean jsonCompatible) throws IOException, ModelException {
        ModelReader reader = ModelStreamFactory.getInstance(jsonCompatible).newModelReader(input);
        return this.readFrom(reader);
    }

    ModelNode readFrom(InputStream input, Charset charset, boolean jsonCompatible) throws IOException, ModelException {
        ModelReader reader = ModelStreamFactory.getInstance(jsonCompatible).newModelReader(input, charset);
        return this.readFrom(reader);
    }

    private ModelNode readFrom(ModelReader modelReader) throws IOException, ModelException {
        ModelEvent event = modelReader.next();
        if (event == ModelEvent.STRING) {
            return this.readStringFrom(modelReader);
        }
        if (event == ModelEvent.INT) {
            return this.readIntFrom(modelReader);
        }
        if (event == ModelEvent.LONG) {
            return this.readLongFrom(modelReader);
        }
        if (event == ModelEvent.DOUBLE) {
            return this.readDoubleFrom(modelReader);
        }
        if (event == ModelEvent.BIG_INTEGER) {
            return this.readBigIntegerFrom(modelReader);
        }
        if (event == ModelEvent.BIG_DECIMAL) {
            return this.readBigDecimalFrom(modelReader);
        }
        if (event == ModelEvent.BYTES) {
            return this.readBytesFrom(modelReader);
        }
        if (event == ModelEvent.EXPRESSION) {
            return this.readExpressionFrom(modelReader);
        }
        if (event == ModelEvent.TYPE) {
            return this.readTypeFrom(modelReader);
        }
        if (event == ModelEvent.BOOLEAN) {
            return this.readBooleanFrom(modelReader);
        }
        if (event == ModelEvent.UNDEFINED) {
            return this.readUndefinedFrom(modelReader);
        }
        if (event == ModelEvent.OBJECT_START) {
            return this.readObjectFrom(modelReader);
        }
        if (event == ModelEvent.LIST_START) {
            return this.readListFrom(modelReader);
        }
        if (event == ModelEvent.PROPERTY_START) {
            return this.readPropertyFrom(modelReader);
        }
        throw new IllegalStateException();
    }

    private ModelNode readStringFrom(ModelReader modelReader) throws IOException, ModelException {
        return new ModelNode().set(modelReader.getString());
    }

    private ModelNode readIntFrom(ModelReader modelReader) throws IOException, ModelException {
        return new ModelNode().set(modelReader.getInt());
    }

    private ModelNode readLongFrom(ModelReader modelReader) throws IOException, ModelException {
        return new ModelNode().set(modelReader.getLong());
    }

    private ModelNode readDoubleFrom(ModelReader modelReader) throws IOException, ModelException {
        return new ModelNode().set(modelReader.getDouble());
    }

    private ModelNode readBigIntegerFrom(ModelReader modelReader) throws IOException, ModelException {
        return new ModelNode().set(modelReader.getBigInteger());
    }

    private ModelNode readBigDecimalFrom(ModelReader modelReader) throws IOException, ModelException {
        return new ModelNode().set(modelReader.getBigDecimal());
    }

    private ModelNode readBytesFrom(ModelReader modelReader) throws IOException, ModelException {
        return new ModelNode().set(modelReader.getBytes());
    }

    private ModelNode readExpressionFrom(ModelReader modelReader) throws IOException, ModelException {
        return new ModelNode().setExpression(modelReader.getExpression());
    }

    private ModelNode readTypeFrom(ModelReader modelReader) throws IOException, ModelException {
        return new ModelNode().set(ModelType.valueOf(modelReader.getType().toString()));
    }

    private ModelNode readBooleanFrom(ModelReader modelReader) throws IOException, ModelException {
        return new ModelNode().set(modelReader.getBoolean());
    }

    private ModelNode readUndefinedFrom(ModelReader modelReader) throws IOException, ModelException {
        return new ModelNode();
    }

    private ModelNode readListFrom(ModelReader modelReader) throws IOException, ModelException {
        ModelNode listNode = new ModelNode();
        listNode.setEmptyList();
        ModelEvent event = modelReader.next();
        while (event != ModelEvent.LIST_END) {
            ModelNode value;
            if (event == ModelEvent.STRING) {
                value = this.readStringFrom(modelReader);
            } else if (event == ModelEvent.INT) {
                value = this.readIntFrom(modelReader);
            } else if (event == ModelEvent.LONG) {
                value = this.readLongFrom(modelReader);
            } else if (event == ModelEvent.DOUBLE) {
                value = this.readDoubleFrom(modelReader);
            } else if (event == ModelEvent.BIG_INTEGER) {
                value = this.readBigIntegerFrom(modelReader);
            } else if (event == ModelEvent.BIG_DECIMAL) {
                value = this.readBigDecimalFrom(modelReader);
            } else if (event == ModelEvent.BYTES) {
                value = this.readBytesFrom(modelReader);
            } else if (event == ModelEvent.EXPRESSION) {
                value = this.readExpressionFrom(modelReader);
            } else if (event == ModelEvent.TYPE) {
                value = this.readTypeFrom(modelReader);
            } else if (event == ModelEvent.BOOLEAN) {
                value = this.readBooleanFrom(modelReader);
            } else if (event == ModelEvent.UNDEFINED) {
                value = this.readUndefinedFrom(modelReader);
            } else if (event == ModelEvent.OBJECT_START) {
                value = this.readObjectFrom(modelReader);
            } else if (event == ModelEvent.LIST_START) {
                value = this.readListFrom(modelReader);
            } else if (event == ModelEvent.PROPERTY_START) {
                value = this.readPropertyFrom(modelReader);
            } else {
                throw new IllegalStateException();
            }
            listNode.addNoCopy(value);
            event = modelReader.next();
        }
        return listNode;
    }

    private ModelNode readObjectFrom(ModelReader modelReader) throws IOException, ModelException {
        ModelNode objectNode = new ModelNode();
        objectNode.setEmptyObject();
        ModelEvent event = modelReader.next();
        while (event != ModelEvent.OBJECT_END) {
            ModelNode value;
            String key = modelReader.getString();
            event = modelReader.next();
            if (event == ModelEvent.STRING) {
                value = this.readStringFrom(modelReader);
            } else if (event == ModelEvent.INT) {
                value = this.readIntFrom(modelReader);
            } else if (event == ModelEvent.LONG) {
                value = this.readLongFrom(modelReader);
            } else if (event == ModelEvent.DOUBLE) {
                value = this.readDoubleFrom(modelReader);
            } else if (event == ModelEvent.BIG_INTEGER) {
                value = this.readBigIntegerFrom(modelReader);
            } else if (event == ModelEvent.BIG_DECIMAL) {
                value = this.readBigDecimalFrom(modelReader);
            } else if (event == ModelEvent.BYTES) {
                value = this.readBytesFrom(modelReader);
            } else if (event == ModelEvent.EXPRESSION) {
                value = this.readExpressionFrom(modelReader);
            } else if (event == ModelEvent.TYPE) {
                value = this.readTypeFrom(modelReader);
            } else if (event == ModelEvent.BOOLEAN) {
                value = this.readBooleanFrom(modelReader);
            } else if (event == ModelEvent.UNDEFINED) {
                value = this.readUndefinedFrom(modelReader);
            } else if (event == ModelEvent.OBJECT_START) {
                value = this.readObjectFrom(modelReader);
            } else if (event == ModelEvent.LIST_START) {
                value = this.readListFrom(modelReader);
            } else if (event == ModelEvent.PROPERTY_START) {
                value = this.readPropertyFrom(modelReader);
            } else {
                throw new IllegalStateException();
            }
            objectNode.get(key).setNoCopy(value);
            event = modelReader.next();
        }
        return objectNode;
    }

    private ModelNode readPropertyFrom(ModelReader modelReader) throws IOException, ModelException {
        ModelNode propertyNode = new ModelNode();
        ModelEvent event = modelReader.next();
        while (event != ModelEvent.PROPERTY_END) {
            ModelNode value;
            String key = modelReader.getString();
            event = modelReader.next();
            if (event == ModelEvent.STRING) {
                value = this.readStringFrom(modelReader);
            } else if (event == ModelEvent.INT) {
                value = this.readIntFrom(modelReader);
            } else if (event == ModelEvent.LONG) {
                value = this.readLongFrom(modelReader);
            } else if (event == ModelEvent.DOUBLE) {
                value = this.readDoubleFrom(modelReader);
            } else if (event == ModelEvent.BIG_INTEGER) {
                value = this.readBigIntegerFrom(modelReader);
            } else if (event == ModelEvent.BIG_DECIMAL) {
                value = this.readBigDecimalFrom(modelReader);
            } else if (event == ModelEvent.BYTES) {
                value = this.readBytesFrom(modelReader);
            } else if (event == ModelEvent.EXPRESSION) {
                value = this.readExpressionFrom(modelReader);
            } else if (event == ModelEvent.TYPE) {
                value = this.readTypeFrom(modelReader);
            } else if (event == ModelEvent.BOOLEAN) {
                value = this.readBooleanFrom(modelReader);
            } else if (event == ModelEvent.UNDEFINED) {
                value = this.readUndefinedFrom(modelReader);
            } else if (event == ModelEvent.OBJECT_START) {
                value = this.readObjectFrom(modelReader);
            } else if (event == ModelEvent.LIST_START) {
                value = this.readListFrom(modelReader);
            } else if (event == ModelEvent.PROPERTY_START) {
                value = this.readPropertyFrom(modelReader);
            } else {
                throw new IllegalStateException();
            }
            propertyNode.setNoCopy(key, value);
            event = modelReader.next();
        }
        return propertyNode;
    }
}

