/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.testenricher.cdi.client;

import java.util.Map;
import org.jboss.arquillian.container.spi.client.deployment.Validate;
import org.jboss.arquillian.container.test.spi.TestDeployment;
import org.jboss.arquillian.container.test.spi.client.deployment.ProtocolArchiveProcessor;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ArchivePath;
import org.jboss.shrinkwrap.api.Filters;
import org.jboss.shrinkwrap.api.GenericArchive;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.EmptyAsset;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.jboss.shrinkwrap.api.spec.WebArchive;

public class BeansXMLProtocolProcessor
implements ProtocolArchiveProcessor {
    public void process(TestDeployment testDeployment, Archive<?> protocolArchive) {
        if (testDeployment.getApplicationArchive().equals(protocolArchive)) {
            return;
        }
        if (this.containsBeansXML(testDeployment.getApplicationArchive())) {
            if (Validate.isArchiveOfType(WebArchive.class, protocolArchive)) {
                if (!protocolArchive.contains("WEB-INF/beans.xml")) {
                    ((WebArchive)protocolArchive.as(WebArchive.class)).addAsWebInfResource((Asset)EmptyAsset.INSTANCE, "beans.xml");
                }
            } else if (Validate.isArchiveOfType(JavaArchive.class, protocolArchive) && !protocolArchive.contains("META-INF/beans.xml")) {
                ((JavaArchive)protocolArchive.as(JavaArchive.class)).addAsManifestResource((Asset)EmptyAsset.INSTANCE, "beans.xml");
            }
        }
    }

    private boolean containsBeansXML(Archive<?> archive) {
        Map content = archive.getContent(Filters.include((String)".*/beans\\.xml"));
        if (!content.isEmpty()) {
            return true;
        }
        Map nested = archive.getContent(Filters.include((String)"/.*\\.(jar|war)"));
        if (!nested.isEmpty()) {
            for (ArchivePath path : nested.keySet()) {
                try {
                    if (!this.containsBeansXML(archive.getAsType(GenericArchive.class, path))) continue;
                    return true;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                }
            }
        }
        return false;
    }
}

