/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.junit5.container;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.jboss.arquillian.container.test.spi.TestRunner;
import org.jboss.arquillian.junit5.IdentifiedTestException;
import org.jboss.arquillian.test.spi.TestResult;
import org.junit.jupiter.engine.descriptor.MethodBasedTestDescriptor;
import org.junit.platform.commons.JUnitException;
import org.junit.platform.engine.DiscoverySelector;
import org.junit.platform.engine.Filter;
import org.junit.platform.engine.FilterResult;
import org.junit.platform.engine.TestExecutionResult;
import org.junit.platform.engine.discovery.DiscoverySelectors;
import org.junit.platform.launcher.Launcher;
import org.junit.platform.launcher.LauncherDiscoveryRequest;
import org.junit.platform.launcher.TestExecutionListener;
import org.junit.platform.launcher.TestIdentifier;
import org.junit.platform.launcher.TestPlan;
import org.junit.platform.launcher.core.LauncherDiscoveryRequestBuilder;
import org.junit.platform.launcher.core.LauncherFactory;
import org.opentest4j.TestAbortedException;

public class JUnitJupiterTestRunner
implements TestRunner {
    public TestResult execute(Class<?> testClass, String methodName) {
        TestResult testResult;
        ArquillianTestMethodExecutionListener listener = new ArquillianTestMethodExecutionListener();
        try {
            AtomicInteger matchCounter = new AtomicInteger(0);
            Launcher launcher = LauncherFactory.create();
            launcher.registerTestExecutionListeners(new TestExecutionListener[]{listener});
            LauncherDiscoveryRequest request = LauncherDiscoveryRequestBuilder.request().selectors(new DiscoverySelector[]{DiscoverySelectors.selectClass(testClass)}).configurationParameter("insideArquillian", "true").filters(new Filter[]{object -> {
                Method m;
                if (object instanceof MethodBasedTestDescriptor && (m = ((MethodBasedTestDescriptor)object).getTestMethod()).getName().equals(methodName)) {
                    matchCounter.incrementAndGet();
                    return FilterResult.included((String)"Matched method name");
                }
                return FilterResult.excluded((String)"Not matched");
            }}).build();
            TestPlan plan = launcher.discover(request);
            if (matchCounter.get() > 1) {
                throw new JUnitException("Method name must be unique");
            }
            if (!plan.containsTests()) {
                throw new JUnitException("No test method found");
            }
            launcher.execute(request, new TestExecutionListener[0]);
            testResult = listener.getTestResult();
        }
        catch (Throwable t) {
            testResult = TestResult.failed((Throwable)t);
        }
        testResult.setEnd(System.currentTimeMillis());
        return testResult;
    }

    private static class ArquillianTestMethodExecutionListener
    implements TestExecutionListener {
        private final Map<String, Throwable> exceptions = new HashMap<String, Throwable>();
        private Throwable fatalError;

        private ArquillianTestMethodExecutionListener() {
        }

        public void executionSkipped(TestIdentifier testIdentifier, String reason) {
            this.exceptions.put(testIdentifier.getUniqueId(), (Throwable)new TestAbortedException(reason));
        }

        public void executionFinished(TestIdentifier testIdentifier, TestExecutionResult testExecutionResult) {
            TestExecutionResult.Status status = testExecutionResult.getStatus();
            if (!testIdentifier.isTest()) {
                if (status != TestExecutionResult.Status.SUCCESSFUL) {
                    this.fatalError = testExecutionResult.getThrowable().orElseGet(() -> new Exception("Failed"));
                }
                return;
            }
            switch (status) {
                case FAILED: {
                    this.exceptions.put(testIdentifier.getUniqueId(), testExecutionResult.getThrowable().orElseGet(() -> new Exception("Failed")));
                    break;
                }
                case ABORTED: {
                    this.exceptions.put(testIdentifier.getUniqueId(), testExecutionResult.getThrowable().orElseGet(() -> new TestAbortedException("Aborted")));
                    break;
                }
            }
        }

        private TestResult getTestResult() {
            if (this.fatalError != null) {
                return TestResult.failed((Throwable)this.fatalError);
            }
            return this.exceptions.isEmpty() ? TestResult.passed() : TestResult.failed((Throwable)new IdentifiedTestException(this.exceptions));
        }
    }
}

