/*
 * Decompiled with CFR 0.152.
 */
package org.jbake.template;

import com.orientechnologies.orient.core.record.impl.ODocument;
import groovy.lang.GString;
import groovy.lang.Writable;
import groovy.text.SimpleTemplateEngine;
import groovy.text.Template;
import groovy.text.XmlTemplateEngine;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.configuration.CompositeConfiguration;
import org.codehaus.groovy.runtime.MethodClosure;
import org.jbake.app.ContentStore;
import org.jbake.app.DBUtil;
import org.jbake.app.DocumentList;
import org.jbake.model.DocumentTypes;
import org.jbake.template.AbstractTemplateEngine;
import org.jbake.template.RenderingException;
import org.xml.sax.SAXException;

public class GroovyTemplateEngine
extends AbstractTemplateEngine {
    private final Map<String, Template> cachedTemplates = new HashMap<String, Template>();

    public GroovyTemplateEngine(CompositeConfiguration config, ContentStore db, File destination, File templatesPath) {
        super(config, db, destination, templatesPath);
    }

    @Override
    public void renderDocument(Map<String, Object> model, String templateName, Writer writer) throws RenderingException {
        try {
            Template template = this.findTemplate(templateName);
            Writable writable = template.make(this.wrap(model));
            writable.writeTo(writer);
        }
        catch (Exception e) {
            throw new RenderingException(e);
        }
    }

    private Template findTemplate(String templateName) throws SAXException, ParserConfigurationException, ClassNotFoundException, IOException {
        XmlTemplateEngine ste = templateName.endsWith(".gxml") ? new XmlTemplateEngine() : new SimpleTemplateEngine();
        File sourceTemplate = new File(this.templatesPath, templateName);
        Template template = this.cachedTemplates.get(templateName);
        if (template == null) {
            template = ste.createTemplate((Reader)new InputStreamReader((InputStream)new BufferedInputStream(new FileInputStream(sourceTemplate)), this.config.getString("template.encoding")));
            this.cachedTemplates.put(templateName, template);
        }
        return template;
    }

    private Map<String, Object> wrap(final Map<String, Object> model) {
        return new HashMap<String, Object>(model){

            @Override
            public Object get(Object property) {
                if (property instanceof String || property instanceof GString) {
                    String[] documentTypes;
                    String key = property.toString();
                    if ("include".equals(key)) {
                        return new MethodClosure((Object)GroovyTemplateEngine.this, "doInclude").curry((Object)this);
                    }
                    if ("db".equals(key)) {
                        return GroovyTemplateEngine.this.db;
                    }
                    if ("published_posts".equals(key)) {
                        List<ODocument> query = GroovyTemplateEngine.this.db.getPublishedPosts();
                        return DocumentList.wrap(query.iterator());
                    }
                    if ("published_pages".equals(key)) {
                        List<ODocument> query = GroovyTemplateEngine.this.db.getPublishedPages();
                        return DocumentList.wrap(query.iterator());
                    }
                    if ("published_content".equals(key)) {
                        String[] documentTypes2;
                        ArrayList<ODocument> publishedContent = new ArrayList<ODocument>();
                        for (String docType : documentTypes2 = DocumentTypes.getDocumentTypes()) {
                            List<ODocument> query = GroovyTemplateEngine.this.db.getPublishedContent(docType);
                            publishedContent.addAll(query);
                        }
                        return DocumentList.wrap(publishedContent.iterator());
                    }
                    if ("all_content".equals(key)) {
                        String[] documentTypes3;
                        ArrayList<ODocument> allContent = new ArrayList<ODocument>();
                        for (String docType : documentTypes3 = DocumentTypes.getDocumentTypes()) {
                            List<ODocument> query = GroovyTemplateEngine.this.db.getAllContent(docType);
                            allContent.addAll(query);
                        }
                        return DocumentList.wrap(allContent.iterator());
                    }
                    if ("alltags".equals(key)) {
                        List<ODocument> query = GroovyTemplateEngine.this.db.getAllTagsFromPublishedPosts();
                        HashSet result = new HashSet();
                        for (ODocument document : query) {
                            String[] tags = DBUtil.toStringArray(document.field("tags"));
                            Collections.addAll(result, tags);
                        }
                        return result;
                    }
                    for (String docType : documentTypes = DocumentTypes.getDocumentTypes()) {
                        if (!(docType + "s").equals(key)) continue;
                        return DocumentList.wrap(GroovyTemplateEngine.this.db.getAllContent(docType).iterator());
                    }
                    if ("tag_posts".equals(key)) {
                        String tag = model.get("tag").toString();
                        List<ODocument> query = GroovyTemplateEngine.this.db.getPublishedPostsByTag(tag);
                        return DocumentList.wrap(query.iterator());
                    }
                    if ("published_date".equals(key)) {
                        return new Date();
                    }
                }
                return super.get(property);
            }
        };
    }

    private void doInclude(Map<String, Object> model, String templateName) throws Exception {
        AbstractTemplateEngine engine = (AbstractTemplateEngine)model.get("renderer");
        Writer out = (Writer)model.get("out");
        engine.renderDocument(model, templateName, out);
        model.put("out", out);
    }
}

