/*
 * Decompiled with CFR 0.152.
 */
package org.jbake.template;

import com.orientechnologies.orient.core.record.impl.ODocument;
import freemarker.template.Configuration;
import freemarker.template.DefaultObjectWrapper;
import freemarker.template.ObjectWrapper;
import freemarker.template.SimpleCollection;
import freemarker.template.SimpleDate;
import freemarker.template.SimpleHash;
import freemarker.template.SimpleSequence;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import freemarker.template.TemplateHashModel;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.configuration.CompositeConfiguration;
import org.jbake.app.ContentStore;
import org.jbake.app.DBUtil;
import org.jbake.app.DocumentList;
import org.jbake.model.DocumentTypes;
import org.jbake.template.AbstractTemplateEngine;
import org.jbake.template.RenderingException;

public class FreemarkerTemplateEngine
extends AbstractTemplateEngine {
    private Configuration templateCfg;

    public FreemarkerTemplateEngine(CompositeConfiguration config, ContentStore db, File destination, File templatesPath) {
        super(config, db, destination, templatesPath);
        this.createTemplateConfiguration(config, templatesPath);
    }

    private void createTemplateConfiguration(CompositeConfiguration config, File templatesPath) {
        this.templateCfg = new Configuration();
        this.templateCfg.setDefaultEncoding(config.getString("render.encoding"));
        try {
            this.templateCfg.setDirectoryForTemplateLoading(templatesPath);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.templateCfg.setObjectWrapper((ObjectWrapper)new DefaultObjectWrapper());
    }

    @Override
    public void renderDocument(Map<String, Object> model, String templateName, Writer writer) throws RenderingException {
        try {
            Template template = this.templateCfg.getTemplate(templateName);
            template.process((Object)new LazyLoadingModel(model, this.db), writer);
        }
        catch (IOException e) {
            throw new RenderingException(e);
        }
        catch (TemplateException e) {
            throw new RenderingException(e);
        }
    }

    public static class LazyLoadingModel
    implements TemplateHashModel {
        private final SimpleHash eagerModel;
        private final ContentStore db;

        public LazyLoadingModel(Map<String, Object> eagerModel, ContentStore db) {
            this.eagerModel = new SimpleHash(eagerModel);
            this.db = db;
        }

        public TemplateModel get(String key) throws TemplateModelException {
            String[] documentTypes;
            if ("published_posts".equals(key)) {
                List<ODocument> query = this.db.getPublishedPosts();
                return new SimpleSequence((Collection)DocumentList.wrap(query.iterator()));
            }
            if ("published_pages".equals(key)) {
                List<ODocument> query = this.db.getPublishedPages();
                return new SimpleSequence((Collection)DocumentList.wrap(query.iterator()));
            }
            if ("published_content".equals(key)) {
                String[] documentTypes2;
                ArrayList<ODocument> publishedContent = new ArrayList<ODocument>();
                for (String docType : documentTypes2 = DocumentTypes.getDocumentTypes()) {
                    List<ODocument> query = this.db.getPublishedContent(docType);
                    publishedContent.addAll(query);
                }
                return new SimpleSequence((Collection)DocumentList.wrap(publishedContent.iterator()));
            }
            if ("all_content".equals(key)) {
                String[] documentTypes3;
                ArrayList<ODocument> allContent = new ArrayList<ODocument>();
                for (String docType : documentTypes3 = DocumentTypes.getDocumentTypes()) {
                    List<ODocument> query = this.db.getAllContent(docType);
                    allContent.addAll(query);
                }
                return new SimpleSequence((Collection)DocumentList.wrap(allContent.iterator()));
            }
            if ("alltags".equals(key)) {
                List<ODocument> query = this.db.getAllTagsFromPublishedPosts();
                HashSet result = new HashSet();
                for (ODocument document : query) {
                    String[] tags = DBUtil.toStringArray(document.field("tags"));
                    Collections.addAll(result, tags);
                }
                return new SimpleCollection(result);
            }
            for (String docType : documentTypes = DocumentTypes.getDocumentTypes()) {
                if (!(docType + "s").equals(key)) continue;
                return new SimpleSequence((Collection)DocumentList.wrap(this.db.getAllContent(docType).iterator()));
            }
            if ("tag_posts".equals(key)) {
                String tag = this.eagerModel.get("tag").toString();
                List<ODocument> query = this.db.getPublishedPostsByTag(tag);
                return new SimpleSequence((Collection)DocumentList.wrap(query.iterator()));
            }
            if ("published_date".equals(key)) {
                return new SimpleDate(new Date(), 0);
            }
            return this.eagerModel.get(key);
        }

        public boolean isEmpty() throws TemplateModelException {
            return false;
        }
    }
}

