/*
 * Decompiled with CFR 0.152.
 */
package org.jbake.template;

import java.io.File;
import java.io.Writer;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.configuration.CompositeConfiguration;
import org.jbake.app.ContentStore;
import org.jbake.app.FileUtil;
import org.jbake.template.AbstractTemplateEngine;
import org.jbake.template.RenderingException;
import org.jbake.template.TemplateEngines;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DelegatingTemplateEngine
extends AbstractTemplateEngine {
    private static final Logger LOGGER = LoggerFactory.getLogger(DelegatingTemplateEngine.class);
    private final TemplateEngines renderers;

    public DelegatingTemplateEngine(CompositeConfiguration config, ContentStore db, File destination, File templatesPath) {
        super(config, db, destination, templatesPath);
        this.renderers = new TemplateEngines(config, db, destination, templatesPath);
    }

    @Override
    public void renderDocument(Map<String, Object> model, String templateName, Writer writer) throws RenderingException {
        String ext;
        AbstractTemplateEngine engine;
        model.put("version", this.config.getString("version"));
        model.put("baked_timestamp", new Date());
        HashMap<String, Object> configModel = new HashMap<String, Object>();
        Iterator configKeys = this.config.getKeys();
        while (configKeys.hasNext()) {
            String key = (String)configKeys.next();
            configModel.put(key.replace(".", "_"), this.config.getProperty(key));
        }
        model.put("config", configModel);
        File templateFile = new File(this.templatesPath, templateName);
        if (!templateFile.exists()) {
            LOGGER.info("Default template: {} was not found, searching for others...", (Object)templateName);
            String templateNameWithoutExt = templateName.substring(0, templateName.length() - 4);
            for (String extension : this.renderers.getRecognizedExtensions()) {
                templateFile = new File(this.templatesPath, templateNameWithoutExt + "." + extension);
                if (!templateFile.exists()) continue;
                LOGGER.info("Found alternative template file: {} using this instead", (Object)templateFile.getName());
                templateName = templateFile.getName();
                break;
            }
        }
        if ((engine = this.renderers.getEngine(ext = FileUtil.fileExt(templateName))) != null) {
            engine.renderDocument(model, templateName, writer);
        } else {
            LOGGER.error("Warning - No template engine found for template: {}", (Object)templateName);
        }
    }
}

