/*
 * Decompiled with CFR 0.152.
 */
package org.jbake.parser;

import java.io.IOException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.jbake.parser.ErrorEngine;
import org.jbake.parser.MarkupEngine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Engines {
    private static final Logger LOGGER = LoggerFactory.getLogger(Engines.class);
    private static final Engines INSTANCE = new Engines();
    private final Map<String, MarkupEngine> parsers = new HashMap<String, MarkupEngine>();

    public static MarkupEngine get(String fileExtension) {
        return INSTANCE.getEngine(fileExtension);
    }

    public static void register(String fileExtension, MarkupEngine engine) {
        INSTANCE.registerEngine(fileExtension, engine);
    }

    public static Set<String> getRecognizedExtensions() {
        return Collections.unmodifiableSet(Engines.INSTANCE.parsers.keySet());
    }

    private Engines() {
    }

    private void registerEngine(String fileExtension, MarkupEngine markupEngine) {
        MarkupEngine old = this.parsers.put(fileExtension, markupEngine);
        if (old != null) {
            LOGGER.warn("Registered a markup engine for extension [.{}] but another one was already defined: {}", (Object)fileExtension, (Object)old);
        }
    }

    private MarkupEngine getEngine(String fileExtension) {
        return this.parsers.get(fileExtension);
    }

    private static MarkupEngine tryLoadEngine(String engineClassName) {
        try {
            Class<?> engineClass = Class.forName(engineClassName, false, Engines.class.getClassLoader());
            return (MarkupEngine)engineClass.newInstance();
        }
        catch (ClassNotFoundException e) {
            return new ErrorEngine(engineClassName);
        }
        catch (InstantiationException e) {
            return new ErrorEngine(engineClassName);
        }
        catch (IllegalAccessException e) {
            return new ErrorEngine(engineClassName);
        }
        catch (NoClassDefFoundError e) {
            return new ErrorEngine(engineClassName);
        }
    }

    private static void loadEngines() {
        try {
            ClassLoader cl = Engines.class.getClassLoader();
            Enumeration<URL> resources = cl.getResources("META-INF/org.jbake.parser.MarkupEngines.properties");
            while (resources.hasMoreElements()) {
                URL url = resources.nextElement();
                Properties props = new Properties();
                props.load(url.openStream());
                for (Map.Entry<Object, Object> entry : props.entrySet()) {
                    String className = (String)entry.getKey();
                    String[] extensions = ((String)entry.getValue()).split(",");
                    Engines.registerEngine(className, extensions);
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void registerEngine(String className, String ... extensions) {
        MarkupEngine engine = Engines.tryLoadEngine(className);
        if (engine != null) {
            for (String extension : extensions) {
                Engines.register(extension, engine);
            }
            if (engine instanceof ErrorEngine) {
                LOGGER.warn("Unable to load a suitable rendering engine for extensions {}", (Object)Arrays.toString(extensions));
            }
        }
    }

    static {
        Engines.loadEngines();
    }
}

