/*
 * Decompiled with CFR 0.152.
 */
package org.jbake.app;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.apache.commons.configuration.CompositeConfiguration;
import org.jbake.app.ContentStore;
import org.jbake.app.FileUtil;
import org.jbake.template.DelegatingTemplateEngine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Renderer {
    private static final Logger LOGGER = LoggerFactory.getLogger(Renderer.class);
    private File destination;
    private CompositeConfiguration config;
    private final DelegatingTemplateEngine renderingEngine;

    public Renderer(ContentStore db, File destination, File templatesPath, CompositeConfiguration config) {
        this.destination = destination;
        this.config = config;
        this.renderingEngine = new DelegatingTemplateEngine(config, db, destination, templatesPath);
    }

    private String findTemplateName(String docType) {
        return this.config.getString("template." + docType + ".file");
    }

    public void render(Map<String, Object> content) throws Exception {
        File publishedFile;
        String docType = (String)content.get("type");
        String outputFilename = this.destination.getPath() + File.separatorChar + (String)content.get("uri");
        File draftFile = new File((outputFilename = outputFilename.substring(0, outputFilename.lastIndexOf("."))) + this.config.getString("draft.suffix") + FileUtil.findExtension(this.config, docType));
        if (draftFile.exists()) {
            draftFile.delete();
        }
        if ((publishedFile = new File(outputFilename + FileUtil.findExtension(this.config, docType))).exists()) {
            publishedFile.delete();
        }
        if (content.get("status").equals("draft")) {
            outputFilename = outputFilename + this.config.getString("draft.suffix");
        }
        File outputFile = new File(outputFilename + FileUtil.findExtension(this.config, docType));
        StringBuilder sb = new StringBuilder();
        sb.append("Rendering [").append(outputFile).append("]... ");
        HashMap<String, Object> model = new HashMap<String, Object>();
        model.put("content", content);
        model.put("renderer", this.renderingEngine);
        try {
            Writer out = this.createWriter(outputFile);
            this.renderingEngine.renderDocument(model, this.findTemplateName(docType), out);
            out.close();
            sb.append("done!");
            LOGGER.info(sb.toString());
        }
        catch (Exception e) {
            sb.append("failed!");
            LOGGER.error(sb.toString(), (Throwable)e);
            throw new Exception("Failed to render file. Cause: " + e.getMessage());
        }
    }

    private Writer createWriter(File file) throws IOException {
        if (!file.exists()) {
            file.getParentFile().mkdirs();
            file.createNewFile();
        }
        return new OutputStreamWriter((OutputStream)new FileOutputStream(file), this.config.getString("render.encoding"));
    }

    public void renderIndex(String indexFile) throws Exception {
        File outputFile = new File(this.destination.getPath() + File.separator + indexFile);
        StringBuilder sb = new StringBuilder();
        sb.append("Rendering index [").append(outputFile).append("]...");
        HashMap<String, Object> model = new HashMap<String, Object>();
        model.put("renderer", this.renderingEngine);
        model.put("content", this.buildSimpleModel("masterindex"));
        try {
            Writer out = this.createWriter(outputFile);
            this.renderingEngine.renderDocument(model, this.findTemplateName("masterindex"), out);
            out.close();
            sb.append("done!");
            LOGGER.info(sb.toString());
        }
        catch (Exception e) {
            sb.append("failed!");
            LOGGER.error(sb.toString(), (Throwable)e);
            throw new Exception("Failed to render index. Cause: " + e.getMessage());
        }
    }

    public void renderSitemap(String sitemapFile) throws Exception {
        File outputFile = new File(this.destination.getPath() + File.separator + sitemapFile);
        StringBuilder sb = new StringBuilder();
        sb.append("Rendering sitemap [").append(outputFile).append("]... ");
        HashMap<String, Object> model = new HashMap<String, Object>();
        model.put("renderer", this.renderingEngine);
        model.put("content", this.buildSimpleModel("sitemap"));
        try {
            Writer out = this.createWriter(outputFile);
            this.renderingEngine.renderDocument(model, this.findTemplateName("sitemap"), out);
            sb.append("done!");
            out.close();
            LOGGER.info(sb.toString());
        }
        catch (Exception e) {
            sb.append("failed!");
            LOGGER.error(sb.toString(), (Throwable)e);
            throw new Exception("Failed to render sitemap. Cause: " + e.getMessage());
        }
    }

    public void renderFeed(String feedFile) throws Exception {
        File outputFile = new File(this.destination.getPath() + File.separator + feedFile);
        StringBuilder sb = new StringBuilder();
        sb.append("Rendering feed [").append(outputFile).append("]... ");
        HashMap<String, Object> model = new HashMap<String, Object>();
        model.put("renderer", this.renderingEngine);
        model.put("content", this.buildSimpleModel("feed"));
        try {
            Writer out = this.createWriter(outputFile);
            this.renderingEngine.renderDocument(model, this.findTemplateName("feed"), out);
            out.close();
            sb.append("done!");
            LOGGER.info(sb.toString());
        }
        catch (Exception e) {
            sb.append("failed!");
            LOGGER.error(sb.toString(), (Throwable)e);
            throw new Exception("Failed to render feed. Cause: " + e.getMessage());
        }
    }

    public void renderArchive(String archiveFile) throws Exception {
        File outputFile = new File(this.destination.getPath() + File.separator + archiveFile);
        StringBuilder sb = new StringBuilder();
        sb.append("Rendering archive [").append(outputFile).append("]... ");
        HashMap<String, Object> model = new HashMap<String, Object>();
        model.put("renderer", this.renderingEngine);
        model.put("content", this.buildSimpleModel("archive"));
        try {
            Writer out = this.createWriter(outputFile);
            this.renderingEngine.renderDocument(model, this.findTemplateName("archive"), out);
            out.close();
            sb.append("done!");
            LOGGER.info(sb.toString());
        }
        catch (Exception e) {
            sb.append("failed!");
            LOGGER.error(sb.toString(), (Throwable)e);
            throw new Exception("Failed to render archive. Cause: " + e.getMessage());
        }
    }

    public void renderTags(Set<String> tags, String tagPath) throws Exception {
        LinkedList<String> errors = new LinkedList<String>();
        for (String tag : tags) {
            HashMap<String, Object> model = new HashMap<String, Object>();
            model.put("renderer", this.renderingEngine);
            model.put("tag", tag);
            Map<String, Object> map = this.buildSimpleModel("tag");
            map.put("rootpath", "../");
            model.put("content", map);
            File outputFile = new File(this.destination.getPath() + File.separator + tagPath + File.separator + tag + this.config.getString("output.extension"));
            StringBuilder sb = new StringBuilder();
            sb.append("Rendering tags [").append(outputFile).append("]... ");
            try {
                Writer out = this.createWriter(outputFile);
                this.renderingEngine.renderDocument(model, this.findTemplateName("tag"), out);
                out.close();
                sb.append("done!");
                LOGGER.info(sb.toString());
            }
            catch (Exception e) {
                sb.append("failed!");
                LOGGER.error(sb.toString(), (Throwable)e);
                errors.add(e.getMessage());
            }
        }
        if (!errors.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            sb.append("Failed to render tags. Cause(s):");
            for (String error : errors) {
                sb.append("\n" + error);
            }
            throw new Exception(sb.toString());
        }
    }

    private Map<String, Object> buildSimpleModel(String type) {
        HashMap<String, Object> content = new HashMap<String, Object>();
        content.put("type", type);
        content.put("rootpath", "");
        return content;
    }
}

