/*
 * Decompiled with CFR 0.152.
 */
package org.jbake.app;

import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLDecoder;
import java.security.MessageDigest;
import org.apache.commons.configuration.CompositeConfiguration;
import org.jbake.parser.Engines;

public class FileUtil {
    public static FileFilter getFileFilter() {
        return new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return !pathname.isFile() || Engines.getRecognizedExtensions().contains(FileUtil.fileExt(pathname));
            }
        };
    }

    public static boolean isExistingFolder(File f) {
        return null != f && f.exists() && f.isDirectory();
    }

    public static File getRunningLocation() throws Exception {
        String codePath = FileUtil.class.getProtectionDomain().getCodeSource().getLocation().getPath();
        String decodedPath = URLDecoder.decode(codePath, "UTF-8");
        File codeFile = new File(decodedPath);
        if (!codeFile.exists()) {
            throw new Exception("Cannot locate running location of JBake!");
        }
        File codeFolder = codeFile.getParentFile();
        if (!codeFolder.exists()) {
            throw new Exception("Cannot locate running location of JBake!");
        }
        return codeFolder;
    }

    public static String fileExt(File src) {
        String name = src.getName();
        return FileUtil.fileExt(name);
    }

    public static String fileExt(String name) {
        int idx = name.lastIndexOf(46);
        if (idx > 0) {
            return name.substring(idx + 1);
        }
        return "";
    }

    public static String sha1(File sourceFile) throws Exception {
        byte[] buffer = new byte[1024];
        MessageDigest complete = MessageDigest.getInstance("SHA-1");
        FileUtil.updateDigest(complete, sourceFile, buffer);
        byte[] bytes = complete.digest();
        StringBuilder sb = new StringBuilder();
        for (byte b : bytes) {
            sb.append(String.format("%02x", b));
        }
        return sb.toString();
    }

    private static void updateDigest(MessageDigest digest, File sourceFile, byte[] buffer) throws IOException {
        File[] files;
        if (sourceFile.isFile()) {
            int numRead;
            FileInputStream fis = new FileInputStream(sourceFile);
            do {
                if ((numRead = ((InputStream)fis).read(buffer)) <= 0) continue;
                digest.update(buffer, 0, numRead);
            } while (numRead != -1);
            ((InputStream)fis).close();
        } else if (sourceFile.isDirectory() && (files = sourceFile.listFiles()) != null) {
            for (File file : files) {
                FileUtil.updateDigest(digest, file, buffer);
            }
        }
    }

    public static String findExtension(CompositeConfiguration config, String docType) {
        String extension = config.getString("template." + docType + ".extension");
        if (extension != null) {
            return extension;
        }
        return config.getString("output.extension");
    }

    public static String asPath(File file) {
        if (file == null) {
            return null;
        }
        return FileUtil.asPath(file.getPath());
    }

    public static String asPath(String path) {
        if (path == null) {
            return null;
        }
        return path.replace(File.separator, "/");
    }
}

