/*
 * Decompiled with CFR 0.152.
 */
package org.javasimon.spring;

import java.util.ArrayList;
import java.util.List;
import org.javasimon.Manager;
import org.javasimon.SimonManager;
import org.javasimon.SwitchingManager;
import org.javasimon.callback.Callback;
import org.springframework.beans.factory.FactoryBean;

public class ManagerFactoryBean
implements FactoryBean<Manager> {
    private boolean singleton = true;
    private List<Callback> callbacks = new ArrayList<Callback>();
    private boolean enabled = true;

    public Manager getObject() throws Exception {
        Object manager = this.singleton ? SimonManager.manager() : new SwitchingManager();
        this.registerCallbacks((Manager)manager);
        this.configureEnabled((Manager)manager);
        return manager;
    }

    public Class<Manager> getObjectType() {
        return Manager.class;
    }

    public boolean isSingleton() {
        return this.singleton;
    }

    public void setSingleton(boolean singleton) {
        this.singleton = singleton;
    }

    private void registerCallbacks(Manager manager) {
        if (this.callbacks != null) {
            for (Callback callback : this.callbacks) {
                manager.callback().addCallback(callback);
            }
        }
    }

    public List<Callback> getCallbacks() {
        return this.callbacks;
    }

    public void setCallbacks(List<Callback> callbacks) {
        this.callbacks = callbacks;
    }

    private void configureEnabled(Manager manager) {
        if (this.enabled != manager.isEnabled()) {
            if (this.enabled) {
                manager.enable();
            } else {
                manager.disable();
            }
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }
}

