/*
 * Decompiled with CFR 0.152.
 */
package org.javasimon.javaee.reqreporter;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import javax.servlet.http.HttpServletRequest;
import org.javasimon.Split;
import org.javasimon.javaee.SimonServletFilter;
import org.javasimon.javaee.reqreporter.ReporterStopwatchInfo;
import org.javasimon.javaee.reqreporter.RequestReporter;
import org.javasimon.utils.SimonUtils;

public class DefaultRequestReporter
implements RequestReporter {
    private static final int NOTE_OUTPUT_MAX_LEN = 80;
    private SimonServletFilter simonServletFilter;

    @Override
    public void reportRequest(HttpServletRequest request, Split requestSplit, List<Split> splits) {
        StringBuilder messageBuilder = new StringBuilder("Web request is too long (" + SimonUtils.presentNanoTime((long)requestSplit.runningFor()) + ") [" + requestSplit.getStopwatch().getNote() + "]");
        if (splits.size() > 0) {
            this.buildSplitDetails(requestSplit, splits, messageBuilder);
        }
        this.reportMessage(messageBuilder.toString());
    }

    protected void reportMessage(String message) {
        this.simonServletFilter.getManager().message(message);
    }

    private void buildSplitDetails(Split requestSplit, List<Split> splits, StringBuilder messageBuilder) {
        HashMap<String, ReporterStopwatchInfo> stopwatchInfos = new HashMap<String, ReporterStopwatchInfo>();
        this.processSplitsAndAddSignificantOnes(requestSplit, splits, messageBuilder, stopwatchInfos);
        this.addStopwatchSplitDistribution(messageBuilder, stopwatchInfos);
    }

    private void processSplitsAndAddSignificantOnes(Split requestSplit, List<Split> splits, StringBuilder messageBuilder, Map<String, ReporterStopwatchInfo> stopwatchInfos) {
        for (Split split : splits) {
            ReporterStopwatchInfo stopwatchInfo = stopwatchInfos.get(split.getStopwatch().getName());
            if (stopwatchInfo == null) {
                stopwatchInfo = new ReporterStopwatchInfo(split.getStopwatch());
                stopwatchInfos.put(split.getStopwatch().getName(), stopwatchInfo);
            }
            stopwatchInfo.addSplit(split);
            if (!this.isSignificantSplit(split, requestSplit)) continue;
            messageBuilder.append("\n\t").append(split.getStopwatch().getName()).append(": ").append(SimonUtils.presentNanoTime((long)split.runningFor()));
        }
    }

    protected boolean isSignificantSplit(Split split, Split requestSplit) {
        return split.runningFor() > requestSplit.runningFor() / 20L;
    }

    private void addStopwatchSplitDistribution(StringBuilder messageBuilder, Map<String, ReporterStopwatchInfo> stopwatchInfos) {
        messageBuilder.append("\nStopwatch/Split count/total/max for this request (sorted by total descending):");
        TreeSet<ReporterStopwatchInfo> sortedInfos = new TreeSet<ReporterStopwatchInfo>(stopwatchInfos.values());
        for (ReporterStopwatchInfo info : sortedInfos) {
            if (!this.shouldBeAddedStopwatchInfo(info)) continue;
            this.addStopwatchInfo(messageBuilder, info);
        }
    }

    protected boolean shouldBeAddedStopwatchInfo(ReporterStopwatchInfo info) {
        return true;
    }

    private void addStopwatchInfo(StringBuilder messageBuilder, ReporterStopwatchInfo info) {
        messageBuilder.append("\n\t").append(info.stopwatch.getName()).append(": ").append(info.splits.size()).append("x, total: ").append(SimonUtils.presentNanoTime((long)info.total)).append(", max: ").append(SimonUtils.presentNanoTime((long)info.maxSplit.runningFor()));
        if (info.stopwatch.getNote() != null) {
            messageBuilder.append(", note: ").append(SimonUtils.compact((String)info.stopwatch.getNote(), (int)80));
        }
    }

    @Override
    public void setSimonServletFilter(SimonServletFilter simonServletFilter) {
        this.simonServletFilter = simonServletFilter;
    }
}

