/*
 * Decompiled with CFR 0.152.
 */
package org.javasimon.callback.quantiles;

import org.javasimon.Split;
import org.javasimon.Stopwatch;
import org.javasimon.StopwatchSample;
import org.javasimon.callback.CallbackSkeleton;
import org.javasimon.callback.logging.LogTemplate;
import org.javasimon.callback.logging.LogTemplates;
import org.javasimon.callback.quantiles.Buckets;
import org.javasimon.callback.quantiles.BucketsSample;
import org.javasimon.callback.quantiles.BucketsType;

public abstract class QuantilesCallback
extends CallbackSkeleton {
    public static final String ATTR_NAME_BUCKETS = "buckets";
    private final LogTemplate<Split> enabledStopwatchLogTemplate = LogTemplates.toSLF4J(this.getClass().getName(), "debug");
    private boolean logEnabled = false;
    private BucketsType bucketsType;

    protected QuantilesCallback() {
        this.bucketsType = BucketsType.LINEAR;
    }

    protected QuantilesCallback(BucketsType bucketsType) {
        this.bucketsType = bucketsType;
    }

    public BucketsType getBucketsType() {
        return this.bucketsType;
    }

    public boolean isLogEnabled() {
        return this.logEnabled;
    }

    public void setLogEnabled(boolean logEnabled) {
        this.logEnabled = logEnabled;
    }

    protected LogTemplate<Split> createLogTemplate(Stopwatch stopwatch) {
        LogTemplate<Split> logTemplate = this.logEnabled ? LogTemplates.everyNSeconds(this.enabledStopwatchLogTemplate, 60L) : LogTemplates.disabled();
        return logTemplate;
    }

    public static Buckets getBuckets(Stopwatch stopwatch) {
        return (Buckets)stopwatch.getAttribute(ATTR_NAME_BUCKETS);
    }

    protected final Buckets createBuckets(Stopwatch stopwatch, long min, long max, int bucketNb) {
        Buckets buckets = this.bucketsType.createBuckets(stopwatch, min, max, bucketNb);
        buckets.setLogTemplate(this.createLogTemplate(stopwatch));
        return buckets;
    }

    protected abstract Buckets createBuckets(Stopwatch var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final Buckets getOrCreateBuckets(Stopwatch stopwatch) {
        Stopwatch stopwatch2 = stopwatch;
        synchronized (stopwatch2) {
            Buckets buckets = QuantilesCallback.getBuckets(stopwatch);
            if (buckets == null) {
                buckets = this.createBuckets(stopwatch);
                stopwatch.setAttribute(ATTR_NAME_BUCKETS, buckets);
            }
            return buckets;
        }
    }

    public static BucketsSample sampleBuckets(Stopwatch stopwatch) {
        Buckets buckets = QuantilesCallback.getBuckets(stopwatch);
        return buckets == null ? null : buckets.sample();
    }

    protected void onStopwatchSplit(Stopwatch stopwatch, Split split) {
        Buckets buckets = this.getOrCreateBuckets(stopwatch);
        if (buckets != null) {
            buckets.addValue(split.runningFor());
            buckets.log(split);
        }
    }

    @Override
    public void onStopwatchStop(Split split, StopwatchSample sample) {
        this.onStopwatchSplit(split.getStopwatch(), split);
    }

    @Override
    public void onStopwatchAdd(Stopwatch stopwatch, Split split, StopwatchSample sample) {
        this.onStopwatchSplit(split.getStopwatch(), split);
    }
}

