/*
 * Decompiled with CFR 0.152.
 */
package org.javasimon.callback.quantiles;

import java.util.Properties;
import org.javasimon.Simon;
import org.javasimon.Stopwatch;
import org.javasimon.callback.quantiles.Buckets;
import org.javasimon.callback.quantiles.BucketsType;
import org.javasimon.callback.quantiles.QuantilesCallback;

public class PropertiesQuantilesCallback
extends QuantilesCallback {
    private final Properties properties;
    private final PropertyType<Long> longPropertyType = new PropertyType<Long>(){

        @Override
        public Long parse(String s) {
            Long l;
            try {
                l = Long.valueOf(s);
            }
            catch (NumberFormatException numberFormatException) {
                l = null;
            }
            return l;
        }
    };
    private final PropertyType<Integer> integerPropertyType = new PropertyType<Integer>(){

        @Override
        public Integer parse(String s) {
            Integer l;
            try {
                l = Integer.valueOf(s);
            }
            catch (NumberFormatException numberFormatException) {
                l = null;
            }
            return l;
        }
    };
    private final EnumPropertyType<BucketsType> bucketsTypeEnumPropertyType = new EnumPropertyType<BucketsType>(BucketsType.class){

        @Override
        public BucketsType get(Simon simon, String name) {
            BucketsType type = (BucketsType)((Object)super.get(simon, name));
            if (type == null) {
                type = BucketsType.LINEAR;
            }
            return type;
        }
    };

    public PropertiesQuantilesCallback(Properties properties) {
        this.properties = properties;
    }

    @Override
    protected Buckets createBuckets(Stopwatch stopwatch) {
        BucketsType type = (BucketsType)((Object)this.bucketsTypeEnumPropertyType.get(stopwatch, "type"));
        Long min = this.longPropertyType.get(stopwatch, "min");
        Long max = this.longPropertyType.get(stopwatch, "max");
        Integer nb = this.integerPropertyType.get(stopwatch, "nb");
        Buckets buckets = type.createBuckets(stopwatch, min, max, nb);
        buckets.setLogTemplate(this.createLogTemplate(stopwatch));
        return buckets;
    }

    private String getProperty(Simon simon, String name) {
        return this.properties.getProperty(simon.getName() + "." + name);
    }

    private static String cleanString(String s) {
        if (s != null && (s = s.trim()).equals("")) {
            s = null;
        }
        return s;
    }

    private class EnumPropertyType<E extends Enum<E>>
    extends PropertyType<E> {
        private final Class<E> enumClass;

        private EnumPropertyType(Class<E> enumClass) {
            this.enumClass = enumClass;
        }

        @Override
        public E parse(String s) {
            E e;
            try {
                e = Enum.valueOf(this.enumClass, s.toUpperCase());
            }
            catch (IllegalArgumentException exc) {
                e = null;
            }
            return e;
        }
    }

    private abstract class PropertyType<T> {
        private PropertyType() {
        }

        public abstract T parse(String var1);

        public T get(Simon simon, String name) {
            T result = null;
            for (Simon currentSimon = simon; result == null && currentSimon != null; currentSimon = currentSimon.getParent()) {
                String s = PropertiesQuantilesCallback.this.getProperty(currentSimon, name);
                if ((s = PropertiesQuantilesCallback.cleanString(s)) == null) continue;
                result = this.parse(s);
            }
            return result;
        }
    }
}

