/*
 * Decompiled with CFR 0.152.
 */
package org.javasimon.callback.quantiles;

import org.javasimon.callback.quantiles.Bucket;
import org.javasimon.callback.quantiles.Buckets;

public class ExponentialBuckets
extends Buckets {
    private final double power;
    private final double logMin;

    public ExponentialBuckets(long min, long max, int bucketNb) {
        super(min, max, bucketNb);
        this.logMin = Math.log(this.min);
        this.power = (Math.log(this.max) - this.logMin) / (double)bucketNb;
        long currentMax = this.min;
        for (int i = 1; i <= bucketNb; ++i) {
            long currentMin = currentMax;
            currentMax = Math.round(Math.exp(this.power * (double)i)) * this.min;
            this.buckets[i] = new Bucket(currentMin, currentMax);
        }
    }

    @Override
    protected Bucket getBucketForValue(long value) {
        Bucket bucket;
        if (value >= this.max) {
            bucket = this.buckets[this.bucketNb + 1];
        } else if (value < this.min) {
            bucket = this.buckets[0];
        } else {
            int idx = (int)Math.floor((Math.log(value) - this.logMin) / this.power) + 1;
            bucket = this.buckets[idx];
            if (value >= bucket.getMax()) {
                bucket = this.buckets[idx + 1];
            }
        }
        return bucket;
    }

    @Override
    protected double estimateQuantile(Bucket bucket, double expectedCount, double lastCount) {
        return (double)bucket.getMin() + (double)(bucket.getMax() - bucket.getMin()) * Math.exp(Math.log(expectedCount - lastCount) / Math.log(bucket.getCount()));
    }
}

