/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.services.persondir.support;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.Validate;
import org.jasig.services.persondir.IPersonAttributeDao;
import org.jasig.services.persondir.IPersonAttributes;
import org.jasig.services.persondir.support.AbstractDefaultAttributePersonAttributeDao;
import org.jasig.services.persondir.support.merger.IAttributeMerger;
import org.jasig.services.persondir.support.merger.MultivaluedAttributeMerger;
import org.springframework.beans.factory.annotation.Required;

public abstract class AbstractAggregatingDefaultQueryPersonAttributeDao
extends AbstractDefaultAttributePersonAttributeDao {
    protected List<IPersonAttributeDao> personAttributeDaos;
    protected IAttributeMerger attrMerger = new MultivaluedAttributeMerger();
    protected boolean recoverExceptions = true;
    protected boolean stopOnSuccess = false;

    public Set<IPersonAttributes> getPeopleWithMultivaluedAttributes(Map<String, List<Object>> query) {
        Validate.notNull(query, (String)"query may not be null.");
        Set<IPersonAttributes> resultPeople = null;
        boolean isFirstQuery = true;
        if (this.personAttributeDaos == null) {
            throw new IllegalStateException("personAttributeDaos must be set");
        }
        for (IPersonAttributeDao currentlyConsidering : this.personAttributeDaos) {
            boolean handledException = false;
            Set<IPersonAttributes> currentPeople = null;
            try {
                currentPeople = this.getAttributesFromDao(query, isFirstQuery, currentlyConsidering, resultPeople);
                isFirstQuery = false;
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Retrieved attributes='" + currentPeople + "' for query='" + query + "', isFirstQuery=" + isFirstQuery + ", currentlyConsidering='" + currentlyConsidering + "', resultAttributes='" + resultPeople + "'"));
                }
            }
            catch (RuntimeException rte) {
                if (this.recoverExceptions) {
                    handledException = true;
                    this.logger.warn((Object)("Recovering From Exception thrown by '" + currentlyConsidering + "'"), (Throwable)rte);
                }
                this.logger.error((Object)("Failing From Exception thrown by '" + currentlyConsidering + "'"), (Throwable)rte);
                throw rte;
            }
            if (currentPeople != null) {
                resultPeople = resultPeople == null ? new LinkedHashSet<IPersonAttributes>(currentPeople) : this.attrMerger.mergeResults(resultPeople, currentPeople);
            }
            if (!this.stopOnSuccess || handledException) continue;
            if (!this.logger.isDebugEnabled()) break;
            this.logger.debug((Object)"Successfully retrieved attributes from a child DAO and stopOnSuccess is true, stopping iteration of child DAOs");
            break;
        }
        if (resultPeople == null) {
            return null;
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Aggregated search results '" + resultPeople + "' for query='" + query + "'"));
        }
        return Collections.unmodifiableSet(resultPeople);
    }

    protected abstract Set<IPersonAttributes> getAttributesFromDao(Map<String, List<Object>> var1, boolean var2, IPersonAttributeDao var3, Set<IPersonAttributes> var4);

    public final Set<String> getPossibleUserAttributeNames() {
        Set<String> attrNames = null;
        for (IPersonAttributeDao currentDao : this.personAttributeDaos) {
            boolean handledException = false;
            Set currentDaoAttrNames = null;
            try {
                currentDaoAttrNames = currentDao.getPossibleUserAttributeNames();
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Retrieved possible attribute names '" + currentDaoAttrNames + "' from '" + currentDao + "'"));
                }
            }
            catch (RuntimeException rte) {
                if (this.recoverExceptions) {
                    handledException = true;
                    this.logger.warn((Object)("Recovering From Exception thrown by '" + currentDao + "'"), (Throwable)rte);
                }
                this.logger.error((Object)("Failing From Exception thrown by '" + currentDao + "'"), (Throwable)rte);
                throw rte;
            }
            if (currentDaoAttrNames != null) {
                if (attrNames == null) {
                    attrNames = new LinkedHashSet<String>();
                }
                attrNames = this.attrMerger.mergePossibleUserAttributeNames(attrNames, currentDaoAttrNames);
            }
            if (!this.stopOnSuccess || handledException) continue;
            if (!this.logger.isDebugEnabled()) break;
            this.logger.debug((Object)"Successfully retrieved possible user attributes from a child DAO and stopOnSuccess is true, stopping iteration of child DAOs");
            break;
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Aggregated possible attribute names '" + attrNames + "'"));
        }
        if (attrNames == null) {
            return null;
        }
        return Collections.unmodifiableSet(attrNames);
    }

    public Set<String> getAvailableQueryAttributes() {
        Set<String> queryAttrs = null;
        for (IPersonAttributeDao currentDao : this.personAttributeDaos) {
            boolean handledException = false;
            Set currentDaoQueryAttrs = null;
            try {
                currentDaoQueryAttrs = currentDao.getAvailableQueryAttributes();
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Retrieved possible query attributes '" + currentDaoQueryAttrs + "' from '" + currentDao + "'"));
                }
            }
            catch (RuntimeException rte) {
                if (this.recoverExceptions) {
                    handledException = true;
                    this.logger.warn((Object)("Recovering From Exception thrown by '" + currentDao + "'"), (Throwable)rte);
                }
                this.logger.error((Object)("Failing From Exception thrown by '" + currentDao + "'"), (Throwable)rte);
                throw rte;
            }
            if (currentDaoQueryAttrs != null) {
                if (queryAttrs == null) {
                    queryAttrs = new LinkedHashSet<String>();
                }
                queryAttrs = this.attrMerger.mergeAvailableQueryAttributes(queryAttrs, currentDaoQueryAttrs);
            }
            if (!this.stopOnSuccess || handledException) continue;
            if (!this.logger.isDebugEnabled()) break;
            this.logger.debug((Object)"Successfully retrieved available query attributes from a child DAO and stopOnSuccess is true, stopping iteration of child DAOs");
            break;
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Aggregated possible query attributes '" + queryAttrs + "'"));
        }
        if (queryAttrs == null) {
            return null;
        }
        return Collections.unmodifiableSet(queryAttrs);
    }

    public final IAttributeMerger getMerger() {
        return this.attrMerger;
    }

    public final void setMerger(IAttributeMerger merger) {
        Validate.notNull((Object)merger, (String)"The IAttributeMerger cannot be null");
        this.attrMerger = merger;
    }

    public final List<IPersonAttributeDao> getPersonAttributeDaos() {
        return this.personAttributeDaos;
    }

    @Required
    public final void setPersonAttributeDaos(List<IPersonAttributeDao> daos) {
        Validate.notNull(daos, (String)"The IPersonAttributeDao List cannot be null");
        this.personAttributeDaos = Collections.unmodifiableList(daos);
    }

    public final boolean isRecoverExceptions() {
        return this.recoverExceptions;
    }

    public final void setRecoverExceptions(boolean recover) {
        this.recoverExceptions = recover;
    }

    public boolean isStopOnSuccess() {
        return this.stopOnSuccess;
    }

    public void setStopOnSuccess(boolean stopOnSuccess) {
        this.stopOnSuccess = stopOnSuccess;
    }
}

