/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.adaptors.generic;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.security.GeneralSecurityException;
import javax.security.auth.login.AccountNotFoundException;
import javax.security.auth.login.FailedLoginException;
import javax.validation.constraints.NotNull;
import org.apache.commons.io.IOUtils;
import org.jasig.cas.authentication.Credential;
import org.jasig.cas.authentication.HandlerResult;
import org.jasig.cas.authentication.PreventedException;
import org.jasig.cas.authentication.UsernamePasswordCredential;
import org.jasig.cas.authentication.handler.support.AbstractUsernamePasswordAuthenticationHandler;
import org.jasig.cas.authentication.principal.Principal;
import org.jasig.cas.authentication.principal.SimplePrincipal;
import org.springframework.core.io.Resource;

public class FileAuthenticationHandler
extends AbstractUsernamePasswordAuthenticationHandler {
    private static final String DEFAULT_SEPARATOR = "::";
    @NotNull
    private String separator = "::";
    @NotNull
    private Resource fileName;

    protected final HandlerResult authenticateUsernamePasswordInternal(UsernamePasswordCredential credential) throws GeneralSecurityException, PreventedException {
        try {
            String username = credential.getUsername();
            String passwordOnRecord = this.getPasswordOnRecord(username);
            if (passwordOnRecord == null) {
                throw new AccountNotFoundException(username + " not found in backing file.");
            }
            if (credential.getPassword() != null && this.getPasswordEncoder().encode(credential.getPassword()).equals(passwordOnRecord)) {
                return this.createHandlerResult((Credential)credential, (Principal)new SimplePrincipal(username), null);
            }
        }
        catch (IOException e) {
            throw new PreventedException("IO error reading backing file", (Throwable)e);
        }
        throw new FailedLoginException();
    }

    public final void setFileName(Resource fileName) {
        this.fileName = fileName;
    }

    public final void setSeparator(String separator) {
        this.separator = separator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getPasswordOnRecord(String username) throws IOException {
        String string;
        String line;
        BufferedReader bufferedReader = null;
        try {
            bufferedReader = new BufferedReader(new InputStreamReader(this.fileName.getInputStream()));
            line = bufferedReader.readLine();
            while (line != null) {
                String[] lineFields = line.split(this.separator);
                String userOnRecord = lineFields[0];
                String passOnRecord = lineFields[1];
                if (!username.equals(userOnRecord)) break block4;
                string = passOnRecord;
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(bufferedReader);
            throw throwable;
        }
        {
            block4: {
                IOUtils.closeQuietly((Reader)bufferedReader);
                return string;
            }
            line = bufferedReader.readLine();
            continue;
        }
        IOUtils.closeQuietly((Reader)bufferedReader);
        return null;
    }
}

